from Providers import ProviderContainer
from DataManagers import DataManager
from Products.PlugIns import PlugInContainer, PlugInGroup, \
    defaultConstructors, genericAddForm
from Globals import DTMLFile, default__class_init__
from OFS.Folder import Folder

_marker = []

class Customizer(DataManager):
    """DataManager for non-rackmounted DataSkins"""

    __plugin_kind__ = "Customizer"
    meta_type = "Customizer"
    MetaTypes = ()
    
    manage_typesForm = DTMLFile('www/typesForm', globals())

    manage_options_left = (
        {'label':'Customize Types','action':'manage_typesForm'},
    ) + DataManager.manage_options_left
    
    def namesForRegistration(self, container):
        return self.MetaTypes

    def _isSelected(self, name, path, klass):
        return klass._zclass_.meta_type in self.MetaTypes
        
    def manage_setTypes(self, meta_types=(), REQUEST=None):
        """Change types applicable to this Customizer"""
        self.MetaTypes = meta_types
        self.aq_inner.aq_parent.manage_refreshPlugIns()
        if REQUEST is not None:
            return self.manage_typesForm(self, REQUEST,
                manage_tabs_message="Types updated.")

    __ac_permissions__ = (
        ('View management screens',
            ('manage_typesForm','manage_setTypes')
        ),
    )
    _initialized = 0
    
    def _setup(self):
        # set up default providers
        
        if self._initialized:
            # We must only initialize once, since _setup gets called on pastes,
            # imports, etc.
            return

        from Providers import LinkToParentProviders
        self._installPlugIn(
            LinkToParentProviders('ParentPlugIns', 
                title='Plug-ins from parent Folder w/Customization Support')
        )
        
        from SheetProviders import SheetProvider
        self._installPlugIn(
            SheetProvider('PersistentSheets', title='Sheets stored in ZODB w/objects')
        )
        
        self._initialized = 1



















class CustomizerGroup(PlugInGroup):
    """
    PlugInGroup that manages the more complex registration needs 
    of Customizers and their containers.
    """

    def _PlugInsChanged(self, container, plugins=()):

        """Update the registry of customizer names"""

        custs = container.__customizerRegistry__ = {}

        for plugin in plugins:

            for n in plugin.namesForRegistration(container):
                if not custs.has_key(n):
                    custs[n]=plugin


    def manage_registry(self):
        """ """
        return self.aq_parent.__customizerRegistry__.items()

    manage_below = DTMLFile('www/showCustomizers', globals())

    __ac_permissions__ = (
        ('View management screens',
            ('manage_registry','manage_below')
        ),
    )


default__class_init__(Customizer)
default__class_init__(CustomizerGroup)







class CustomizerFolder(ProviderContainer,PlugInContainer):

    """Folder which can contain objects managed by Customizers"""

    Customizers_ = CustomizerGroup(
        'Customizers_',
        ['Customizer'],
        attr='__customizerList__', 
        title='Customizers'
    )

    __plugin_groups__ = (Customizers_,) + ProviderContainer.__plugin_groups__

    __customizerList__ = ()
    __customizerRegistry__ = {}

    meta_type = "Folder w/Customizer Support"
    
    # We want to look like a folder, but with extra tabs after 'Contents'

    manage_options_left = Folder.manage_options[:1]
    manage_options_right = Folder.manage_options[1:]

    def _getDataManagerFor(self,client,default=None):

        """Determine data manager based on client's meta_type"""

        dm = self.__customizerRegistry__.get(client.meta_type, _marker)
        if dm is not _marker:
            return dm.__of__(self)._getDataManagerFor(client)   # forward to DM

        try:
            _gdmf = self.aq_inner.aq_parent.aq_acquire('_getDataManagerFor')
        except AttributeError:
            return default

        return _gdmf(client,default)

default__class_init__(CustomizerFolder)


manage_addCustomizerFolderForm = genericAddForm(CustomizerFolder,globals())

def manage_addCustomizerFolder(self, id, title='', REQUEST=None):
    """Add a CustomizerFolder"""
    self._setObject(id, CustomizerFolder(id, title))
    if REQUEST: return self.manage_main(self,REQUEST,update_menu=1)



def initialize(context):

    context.registerPlugInClass(
        Customizer,
        permission = 'Add Customizers',
        constructors = defaultConstructors(Customizer,globals()),
        icon = 'www/customizer.gif'
    )

    context.registerClass(
        CustomizerFolder,
        permission = 'Add Folders w/Customizer Support',
        constructors = (manage_addCustomizerFolderForm,
                        manage_addCustomizerFolder),
        icon = 'www/custfolder.gif'
    )

