/*____________________________________________________________________________

    Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

    Portions Copyright (C) 1999-2000 EMusic.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: musicbrowser.cpp,v 1.2 2003/09/16 17:35:31 kgk Exp $
____________________________________________________________________________*/
#include <algorithm>
#include <musicbrainz/bitzi/bitcollider.h>
#include <string>
#include <vector>
#include <iostream>

using namespace std;
#include "musicbrowserui.h"
#include "gtkmusicbrowser.h" 
#include "eventdata.h"
#include "player.h"
#include "pmo.h"


extern "C" {

UserInterface *Initialize(FAContext *context) {
    return new MusicBrowser(context);
}
           }

MusicBrowser::MusicBrowser(FAContext *context)
{
    // important, initialize all class variables every time!
    // m_playerEQ
    m_context = context;
    isVisible = false;
    m_propManager = NULL;
    m_startupType = 0;
    m_initialized = false;
    mainBrowser = NULL;
}

MusicBrowser::~MusicBrowser()
{
  if( mainBrowser )
    delete mainBrowser;
}

Error MusicBrowser::Init(int32_t startup_level) 
{
    if ((m_startupType = startup_level) != SECONDARY_UI_STARTUP) {
        cout << _("The musicbrowser cannot run as the primary ui\n"); 
        return kError_InitFailedSafely;
    }

    if (!getenv("DISPLAY"))
        return kError_InitFailedSafely;

    m_playerEQ = m_context->target;

    char *fadir = ZinfDir(NULL);
    string URL = string("file://") + string(fadir) +
                 string("/currentlist.m3u");
    delete [] fadir;

	m_gtk_main = new Gtk::Main(m_context->argc, m_context->argv);
    mainBrowser = new GTKBrowserMusic(m_context, this, URL, true);
	
    return kError_NoErr;
}

Error MusicBrowser::AcceptEvent(Event *event)
{
    switch (event->Type()) {
        case CMD_Cleanup: {
            mainBrowser->Close(false, true, true);

            while (browserWindows.size() > 0) {
                browserWindows[0]->Close(false, true, true);
                delete browserWindows[0];
                browserWindows.erase(browserWindows.begin());
            }

            m_playerEQ->AcceptEvent(new Event(INFO_ReadyToDieUI));
            break; }
        case CMD_ToggleMusicBrowserUI: {
            if (mainBrowser->Visible())
                mainBrowser->Close(false);
            else
                mainBrowser->ShowMusicBrowser();
            break; }
        case CMD_AddFiles:
        case CMD_EditCurrentPlaylistItemInfo:
        case INFO_MusicCatalogRegenerating:
        case INFO_MusicCatalogDoneRegenerating:
        case INFO_PlaylistCurrentItemInfo:
        case INFO_PlaylistItemsUpdated:
        case INFO_PlaylistItemMoved:
        case INFO_CDDiscStatus: 
        case INFO_SearchMusicDone:
        case INFO_BrowserMessage:
        case INFO_PrefsChanged: {
            mainBrowser->AcceptEvent(event);
            vector<GTKBrowserMusic *>::iterator i = browserWindows.begin();
            for (; i != browserWindows.end(); i++)
                    (*i)->AcceptEvent(event);
            break; }
        case INFO_PlaylistItemAdded:
        case INFO_PlaylistItemsAdded:
        case INFO_PlaylistItemRemoved:
        case INFO_PlaylistRepeat:
        case INFO_PlaylistShuffle:
        case INFO_PlaylistSorted:
        case INFO_Paused:
        case INFO_Stopped:
        case INFO_Playing:
        case INFO_MusicCatalogCleared:
        case INFO_MusicCatalogPlaylistAdded:
        case INFO_MusicCatalogPlaylistRemoved:
        case INFO_MusicCatalogStreamAdded:
        case INFO_MusicCatalogStreamRemoved:
        case INFO_MusicCatalogTrackChanged:
        case INFO_MusicCatalogTrackRemoved: 
        case INFO_MusicCatalogTrackAdded: {
            if (mainBrowser->Visible())
                mainBrowser->AcceptEvent(event);
            vector<GTKBrowserMusic *>::iterator i = browserWindows.begin();
            for (; i != browserWindows.end(); i++)
                if ((*i)->Visible())
                    (*i)->AcceptEvent(event);
            break; }
        //case INFO_FileNotFound:
        //case INFO_CDNotFound:
        //case INFO_DatabaseUpgraded:
        default:
            break;
    }
    return kError_NoErr;
}

void MusicBrowser::CreateNewEditor(string &newPlaylist, bool cd_mode)
{
    GTKBrowserMusic *newUI = new GTKBrowserMusic(m_context, this, newPlaylist,
                                                 false);
    gdk_threads_leave();
    newUI->ShowMusicBrowser();
    gdk_threads_enter();
    browserWindows.push_back(newUI);
}

void MusicBrowser::WindowClose(GTKBrowserMusic *oldUI)
{
    vector<GTKBrowserMusic *>::iterator
        loc = find(browserWindows.begin(), browserWindows.end(), oldUI);

    if (loc != browserWindows.end()) {
        delete *loc;
        browserWindows.erase(loc);
    }
}
/* arch-tag: 4889d73b-9d76-486d-99f4-11b679713c4d */
