#ifndef _INCLUDED_GTKPLAYLISTNOTEBOOK_H_
#define _INCLUDED_GTKPLAYLISTNOTEBOOK_H_

#include <string>
#include <gtkmm/notebook.h>
#include <glibmm/ustring.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/label.h>
#include <gtkmm/menu.h>

#include "facontext.h"
#include "event.h"
#include "error.h"
#include "playlist.h"
#include "gtkplaylist.h"
#include "musiclayout.h"


class GTKBrowserMusic;
class GTKPlaylistNotebook : public Gtk::Notebook {
 public:
	GTKPlaylistNotebook(FAContext *context, PlaylistManager *CurrentPlaylist, GTKBrowserMusic *musicbrowser);
	~GTKPlaylistNotebook();
	
	Error AcceptEvent(Event *event);
	void set_layout(MusicLayout *layout);
 
	void NewPlaylist();
	void OpenPlaylist(std::string Filename);
	void SavePlaylistAs(std::string Filename, int playlist_num = -1);
	void SavePlaylist(int playlist_num = -1, bool in_main = true);
 	void RevertToSavedPlaylist(int playlist_num = -1);
 
 	void CheckCurrentIndex();
 	void DoEditTrack();
 	void DoRemove();
 	void ClearPlaylist(int playlist_num = -1);
 
 	bool CheckClosePlaylist(int playlist_num = -1);
	void ClosePlaylist(int playlist_num = -1);
 	void SetCanClosePlaylist(int playlist_num = -1);
 
  	//Reimplimented functions
	Glib::ustring get_tab_label_text(int page_num);
	void show_page(int page_num);
 	bool has_focus();
	
 private:
	//Internal Variables
	FAContext *m_context;
	GTKBrowserMusic *m_musicbrowser;
	std::vector<GTKPlaylist *> m_playlists;
 	uint32_t new_playlist_count;
	
	//Internal Functions 
 	GTKPlaylist* CreatePlaylist(PlaylistManager *NewPLM = NULL);
 	int AddPlaylist(GTKPlaylist *playlist, Glib::ustring Caption);
 
 	//Tab Labels
 	class GTKTab;
	std::vector<GTKTab *> m_tabs;
	
 protected:
	//UI Events
	virtual void on_switch_page (GtkNotebookPage* page, guint page_num);
}; 

class GTKPlaylistNotebook::GTKTab : public Gtk::HBox {
 public:
	GTKTab(GTKPlaylistNotebook *notebook, Glib::ustring Text, GTKPlaylist* child);
 
 	//Tab Properties
 	void SetFilename(std::string Filename);
 	std::string GetFilename() { return m_filename; }
	Glib::ustring get_text() { return m_TabLabel.get_text(); }
	int page() { return m_notebook->page_num(*m_child); }
	
 private:
	//Internal Variables
 	GTKPlaylistNotebook *m_notebook;
 	std::string m_filename;
 	GTKPlaylist *m_child;
 
	//Displayed Widgets
 	Gtk::Label m_TabLabel;
	Gtk::Button m_TabButton;
 	Gtk::Menu m_TabMenu;
 
 	//Menu Events
 	bool on_show_menu(GdkEventButton *event);
 	void on_menu_close();
 	void on_menu_play();
 	void on_menu_clear();
 	void on_menu_save();
 	void on_menu_save_as();
 	void on_menu_revert();
};
#endif
/* arch-tag: edf56562-a1ef-4ad6-a831-800cefa0d739 */
