#ifndef _INCLUDED_GTKMUSICLIST_H_
#define _INCLUDED_GTKMUSICLIST_H_

#include <vector>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treestore.h>
#include <glibmm/refptr.h>

class GTKMusicList : public Gtk::ScrolledWindow {
 public:
 	GTKMusicList();
	
 	//Reimplemented functions
 	bool has_focus() { return m_listMusic.has_focus(); }
 protected:
 	//Init Functions
 	void set_list_model_columns(Gtk::TreeModel::ColumnRecord *Columns);
 	void set_tree_model_columns(Gtk::TreeModel::ColumnRecord *Columns);
	
	//Virtual Functions That Should Be Handled By SubClasses
 	virtual void set_list_columns() {}
 	//Event Functions
 	virtual void row_activated(Gtk::TreeModel::Path RowPath) {}
 	virtual void cursor_changed(Gtk::TreeModel::Path CursorPath) {}
	virtual void selection_changed(Glib::RefPtr<Gtk::TreeView::Selection> selection) {}
 	virtual void set_rows_data(std::vector<Gtk::TreeModel::Path> RowPaths) {}
	virtual void show_menu(guint button, guint32 time) {}
	
	//Signal Handlers That Can Be Trigged Manually
	void scrolledwindow_changed_visible();
	
	//Variables Needed By SubClasses
	//We Need To Override signal handler of TreeView for menu events
	//Other signals handled as normal using signal.connect()
	class OwnTreeView : public Gtk::TreeView {
	 public:
		GTKMusicList *m_parent;
	 protected:
		virtual bool on_button_press_event(GdkEventButton *event);
 	};
	OwnTreeView m_listMusic;
	Glib::RefPtr<Gtk::ListStore> m_listmodelMusic;
	Glib::RefPtr<Gtk::TreeStore> m_treemodelMusic;
	
	Gtk::TreeModel::Path m_path_menu_shown_for;
	
 private:
	//Signal Handlers
 	void list_cursor_changed();
 	void list_row_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn* column);
 	void list_selection_changed();
 };
 
 #endif
/* arch-tag: 9d4ea504-7f80-42e7-b31a-e739128c5981 */
