#ifndef _INCLUDED_GTKLIBRARYLIST_H_
#define _INCLUDED_GTKLIBRARYLIST_H_

#include <gtkmm/treeiter.h>
#include <gtkmm/treepath.h>
#include <glibmm/refptr.h>
#include <gtkmm/treeselection.h>

#include <time.h>
#include "gtkmusiclist.h"
#include "cataloginfo.h"
#include "gtklibrary.h"
#include "facontext.h"

class GTKLibrary::GTKLibraryList : public GTKMusicList {
 public:
	GTKLibraryList(GTKLibrary *library);
	virtual ~GTKLibraryList();
 
	void SetParent(CatalogInfo *parent);
 	void Refresh();
	void Clear();
 
 protected:
	//Internal Variables
 	FAContext *m_context;
 	GTKLibrary *m_library;
 	CatalogInfo *m_parent;
 	time_t last_parent_change;
 
	//Internal Functions
 	virtual void show_menu(guint button, guint32 time);
	virtual void row_activated(Gtk::TreeModel::Path RowPath);
	virtual void selection_changed(Glib::RefPtr<Gtk::TreeView::Selection> selection);
 
 	//Reimplemented Functions
 	virtual void init_row(Gtk::TreeModel::Row& new_row) {}
};

#endif
/* arch-tag: beeb309d-2640-4ec0-88fb-9bb8421ecd75 */
