#ifndef INCLUDED_DIALOGS_H_
#define INCLUDED_DIALOGS_H_

#include <string>
#include <gtkmm/fileselection.h>
#include <gtkmm/messagedialog.h>
#include <glibmm/thread.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/entry.h>
#include "facontext.h"

class MusicFileSelector : public Gtk::FileSelection {
public:
    MusicFileSelector(FAContext *context, std::string caption = "");

private:
	FAContext *m_context;
 	bool set_last_dir;
 
 	//Saves Current Dir
    void on_response(int response);
};

class MusicMessageDialog : public Gtk::MessageDialog {
public:
	MusicMessageDialog(const Glib::ustring& message, Gtk::MessageType type=Gtk::MESSAGE_INFO, Gtk::ButtonsType buttons=Gtk::BUTTONS_OK, bool modal=false, bool use_separator=false) : MessageDialog(message, type, buttons, modal, use_separator) {}
	
	//Reimplemented run function that supports not being in main loop
	int run(bool in_main);

protected:
	virtual void on_response(int response);
private:
	Glib::Mutex response_mutex;
 	Glib::Cond response_cond;
 	int m_response;
};

class MusicInputDialog : public Gtk::Dialog {
public:
	MusicInputDialog(const Glib::ustring& caption, const Glib::ustring& prompt);
 
 	void set_entry_text(Glib::ustring entry);
 	Glib::ustring get_entry_text();
 
 	//Reimplemented run function that supports not being in main loop
	int run(bool in_main);
protected:
	virtual void on_response(int response);
private:
	//Shown Widgets
 	Gtk::HBox m_dialog_layout;
 	Gtk::VBox m_dialog_entry_layout;
 	Gtk::Image m_dialog_pic;
 	Gtk::Label m_dialog_label;
 	Gtk::Entry m_dialog_entry;
 
 	//Extra Signal Handlers
 	void entry_activated();
	
 	//Non Main Loop Stuff
	Glib::Mutex response_mutex;
 	Glib::Cond response_cond;
 	int m_response;
};

#if 0
class MusicSearchDialog : public Gtk::Dialog 
{
public:
private:
 	Gtk::HBox m_hlayout;
 	Gtk::VBox m_vlayout;
 	Gtk::Image m_dialog_pic;
 	Gtk::Label m_dialog_label;
 	Gtk::Entry m_dialog_entry;
};

#endif

#endif
/* arch-tag: 5184706d-858b-4a13-80d5-1f903223b2bd */
