/*
 * Decompiled with CFR 0.152.
 */
import Ice.Communicator;
import Ice.ConnectTimeoutException;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.ObjectPrx;
import Ice.TimeoutException;
import Ice.Util;
import Test.AMI_Timeout_sendData;
import Test.AMI_Timeout_sleep;
import Test.TimeoutPrx;
import Test.TimeoutPrxHelper;
import java.io.PrintStream;

public class AllTests {
    private static void test(boolean b) {
        if (!b) {
            throw new RuntimeException();
        }
    }

    public static TimeoutPrx allTests(Communicator communicator, PrintStream out) {
        byte[] seq;
        String sref = "timeout:default -p 12010 -t 10000";
        ObjectPrx obj = communicator.stringToProxy(sref);
        AllTests.test(obj != null);
        TimeoutPrx timeout = TimeoutPrxHelper.checkedCast((ObjectPrx)obj);
        AllTests.test(timeout != null);
        out.print("testing connect timeout... ");
        out.flush();
        TimeoutPrx to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(500));
        to.holdAdapter(2000);
        to.ice_getConnection().close(true);
        try {
            to.op();
            AllTests.test(false);
        }
        catch (ConnectTimeoutException ex) {
            // empty catch block
        }
        timeout.op();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(1000));
        to.holdAdapter(500);
        to.ice_getConnection().close(true);
        try {
            to.op();
        }
        catch (ConnectTimeoutException ex) {
            AllTests.test(false);
        }
        out.println("ok");
        out.print("testing read timeout... ");
        out.flush();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(500));
        try {
            to.sleep(750);
            AllTests.test(false);
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        timeout.op();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(1500));
        try {
            to.sleep(500);
        }
        catch (TimeoutException ex) {
            AllTests.test(false);
        }
        out.println("ok");
        out.print("testing write timeout... ");
        out.flush();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(500));
        to.holdAdapter(2000);
        try {
            seq = new byte[100000];
            to.sendData(seq);
            AllTests.test(false);
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        timeout.op();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(1500));
        to.holdAdapter(500);
        try {
            seq = new byte[524288];
            to.sendData(seq);
        }
        catch (TimeoutException ex) {
            AllTests.test(false);
        }
        out.println("ok");
        out.print("testing AMI read timeout... ");
        out.flush();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(500));
        AMI_Timeout_sleep cb = new AMISleepEx();
        to.sleep_async(cb, 2000);
        AllTests.test(cb.check());
        timeout.op();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(1500));
        cb = new AMISleep();
        to.sleep_async(cb, 500);
        AllTests.test(cb.check());
        out.println("ok");
        out.print("testing AMI write timeout... ");
        out.flush();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(500));
        to.holdAdapter(2000);
        seq = new byte[524288];
        AMI_Timeout_sendData cb2 = new AMISendDataEx();
        to.sendData_async(cb2, seq);
        AllTests.test(cb2.check());
        timeout.op();
        to = TimeoutPrxHelper.uncheckedCast((ObjectPrx)obj.ice_timeout(1500));
        to.holdAdapter(500);
        seq = new byte[524288];
        cb2 = new AMISendData();
        to.sendData_async(cb2, seq);
        AllTests.test(cb2.check());
        out.println("ok");
        out.print("testing timeout overrides... ");
        out.flush();
        String[] args = new String[]{};
        InitializationData initData = new InitializationData();
        initData.properties = communicator.getProperties()._clone();
        initData.properties.setProperty("Ice.Override.Timeout", "500");
        Communicator comm = Util.initialize((String[])args, (InitializationData)initData);
        TimeoutPrx to2 = TimeoutPrxHelper.checkedCast((ObjectPrx)comm.stringToProxy(sref));
        try {
            to2.sleep(750);
            AllTests.test(false);
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        timeout.op();
        to2 = TimeoutPrxHelper.checkedCast((ObjectPrx)to2.ice_timeout(1000));
        try {
            to2.sleep(750);
            AllTests.test(false);
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        comm.destroy();
        args = new String[]{};
        initData = new InitializationData();
        initData.properties = communicator.getProperties()._clone();
        initData.properties.setProperty("Ice.Override.ConnectTimeout", "1000");
        comm = Util.initialize((String[])args, (InitializationData)initData);
        to2 = TimeoutPrxHelper.uncheckedCast((ObjectPrx)comm.stringToProxy(sref));
        timeout.holdAdapter(3000);
        try {
            to2.op();
            AllTests.test(false);
        }
        catch (ConnectTimeoutException ex) {
            // empty catch block
        }
        timeout.op();
        timeout.holdAdapter(3000);
        to2 = TimeoutPrxHelper.uncheckedCast((ObjectPrx)to2.ice_timeout(3500));
        try {
            to2.op();
            AllTests.test(false);
        }
        catch (ConnectTimeoutException ex) {
            // empty catch block
        }
        timeout.op();
        to2.op();
        try {
            to2.sleep(4000);
            AllTests.test(false);
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        comm.destroy();
        out.println("ok");
        return timeout;
    }

    private static class AMISleepEx
    extends AMI_Timeout_sleep {
        private Callback callback = new Callback();

        private AMISleepEx() {
        }

        public void ice_response() {
            AllTests.test(false);
        }

        public void ice_exception(LocalException ex) {
            AllTests.test(ex instanceof TimeoutException);
            this.callback.called();
        }

        public boolean check() {
            return this.callback.check();
        }
    }

    private static class AMISleep
    extends AMI_Timeout_sleep {
        private Callback callback = new Callback();

        private AMISleep() {
        }

        public void ice_response() {
            this.callback.called();
        }

        public void ice_exception(LocalException ex) {
            AllTests.test(false);
        }

        public boolean check() {
            return this.callback.check();
        }
    }

    private static class AMISendDataEx
    extends AMI_Timeout_sendData {
        private Callback callback = new Callback();

        private AMISendDataEx() {
        }

        public void ice_response() {
            AllTests.test(false);
        }

        public void ice_exception(LocalException ex) {
            AllTests.test(ex instanceof TimeoutException);
            this.callback.called();
        }

        public boolean check() {
            return this.callback.check();
        }
    }

    private static class AMISendData
    extends AMI_Timeout_sendData {
        private Callback callback = new Callback();

        private AMISendData() {
        }

        public void ice_response() {
            this.callback.called();
        }

        public void ice_exception(LocalException ex) {
            AllTests.test(false);
        }

        public boolean check() {
            return this.callback.check();
        }
    }

    private static class Callback {
        private boolean _called = false;

        Callback() {
        }

        public synchronized boolean check() {
            while (!this._called) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException ex) {
                    continue;
                }
                if (this._called) continue;
                return false;
            }
            this._called = false;
            return true;
        }

        public synchronized void called() {
            assert (!this._called);
            this._called = true;
            this.notify();
        }
    }
}

