/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.common.ShadowPopup;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public final class Options {
    private static final Map LAF_REPLACEMENTS = new HashMap();
    private static final Boolean USE_SYSTEM_FONTS_SYSTEM_VALUE;
    private static final Boolean USE_NARROW_BUTTONS_SYSTEM_VALUE;
    private static final Boolean TAB_ICONS_ENABLED_SYSTEM_VALUE;
    private static final Boolean POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE;
    private static final Dimension DEFAULT_ICON_SIZE;

    private Options() {
    }

    public static boolean getUseSystemFonts() {
        return USE_SYSTEM_FONTS_SYSTEM_VALUE != null ? USE_SYSTEM_FONTS_SYSTEM_VALUE : !Boolean.FALSE.equals(UIManager.get("Application.useSystemFontSettings"));
    }

    public static void setUseSystemFonts(boolean useSystemFonts) {
        UIManager.put("Application.useSystemFontSettings", useSystemFonts);
    }

    public static Dimension getDefaultIconSize() {
        Dimension size = UIManager.getDimension("jgoodies.defaultIconSize");
        return size == null ? DEFAULT_ICON_SIZE : size;
    }

    public static void setDefaultIconSize(Dimension defaultIconSize) {
        UIManager.put("jgoodies.defaultIconSize", defaultIconSize);
    }

    public static boolean getUseNarrowButtons() {
        return USE_NARROW_BUTTONS_SYSTEM_VALUE != null ? USE_NARROW_BUTTONS_SYSTEM_VALUE : !Boolean.FALSE.equals(UIManager.get("jgoodies.useNarrowButtons"));
    }

    public static void setUseNarrowButtons(boolean b) {
        UIManager.put("jgoodies.useNarrowButtons", b);
    }

    public static boolean isTabIconsEnabled() {
        return TAB_ICONS_ENABLED_SYSTEM_VALUE != null ? TAB_ICONS_ENABLED_SYSTEM_VALUE : !Boolean.FALSE.equals(UIManager.get("jgoodies.tabIconsEnabled"));
    }

    public static void setTabIconsEnabled(boolean b) {
        UIManager.put("jgoodies.tabIconsEnabled", b);
    }

    public static boolean isPopupDropShadowActive() {
        return !LookUtils.getToolkitUsesNativeDropShadows() && ShadowPopup.canSnapshot() && Options.isPopupDropShadowEnabled();
    }

    public static boolean isPopupDropShadowEnabled() {
        if (POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE != null) {
            return POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE;
        }
        Object value = UIManager.get("jgoodies.popupDropShadowEnabled");
        return value == null ? Options.isPopupDropShadowEnabledDefault() : Boolean.TRUE.equals(value);
    }

    public static void setPopupDropShadowEnabled(boolean b) {
        UIManager.put("jgoodies.popupDropShadowEnabled", b);
    }

    private static boolean isPopupDropShadowEnabledDefault() {
        return LookUtils.IS_OS_WINDOWS_MODERN;
    }

    public static void putLookAndFeelReplacement(String original, String replacement) {
        LAF_REPLACEMENTS.put(original, replacement);
    }

    public static void removeLookAndFeelReplacement(String original) {
        LAF_REPLACEMENTS.remove(original);
    }

    private static void initializeDefaultReplacements() {
        Options.putLookAndFeelReplacement("javax.swing.plaf.metal.MetalLookAndFeel", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        Options.putLookAndFeelReplacement("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", "com.jgoodies.looks.windows.WindowsLookAndFeel");
    }

    public static String getReplacementClassNameFor(String className) {
        String replacement = (String)LAF_REPLACEMENTS.get(className);
        return replacement == null ? className : replacement;
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    }

    public static String getSystemLookAndFeelClassName() {
        if (LookUtils.IS_OS_WINDOWS) {
            return "com.jgoodies.looks.windows.WindowsLookAndFeel";
        }
        if (LookUtils.IS_OS_MAC) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return Options.getCrossPlatformLookAndFeelClassName();
    }

    static {
        Options.initializeDefaultReplacements();
        USE_SYSTEM_FONTS_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty("swing.useSystemFontSettings", "Use system fonts");
        USE_NARROW_BUTTONS_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty("jgoodies.useNarrowButtons", "Use narrow buttons");
        TAB_ICONS_ENABLED_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty("jgoodies.tabIconsEnabled", "Icons in tabbed panes");
        POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty("jgoodies.popupDropShadowEnabled", "Popup drop shadows");
        DEFAULT_ICON_SIZE = new Dimension(20, 20);
    }
}

