/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Ice.Current;
import Ice.Identity;
import Ice.Util;
import IceGrid.ObjectInfo;
import IceGrid._ObjectObserverDisp;
import IceGridGUI.Coordinator;
import javax.swing.SwingUtilities;

class ObjectObserverI
extends _ObjectObserverDisp {
    private final Coordinator _coordinator;
    private final boolean _trace;

    ObjectObserverI(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._trace = coordinator.traceObservers();
    }

    public synchronized void objectInit(final ObjectInfo[] objects, Current current) {
        if (this._trace) {
            if (objects.length == 0) {
                this._coordinator.traceObserver("objectInit (no object)");
            } else {
                String names = "";
                for (int i = 0; i < objects.length; ++i) {
                    names = names + " " + objects[i].proxy.toString();
                }
                this._coordinator.traceObserver("objectInit for objects" + names);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ObjectObserverI.this._coordinator.objectInit(objects);
            }
        });
    }

    public void objectAdded(final ObjectInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("objectAdded for object " + info.proxy.toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ObjectObserverI.this._coordinator.objectAdded(info);
            }
        });
    }

    public void objectUpdated(final ObjectInfo info, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("objectUpdated for object " + info.proxy.toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ObjectObserverI.this._coordinator.objectUpdated(info);
            }
        });
    }

    public void objectRemoved(final Identity id, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("objectRemoved for object " + Util.identityToString(id));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ObjectObserverI.this._coordinator.objectRemoved(id);
            }
        });
    }
}

