/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.LocalException;
import Ice.UserException;
import IceGrid.AMI_Admin_shutdownRegistry;
import IceGrid.AdminSessionPrx;
import IceGrid.FileIteratorPrx;
import IceGrid.FileIteratorPrxHelper;
import IceGrid.FileNotAvailableException;
import IceGrid.RegistryInfo;
import IceGrid.RegistryNotExistException;
import IceGrid.RegistryUnreachableException;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.ShowLogDialog;
import IceGridGUI.LiveDeployment.SlaveEditor;
import IceGridGUI.LiveDeployment.TreeNode;
import IceGridGUI.Utils;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class Slave
extends TreeNode {
    private final RegistryInfo _info;
    private final String _title;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static SlaveEditor _editor;
    private static JPopupMenu _popup;

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[19];
        actions[16] = true;
        actions[12] = true;
        actions[13] = true;
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRegistry() {
        final String prefix = "Shutting down registry '" + this._id + "'...";
        this.getCoordinator().getStatusBar().setText(prefix);
        AMI_Admin_shutdownRegistry cb = new AMI_Admin_shutdownRegistry(){

            public void ice_response() {
                Slave.this.amiSuccess(prefix);
            }

            public void ice_exception(UserException e) {
                Slave.this.amiFailure(prefix, "Failed to shutdown " + Slave.this._id, e);
            }

            public void ice_exception(LocalException e) {
                Slave.this.amiFailure(prefix, "Failed to shutdown " + Slave.this._id, e.toString());
            }
        };
        try {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.getCoordinator().getAdmin().shutdownRegistry_async(cb, this._id);
        }
        catch (LocalException e) {
            this.failure(prefix, "Failed to shutdown " + this._id, e.toString());
        }
        finally {
            this.getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void retrieveOutput(final boolean stdout) {
        this.getRoot().openShowLogDialog(new ShowLogDialog.FileIteratorFactory(){

            public FileIteratorPrx open(int count) throws FileNotAvailableException, RegistryNotExistException, RegistryUnreachableException {
                AdminSessionPrx session = Slave.this.getCoordinator().getSession();
                FileIteratorPrx result = stdout ? session.openRegistryStdOut(Slave.this._id, count) : session.openRegistryStdErr(Slave.this._id, count);
                if (Slave.this.getCoordinator().getCommunicator().getDefaultRouter() == null) {
                    result = FileIteratorPrxHelper.uncheckedCast(result.ice_endpoints(session.ice_getEndpoints()));
                }
                return result;
            }

            public String getTitle() {
                return "Registry " + Slave.this._title + " " + (stdout ? "stdout" : "stderr");
            }

            public String getDefaultFilename() {
                return Slave.this._id + (stdout ? ".out" : ".err");
            }
        });
    }

    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(12));
            _popup.add(la.get(13));
            _popup.addSeparator();
            _popup.add(la.get(16));
        }
        la.setTarget(this);
        return _popup;
    }

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new SlaveEditor();
        }
        _editor.show(this._info);
        return _editor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/registry.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    Slave(TreeNode parent, RegistryInfo info, String instanceName) {
        super(parent, info.name);
        this._info = info;
        this._title = instanceName + " (" + info.name + ")";
    }
}

