/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.ObjectPrx;
import IceGrid.AdapterDescriptor;
import IceGrid.AdapterDynamicInfo;
import IceGridGUI.LiveDeployment.AdapterEditor;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.Server;
import IceGridGUI.LiveDeployment.Service;
import IceGridGUI.LiveDeployment.TreeNode;
import IceGridGUI.Utils;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class Adapter
extends TreeNode {
    private AdapterDescriptor _descriptor;
    private Utils.Resolver _resolver;
    private String _adapterId;
    private String _currentEndpoints;
    private String _toolTip;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _activeIcon;
    private static Icon _inactiveIcon;
    private static AdapterEditor _editor;

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new AdapterEditor();
        }
        _editor.show(this);
        return _editor;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _activeIcon = Utils.getIcon("/icons/16x16/adapter_active.png");
            _inactiveIcon = Utils.getIcon("/icons/16x16/adapter_inactive.png");
        }
        if (this._currentEndpoints == null || this._currentEndpoints.length() == 0) {
            _cellRenderer.setLeafIcon(_inactiveIcon);
        } else {
            _cellRenderer.setLeafIcon(_activeIcon);
        }
        _cellRenderer.setToolTipText(this._toolTip);
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    Adapter(TreeNode parent, String adapterName, Utils.Resolver resolver, String adapterId, AdapterDescriptor descriptor, ObjectPrx proxy) {
        super(parent, adapterName);
        this._resolver = resolver;
        this._adapterId = adapterId;
        this._descriptor = descriptor;
        this.setCurrentEndpoints(proxy);
    }

    AdapterDescriptor getDescriptor() {
        return this._descriptor;
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    String getCurrentEndpoints() {
        return this._currentEndpoints;
    }

    Map getProperties() {
        if (this._parent instanceof Server) {
            return ((Server)this._parent).getProperties();
        }
        return ((Service)this._parent).getProperties();
    }

    boolean update(AdapterDynamicInfo info) {
        if (info == null) {
            this.setCurrentEndpoints(null);
            this.getRoot().getTreeModel().nodeChanged(this);
            return true;
        }
        if (info.id.equals(this._adapterId)) {
            this.setCurrentEndpoints(info.proxy);
            this.getRoot().getTreeModel().nodeChanged(this);
            return true;
        }
        return false;
    }

    boolean update(List infoList) {
        Iterator p = infoList.iterator();
        while (p.hasNext()) {
            AdapterDynamicInfo info = (AdapterDynamicInfo)p.next();
            if (!this.update(info)) continue;
            return true;
        }
        return false;
    }

    private void setCurrentEndpoints(ObjectPrx proxy) {
        if (proxy == null) {
            this._currentEndpoints = null;
            this._toolTip = "Inactive";
        } else {
            String str = proxy.toString();
            int index = str.indexOf(58);
            this._currentEndpoints = index == -1 || index == str.length() - 1 ? "" : str.substring(index + 1);
            this._toolTip = "Published endpoints: " + this._currentEndpoints;
        }
    }
}

