/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.PropertySetDescriptor;
import IceGrid.ServiceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.ServiceTemplate;
import IceGridGUI.Application.Templates;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JPopupMenu;

class ServiceTemplates
extends Templates {
    private Map _descriptors;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Map copyDescriptors(Map descriptors) {
        HashMap copy = new HashMap();
        Iterator p = descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            copy.put(entry.getKey(), ServiceTemplate.copyDescriptor((TemplateDescriptor)entry.getValue()));
        }
        return copy;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[12] = true;
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && clipboard instanceof TemplateDescriptor) {
            TemplateDescriptor d = (TemplateDescriptor)clipboard;
            actions[14] = d.descriptor instanceof ServiceDescriptor;
        }
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(12));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void newTemplateService() {
        ServiceDescriptor sd = new ServiceDescriptor(new LinkedList(), new PropertySetDescriptor(new String[0], new LinkedList()), new LinkedList(), new String[0], "", "", "");
        this.newServiceTemplate(new TemplateDescriptor(sd, new LinkedList(), new TreeMap()));
    }

    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        TemplateDescriptor td = (TemplateDescriptor)descriptor;
        this.newServiceTemplate(td);
    }

    ServiceTemplates(Root parent, Map descriptors) throws UpdateFailedException {
        super(parent, "Service templates");
        this._descriptors = descriptors;
        Iterator p = this._descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            this.insertChild(new ServiceTemplate(false, this, (String)entry.getKey(), (TemplateDescriptor)entry.getValue()), false);
        }
    }

    Utils.Resolver getResolver() {
        return null;
    }

    void newServiceTemplate(TemplateDescriptor descriptor) {
        ServiceTemplate t;
        block2: {
            String id = this.makeNewChildId("NewServiceTemplate");
            t = new ServiceTemplate(this, id, descriptor);
            try {
                this.insertChild(t, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(t);
    }

    void tryAdd(String newId, TemplateDescriptor descriptor) throws UpdateFailedException {
        this.insertChild(new ServiceTemplate(true, this, newId, descriptor), true);
        this._descriptors.put(newId, descriptor);
    }

    Map getUpdates() {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            ServiceTemplate t = (ServiceTemplate)p.next();
            if (!t.getEditable().isNew() && !t.getEditable().isModified()) continue;
            updates.put(t.getId(), t.getDescriptor());
        }
        return updates;
    }

    void commit() {
        this._editable.commit();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            ServiceTemplate st = (ServiceTemplate)p.next();
            st.commit();
        }
    }

    void update(Map descriptors, String[] removeTemplates) throws UpdateFailedException {
        this.removeChildren(removeTemplates);
        Vector<ServiceTemplate> newChildren = new Vector<ServiceTemplate>();
        Vector<ServiceTemplate> updatedChildren = new Vector<ServiceTemplate>();
        Iterator p = descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String name = (String)entry.getKey();
            TemplateDescriptor templateDescriptor = (TemplateDescriptor)entry.getValue();
            ServiceTemplate child = (ServiceTemplate)this.findChild(name);
            if (child == null) {
                newChildren.add(new ServiceTemplate(false, this, name, templateDescriptor));
                continue;
            }
            child.rebuild(templateDescriptor);
            updatedChildren.add(child);
        }
        this.childrenChanged(updatedChildren);
        this.insertChildren(newChildren, true);
    }

    void removeDescriptor(String id) {
        this._descriptors.remove(id);
    }

    Object getDescriptor() {
        return this._descriptors;
    }

    static {
        $assertionsDisabled = !ServiceTemplates.class.desiredAssertionStatus();
    }
}

