/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import Ice.Identity;
import Ice.IdentityParseException;
import Ice.Util;
import IceGrid.AdaptiveLoadBalancingPolicy;
import IceGrid.ObjectDescriptor;
import IceGrid.OrderedLoadBalancingPolicy;
import IceGrid.RandomLoadBalancingPolicy;
import IceGrid.ReplicaGroupDescriptor;
import IceGrid.RoundRobinLoadBalancingPolicy;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.MapField;
import IceGridGUI.Application.ReplicaGroup;
import IceGridGUI.Application.ReplicaGroups;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ReplicaGroupEditor
extends Editor {
    private static String ORDERED;
    private static String RANDOM;
    private static String ROUND_ROBIN;
    private static String ADAPTIVE;
    private JTextField _id = new JTextField(20);
    private JTextArea _description = new JTextArea(3, 20);
    private JComboBox _loadBalancing = new JComboBox<Object>(new Object[]{ADAPTIVE, ORDERED, RANDOM, ROUND_ROBIN});
    private JTextField _nReplicas = new JTextField(20);
    private JLabel _loadSampleLabel;
    private JComboBox _loadSample = new JComboBox<Object>(new Object[]{"1", "5", "15"});
    private MapField _objects = new MapField((Editor)this, "Identity", "Type", true);
    private LinkedList _objectList;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyUpdate(boolean refresh) {
        ReplicaGroup replicaGroup = (ReplicaGroup)this._target;
        Root root = replicaGroup.getRoot();
        root.disableSelectionListener();
        try {
            if (replicaGroup.isEphemeral()) {
                ReplicaGroups replicaGroups = (ReplicaGroups)replicaGroup.getParent();
                this.writeDescriptor();
                ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)replicaGroup.getDescriptor();
                replicaGroup.destroy();
                try {
                    replicaGroups.tryAdd(descriptor, true);
                }
                catch (UpdateFailedException e) {
                    block19: {
                        try {
                            replicaGroups.insertChild(replicaGroup, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block19;
                            throw new AssertionError();
                        }
                    }
                    root.setSelectedNode(replicaGroup);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean die = false;
                    root.enableSelectionListener();
                    return die;
                }
                this._target = replicaGroups.findChildWithDescriptor(descriptor);
                root.updated();
            } else if (this.isSimpleUpdate()) {
                this.writeDescriptor();
                root.updated();
                replicaGroup.getEditable().markModified();
            } else {
                Object savedDescriptor = replicaGroup.saveDescriptor();
                ReplicaGroups replicaGroups = (ReplicaGroups)replicaGroup.getParent();
                this.writeDescriptor();
                ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)replicaGroup.getDescriptor();
                replicaGroups.removeChild(replicaGroup);
                try {
                    replicaGroups.tryAdd(descriptor, false);
                }
                catch (UpdateFailedException e) {
                    block20: {
                        try {
                            replicaGroups.insertChild(replicaGroup, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block20;
                            throw new AssertionError();
                        }
                    }
                    replicaGroup.restoreDescriptor(savedDescriptor);
                    root.setSelectedNode(this._target);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean bl = false;
                    root.enableSelectionListener();
                    return bl;
                }
                replicaGroups.getEditable().removeElement(replicaGroup.getId(), replicaGroup.getEditable(), ReplicaGroup.class);
                this._target = replicaGroups.findChildWithDescriptor(descriptor);
                root.updated();
                if (refresh) {
                    root.setSelectedNode(this._target);
                }
            }
            if (refresh) {
                root.getCoordinator().getCurrentTab().showNode(this._target);
            }
            this._applyButton.setEnabled(false);
            this._discardButton.setEnabled(false);
            boolean bl = true;
            return bl;
        }
        finally {
            root.enableSelectionListener();
        }
    }

    Utils.Resolver getDetailResolver() {
        Root root = this._target.getRoot();
        if (root.getCoordinator().substitute()) {
            return root.getResolver();
        }
        return null;
    }

    ReplicaGroupEditor() {
        this._loadBalancing.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReplicaGroupEditor.this.updated();
                    Object item = e.getItem();
                    ReplicaGroupEditor.this._loadSampleLabel.setVisible(item == ADAPTIVE);
                    ReplicaGroupEditor.this._loadSample.setVisible(item == ADAPTIVE);
                }
            }
        });
        this._loadBalancing.setToolTipText("<html>Specifies how IceGrid selects adapters and return<br>their endpoints when resolving a replica group ID</html>");
        this._id.getDocument().addDocumentListener(this._updateListener);
        this._id.setToolTipText("Must be unique within this IceGrid deployment");
        this._description.getDocument().addDocumentListener(this._updateListener);
        this._description.setToolTipText("An optional description for this replica group");
        this._nReplicas.getDocument().addDocumentListener(this._updateListener);
        this._nReplicas.setToolTipText("<html>IceGrid returns the endpoints of up to <i>number</i> adapters<br>when resolving a replica group ID.<br>Enter 0 to returns the endpoints of all adapters.</html>");
        this._loadSample.setEditable(true);
        JTextField loadSampleTextField = (JTextField)this._loadSample.getEditor().getEditorComponent();
        loadSampleTextField.getDocument().addDocumentListener(this._updateListener);
        this._loadSample.setToolTipText("Use the load average or CPU usage over the last 1, 5 or 15 minutes?");
    }

    void writeDescriptor() {
        ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)this.getReplicaGroup().getDescriptor();
        descriptor.id = this._id.getText().trim();
        descriptor.description = this._description.getText();
        descriptor.objects = this._objectList;
        Object loadBalancing = this._loadBalancing.getSelectedItem();
        if (loadBalancing == ORDERED) {
            descriptor.loadBalancing = new OrderedLoadBalancingPolicy(this._nReplicas.getText().trim());
        } else if (loadBalancing == RANDOM) {
            descriptor.loadBalancing = new RandomLoadBalancingPolicy(this._nReplicas.getText().trim());
        } else if (loadBalancing == ROUND_ROBIN) {
            descriptor.loadBalancing = new RoundRobinLoadBalancingPolicy(this._nReplicas.getText().trim());
        } else if (loadBalancing == ADAPTIVE) {
            descriptor.loadBalancing = new AdaptiveLoadBalancingPolicy(this._nReplicas.getText().trim(), this._loadSample.getSelectedItem().toString().trim());
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    boolean isSimpleUpdate() {
        ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)this.getReplicaGroup().getDescriptor();
        return descriptor.id.equals(this._id.getText().trim());
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Replica Group ID");
        builder.append((Component)this._id, 3);
        builder.nextLine();
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Well-known Objects");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._objects);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Load Balancing Policy");
        builder.append((Component)this._loadBalancing, 3);
        builder.nextLine();
        builder.append("How many Adapters? (0 = all)");
        builder.append((Component)this._nReplicas, 3);
        builder.nextLine();
        this._loadSampleLabel = builder.append("Load Sample");
        builder.append((Component)this._loadSample, 3);
        builder.nextLine();
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Replica Group Properties");
    }

    protected boolean validate() {
        this._objectList = this.mapToObjectDescriptorSeq(this._objects.get());
        if (this._objectList == null) {
            return false;
        }
        return this.check(new String[]{"Replica Group ID", this._id.getText().trim()});
    }

    void show(ReplicaGroup replicaGroup) {
        this.getProperties();
        this.detectUpdates(false);
        this._target = replicaGroup;
        Utils.Resolver resolver = this.getDetailResolver();
        boolean isEditable = resolver == null;
        ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)replicaGroup.getDescriptor();
        this._id.setText(descriptor.id);
        this._id.setEditable(isEditable);
        this._description.setText(Utils.substitute(descriptor.description, resolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
        this._objects.set(this.objectDescriptorSeqToMap(descriptor.objects), resolver, isEditable);
        this._loadBalancing.setEnabled(true);
        if (descriptor.loadBalancing == null) {
            this._loadBalancing.setSelectedItem(RANDOM);
            this._nReplicas.setText("0");
            this._loadSample.setSelectedItem("1");
        } else if (descriptor.loadBalancing instanceof RandomLoadBalancingPolicy) {
            this._loadBalancing.setSelectedItem(RANDOM);
            this._nReplicas.setText(Utils.substitute(descriptor.loadBalancing.nReplicas, resolver));
            this._loadSample.setSelectedItem("1");
        } else if (descriptor.loadBalancing instanceof OrderedLoadBalancingPolicy) {
            this._loadBalancing.setSelectedItem(ORDERED);
            this._nReplicas.setText(Utils.substitute(descriptor.loadBalancing.nReplicas, resolver));
            this._loadSample.setSelectedItem("1");
        } else if (descriptor.loadBalancing instanceof RoundRobinLoadBalancingPolicy) {
            this._loadBalancing.setSelectedItem(ROUND_ROBIN);
            this._nReplicas.setText(Utils.substitute(descriptor.loadBalancing.nReplicas, resolver));
            this._loadSample.setSelectedItem("1");
        } else if (descriptor.loadBalancing instanceof AdaptiveLoadBalancingPolicy) {
            this._loadBalancing.setSelectedItem(ADAPTIVE);
            this._nReplicas.setText(Utils.substitute(descriptor.loadBalancing.nReplicas, resolver));
            this._loadSample.setSelectedItem(Utils.substitute(((AdaptiveLoadBalancingPolicy)descriptor.loadBalancing).loadSample, resolver));
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        this._nReplicas.setEditable(isEditable);
        this._loadSample.setEditable(isEditable);
        this._loadBalancing.setEnabled(isEditable);
        this._applyButton.setEnabled(replicaGroup.isEphemeral());
        this._discardButton.setEnabled(replicaGroup.isEphemeral());
        this.detectUpdates(true);
        if (replicaGroup.isEphemeral()) {
            this.updated();
        }
    }

    private ReplicaGroup getReplicaGroup() {
        return (ReplicaGroup)this._target;
    }

    private Map objectDescriptorSeqToMap(List objects) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Iterator p = objects.iterator();
        while (p.hasNext()) {
            ObjectDescriptor od = (ObjectDescriptor)p.next();
            result.put(Util.identityToString(od.id), od.type);
        }
        return result;
    }

    private LinkedList mapToObjectDescriptorSeq(Map map) {
        String badIdentities = "";
        LinkedList<ObjectDescriptor> result = new LinkedList<ObjectDescriptor>();
        Iterator p = map.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            try {
                Identity id = Util.stringToIdentity((String)entry.getKey());
                String type = (String)entry.getValue();
                result.add(new ObjectDescriptor(id, type));
            }
            catch (IdentityParseException ex) {
                badIdentities = badIdentities + "- " + (String)entry.getKey() + "\n";
            }
        }
        if (!badIdentities.equals("")) {
            JOptionPane.showMessageDialog(this._target.getCoordinator().getMainFrame(), "The following identities could not be parsed properly:\n" + badIdentities, "Validation failed", 0);
            return null;
        }
        return result;
    }

    static {
        $assertionsDisabled = !ReplicaGroupEditor.class.desiredAssertionStatus();
        ORDERED = "Ordered";
        RANDOM = "Random";
        ROUND_ROBIN = "Round-robin";
        ADAPTIVE = "Adaptive";
    }
}

