/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.PropertySetDescriptor;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.PropertySetEditor;
import IceGridGUI.Application.PropertySetParent;
import IceGridGUI.Application.ServerInstance;
import IceGridGUI.Application.ServerInstancePropertySetEditor;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class PropertySet
extends TreeNode {
    private PropertySetDescriptor _descriptor;
    private String _unsubstitutedId;
    private final boolean _ephemeral;
    private final Editable _editable;
    private final boolean _inServerInstance;
    private PropertySetEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;

    public static PropertySetDescriptor copyDescriptor(PropertySetDescriptor d) {
        PropertySetDescriptor psd = (PropertySetDescriptor)d.clone();
        psd.properties = new LinkedList(psd.properties);
        return psd;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/property_set.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        boolean bl = actions[13] = !this._ephemeral;
        if (((TreeNode)this._parent).getAvailableActions()[14]) {
            actions[14] = true;
        }
        actions[15] = true;
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
        }
        return actions;
    }

    public void copy() {
        this.getCoordinator().setClipboard(PropertySet.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void paste() {
        ((TreeNode)this._parent).paste();
    }

    public void destroy() {
        PropertySetParent parent = (PropertySetParent)((Object)this._parent);
        parent.removePropertySet(this);
        if (!this._ephemeral) {
            parent.removeDescriptor(this._unsubstitutedId);
            if (this._editable != null) {
                parent.getEditable().removeElement(this._unsubstitutedId, this._editable, PropertySet.class);
            } else {
                parent.getEditable().markModified();
            }
            this.getRoot().updated();
        }
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = this._inServerInstance ? (PropertySetEditor)this.getRoot().getEditor(ServerInstancePropertySetEditor.class, this) : (PropertySetEditor)this.getRoot().getEditor(PropertySetEditor.class, this);
        }
        this._editor.show(this._unsubstitutedId, this);
        return this._editor;
    }

    protected Editor createEditor() {
        if (this._inServerInstance) {
            return new ServerInstancePropertySetEditor();
        }
        return new PropertySetEditor();
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    Object getDescriptor() {
        return this._descriptor;
    }

    void commit() {
        if (this._editable != null) {
            this._editable.commit();
        }
    }

    Editable getEditable() {
        if (this._editable != null) {
            return this._editable;
        }
        return ((PropertySetParent)((Object)this._parent)).getEditable();
    }

    PropertySet(boolean brandNew, TreeNode parent, String id, String unsubstitutedId, PropertySetDescriptor descriptor) {
        super(parent, id);
        this._unsubstitutedId = unsubstitutedId;
        this._inServerInstance = parent instanceof ServerInstance;
        this._ephemeral = false;
        this._editable = new Editable(brandNew);
        this.rebuild(descriptor);
    }

    PropertySet(TreeNode parent, String id, String unsubstitutedId, PropertySetDescriptor descriptor) {
        super(parent, id);
        this._unsubstitutedId = unsubstitutedId;
        this._inServerInstance = parent instanceof ServerInstance;
        this._ephemeral = false;
        this._editable = null;
        this.rebuild(descriptor);
    }

    PropertySet(TreeNode parent, String id, PropertySetDescriptor descriptor) {
        super(parent, id);
        this._unsubstitutedId = id;
        this._inServerInstance = parent instanceof ServerInstance;
        this._ephemeral = true;
        this._editable = null;
        this.rebuild(descriptor);
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            PropertySet.writePropertySet(writer, this._unsubstitutedId, this._inServerInstance ? "service" : "id", this._descriptor, null, null);
        }
    }

    void rebuild(PropertySetDescriptor descriptor) {
        this._descriptor = descriptor;
    }
}

