/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.FileException;
import Ice.Identity;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.LocatorPrxHelper;
import Ice.LoggerI;
import Ice.PluginManager;
import Ice.PluginManagerI;
import Ice.RouterPrxHelper;
import Ice.StringSeqHolder;
import Ice.SysLoggerI;
import Ice.Util;
import IceInternal.ConnectionMonitor;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointFactoryManager;
import IceInternal.LocatorManager;
import IceInternal.ObjectAdapterFactory;
import IceInternal.ObjectFactoryManager;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.ProxyFactory;
import IceInternal.ReferenceFactory;
import IceInternal.RouterManager;
import IceInternal.TcpEndpointFactory;
import IceInternal.ThreadPool;
import IceInternal.TraceLevels;
import IceInternal.UdpEndpointFactory;
import IceUtil.Assert;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Instance {
    private int _state = 0;
    private final InitializationData _initData;
    private final TraceLevels _traceLevels;
    private final DefaultsAndOverrides _defaultsAndOverrides;
    private final int _messageSizeMax;
    private final int _clientACM;
    private final int _serverACM;
    private RouterManager _routerManager;
    private LocatorManager _locatorManager;
    private ReferenceFactory _referenceFactory;
    private ProxyFactory _proxyFactory;
    private OutgoingConnectionFactory _outgoingConnectionFactory;
    private ConnectionMonitor _connectionMonitor;
    private ObjectFactoryManager _servantFactoryManager;
    private ObjectAdapterFactory _objectAdapterFactory;
    private ThreadPool _clientThreadPool;
    private ThreadPool _serverThreadPool;
    private final boolean _threadPerConnection;
    private final int _threadPerConnectionStackSize;
    private EndpointFactoryManager _endpointFactoryManager;
    private PluginManager _pluginManager;
    private Map _defaultContext;
    private static Map _emptyContext = new HashMap();
    private static boolean _oneOffDone = false;

    public InitializationData initializationData() {
        return this._initData;
    }

    public TraceLevels traceLevels() {
        return this._traceLevels;
    }

    public DefaultsAndOverrides defaultsAndOverrides() {
        return this._defaultsAndOverrides;
    }

    public synchronized RouterManager routerManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._routerManager;
    }

    public synchronized LocatorManager locatorManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._locatorManager;
    }

    public synchronized ReferenceFactory referenceFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._referenceFactory;
    }

    public synchronized ProxyFactory proxyFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._proxyFactory;
    }

    public synchronized OutgoingConnectionFactory outgoingConnectionFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._outgoingConnectionFactory;
    }

    public synchronized ConnectionMonitor connectionMonitor() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._connectionMonitor;
    }

    public synchronized ObjectFactoryManager servantFactoryManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._servantFactoryManager;
    }

    public synchronized ObjectAdapterFactory objectAdapterFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._objectAdapterFactory;
    }

    public synchronized ThreadPool clientThreadPool() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._clientThreadPool == null) {
            this._clientThreadPool = new ThreadPool(this, "Ice.ThreadPool.Client", 0);
        }
        return this._clientThreadPool;
    }

    public synchronized ThreadPool serverThreadPool() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._serverThreadPool == null) {
            int timeout = this._initData.properties.getPropertyAsInt("Ice.ServerIdleTime");
            this._serverThreadPool = new ThreadPool(this, "Ice.ThreadPool.Server", timeout);
        }
        return this._serverThreadPool;
    }

    public boolean threadPerConnection() {
        return this._threadPerConnection;
    }

    public synchronized EndpointFactoryManager endpointFactoryManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._endpointFactoryManager;
    }

    public synchronized PluginManager pluginManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._pluginManager;
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    public int clientACM() {
        return this._clientACM;
    }

    public int serverACM() {
        return this._serverACM;
    }

    public synchronized void setDefaultContext(Map ctx) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        this._defaultContext = ctx == null || ctx.isEmpty() ? _emptyContext : new HashMap(ctx);
    }

    public synchronized Map getDefaultContext() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return new HashMap(this._defaultContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ObjectAdapterFactory adapterFactory;
        OutgoingConnectionFactory connectionFactory;
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            connectionFactory = this._outgoingConnectionFactory;
            adapterFactory = this._objectAdapterFactory;
        }
        connectionFactory.flushBatchRequests();
        adapterFactory.flushBatchRequests();
    }

    public Identity stringToIdentity(String s) {
        return Util.stringToIdentity(s);
    }

    public String identityToString(Identity ident) {
        return Util.identityToString(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance(Communicator communicator, InitializationData initData) {
        this._initData = initData;
        try {
            if (this._initData.properties == null) {
                this._initData.properties = Util.createProperties();
            }
            Class clazz = Instance.class;
            synchronized (clazz) {
                if (!_oneOffDone) {
                    String stdOut = this._initData.properties.getProperty("Ice.StdOut");
                    String stdErr = this._initData.properties.getProperty("Ice.StdErr");
                    PrintStream outStream = null;
                    if (stdOut.length() > 0) {
                        System.out.close();
                        try {
                            outStream = new PrintStream(new FileOutputStream(stdOut, true));
                        }
                        catch (FileNotFoundException ex) {
                            FileException fe = new FileException();
                            fe.path = stdOut;
                            fe.initCause(ex);
                            throw fe;
                        }
                        System.setOut(outStream);
                    }
                    if (stdErr.length() > 0) {
                        System.err.close();
                        if (stdErr.equals(stdOut)) {
                            System.setErr(outStream);
                        } else {
                            try {
                                System.setErr(new PrintStream(new FileOutputStream(stdErr, true)));
                            }
                            catch (FileNotFoundException ex) {
                                FileException fe = new FileException();
                                fe.path = stdErr;
                                fe.initCause(ex);
                                throw fe;
                            }
                        }
                    }
                    _oneOffDone = true;
                }
            }
            if (this._initData.logger == null) {
                this._initData.logger = this._initData.properties.getPropertyAsInt("Ice.UseSyslog") > 0 ? new SysLoggerI(this._initData.properties.getProperty("Ice.ProgramName")) : new LoggerI(this._initData.properties.getProperty("Ice.ProgramName"), this._initData.properties.getPropertyAsInt("Ice.Logger.Timestamp") > 0);
            }
            this.validatePackages();
            this._traceLevels = new TraceLevels(this._initData.properties);
            this._defaultsAndOverrides = new DefaultsAndOverrides(this._initData.properties);
            int defaultMessageSizeMax = 1024;
            int num = this._initData.properties.getPropertyAsIntWithDefault("Ice.MessageSizeMax", 1024);
            this._messageSizeMax = num < 1 ? 0x100000 : (num > 0x1FFFFF ? Integer.MAX_VALUE : num * 1024);
            this._clientACM = this._initData.properties.getPropertyAsIntWithDefault("Ice.ACM.Client", 60);
            this._serverACM = this._initData.properties.getPropertyAsInt("Ice.ACM.Server");
            this._threadPerConnection = this._initData.properties.getPropertyAsInt("Ice.ThreadPerConnection") > 0;
            int stackSize = this._initData.properties.getPropertyAsInt("Ice.ThreadPerConnection.StackSize");
            if (stackSize < 0) {
                stackSize = 0;
            }
            this._threadPerConnectionStackSize = stackSize;
            this._routerManager = new RouterManager();
            this._locatorManager = new LocatorManager();
            this._referenceFactory = new ReferenceFactory(this, communicator);
            this._proxyFactory = new ProxyFactory(this);
            this._endpointFactoryManager = new EndpointFactoryManager(this);
            TcpEndpointFactory tcpEndpointFactory = new TcpEndpointFactory(this);
            this._endpointFactoryManager.add(tcpEndpointFactory);
            UdpEndpointFactory udpEndpointFactory = new UdpEndpointFactory(this);
            this._endpointFactoryManager.add(udpEndpointFactory);
            this._pluginManager = new PluginManagerI(communicator);
            this._defaultContext = this._initData.defaultContext == null ? _emptyContext : this._initData.defaultContext;
            this._outgoingConnectionFactory = new OutgoingConnectionFactory(this);
            this._servantFactoryManager = new ObjectFactoryManager();
            this._objectAdapterFactory = new ObjectAdapterFactory(this, communicator);
        }
        catch (LocalException ex) {
            this.destroy();
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._state == 2);
        Assert.FinalizerAssert(this._referenceFactory == null);
        Assert.FinalizerAssert(this._proxyFactory == null);
        Assert.FinalizerAssert(this._outgoingConnectionFactory == null);
        Assert.FinalizerAssert(this._connectionMonitor == null);
        Assert.FinalizerAssert(this._servantFactoryManager == null);
        Assert.FinalizerAssert(this._objectAdapterFactory == null);
        Assert.FinalizerAssert(this._clientThreadPool == null);
        Assert.FinalizerAssert(this._serverThreadPool == null);
        Assert.FinalizerAssert(this._routerManager == null);
        Assert.FinalizerAssert(this._locatorManager == null);
        Assert.FinalizerAssert(this._endpointFactoryManager == null);
        Assert.FinalizerAssert(this._pluginManager == null);
        super.finalize();
    }

    public void finishSetup(StringSeqHolder args) {
        PluginManagerI pluginManagerImpl = (PluginManagerI)this._pluginManager;
        pluginManagerImpl.loadPlugins(args);
        if (this._defaultsAndOverrides.defaultRouter.length() > 0) {
            this._referenceFactory.setDefaultRouter(RouterPrxHelper.uncheckedCast(this._proxyFactory.stringToProxy(this._defaultsAndOverrides.defaultRouter)));
        }
        if (this._defaultsAndOverrides.defaultLocator.length() > 0) {
            this._referenceFactory.setDefaultLocator(LocatorPrxHelper.uncheckedCast(this._proxyFactory.stringToProxy(this._defaultsAndOverrides.defaultLocator)));
        }
        int interval = 0;
        if (this._clientACM > 0 && this._serverACM > 0) {
            interval = this._clientACM < this._serverACM ? this._clientACM : this._serverACM;
        } else if (this._clientACM > 0) {
            interval = this._clientACM;
        } else if (this._serverACM > 0) {
            interval = this._serverACM;
        }
        interval = this._initData.properties.getPropertyAsIntWithDefault("Ice.MonitorConnections", interval);
        if (interval > 0) {
            this._connectionMonitor = new ConnectionMonitor(this, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Instance instance = this;
        synchronized (instance) {
            if (this._state != 0) {
                return;
            }
            this._state = 1;
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.shutdown();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.destroy();
        }
        if (this._objectAdapterFactory != null) {
            this._objectAdapterFactory.waitForShutdown();
        }
        if (this._outgoingConnectionFactory != null) {
            this._outgoingConnectionFactory.waitUntilFinished();
        }
        ThreadPool serverThreadPool = null;
        ThreadPool clientThreadPool = null;
        Instance instance2 = this;
        synchronized (instance2) {
            this._objectAdapterFactory = null;
            this._outgoingConnectionFactory = null;
            if (this._connectionMonitor != null) {
                this._connectionMonitor._destroy();
                this._connectionMonitor = null;
            }
            if (this._serverThreadPool != null) {
                this._serverThreadPool.destroy();
                serverThreadPool = this._serverThreadPool;
                this._serverThreadPool = null;
            }
            if (this._clientThreadPool != null) {
                this._clientThreadPool.destroy();
                clientThreadPool = this._clientThreadPool;
                this._clientThreadPool = null;
            }
            if (this._servantFactoryManager != null) {
                this._servantFactoryManager.destroy();
                this._servantFactoryManager = null;
            }
            if (this._referenceFactory != null) {
                this._referenceFactory.destroy();
                this._referenceFactory = null;
            }
            this._proxyFactory = null;
            if (this._routerManager != null) {
                this._routerManager.destroy();
                this._routerManager = null;
            }
            if (this._locatorManager != null) {
                this._locatorManager.destroy();
                this._locatorManager = null;
            }
            if (this._endpointFactoryManager != null) {
                this._endpointFactoryManager.destroy();
                this._endpointFactoryManager = null;
            }
            if (this._pluginManager != null) {
                this._pluginManager.destroy();
                this._pluginManager = null;
            }
            this._state = 2;
        }
        if (clientThreadPool != null) {
            clientThreadPool.joinWithAllThreads();
        }
        if (serverThreadPool != null) {
            serverThreadPool.joinWithAllThreads();
        }
    }

    private void validatePackages() {
        String prefix = "Ice.Package.";
        Map map = this._initData.properties.getPropertiesForPrefix("Ice.Package.");
        Iterator p = map.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry e = p.next();
            String key = (String)e.getKey();
            String pkg = (String)e.getValue();
            if (key.length() == "Ice.Package.".length()) {
                this._initData.logger.warning("ignoring invalid property: " + key + "=" + pkg);
            }
            String module = key.substring("Ice.Package.".length());
            String className = pkg + "." + module + "._Marker";
            try {
                Class.forName(className);
            }
            catch (Exception ex) {
                this._initData.logger.warning("unable to validate package: " + key + "=" + pkg);
            }
        }
    }
}

