/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class XMLWriter {
    private Writer _writer;
    private String _indent;
    private static String _newline;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XMLWriter(File file) throws FileNotFoundException, IOException {
        block2: {
            this._indent = "";
            try {
                this._writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this._writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + _newline);
        this._writer.write("<!-- This file was written by IceGrid Admin -->" + _newline);
    }

    public void writeElement(String name, List attributes) throws IOException {
        this._writer.write(this._indent);
        this._writer.write("<" + name);
        this.writeAttributes(attributes);
        this._writer.write("/>" + _newline);
    }

    public void writeElement(String name, String content) throws IOException {
        this._writer.write(this._indent);
        this._writer.write("<" + name + ">" + this.escape(content) + "</" + name + ">" + _newline);
    }

    public void writeStartTag(String name, List attributes) throws IOException {
        this._writer.write(this._indent);
        this._writer.write("<" + name);
        this.writeAttributes(attributes);
        this._writer.write(">");
        this._writer.write(_newline);
        this.increaseIndent();
    }

    public void writeStartTag(String name) throws IOException {
        this.writeStartTag(name, null);
    }

    public void writeEndTag(String name) throws IOException {
        this.decreaseIndent();
        this._writer.write(this._indent);
        this._writer.write("</" + name + ">" + _newline);
    }

    public void close() throws IOException {
        this._writer.close();
    }

    private void writeAttributes(List attributes) throws IOException {
        if (attributes != null) {
            Iterator p = attributes.iterator();
            while (p.hasNext()) {
                String[] pair = (String[])p.next();
                this._writer.write(" " + pair[0] + "=\"" + pair[1] + "\"");
            }
        }
    }

    private void increaseIndent() {
        this._indent = this._indent + "   ";
    }

    private void decreaseIndent() {
        if (this._indent.length() > 0) {
            this._indent = this._indent.substring(3);
        }
    }

    private String escape(String input) {
        String v = input;
        String allReserved = "<>'\"&";
        boolean hasReserved = false;
        char[] arr = input.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if ("<>'\"&".indexOf(arr[i]) == -1) continue;
            hasReserved = true;
            break;
        }
        if (hasReserved) {
            if (v.indexOf(38) != -1) {
                v = v.replaceAll("&", "&amp;");
            }
            if (v.indexOf(62) != -1) {
                v = v.replaceAll(">", "&gt;");
            }
            if (v.indexOf(60) != -1) {
                v = v.replaceAll("<", "&lt;");
            }
            if (v.indexOf(39) != -1) {
                v = v.replaceAll("'", "&apos;");
            }
            if (v.indexOf(34) != -1) {
                v = v.replaceAll("\"", "&quot;");
            }
        }
        return v;
    }

    static {
        $assertionsDisabled = !XMLWriter.class.desiredAssertionStatus();
        _newline = System.getProperty("line.separator");
    }
}

