/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.UserException;
import IceGrid.ApplicationNotExistException;
import IceGrid.DeploymentException;
import IceGrid.NodeNotExistException;
import IceGrid.NodeUnreachableException;
import IceGrid.PatchException;
import IceGrid.ServerNotExistException;
import IceGrid.ServerStartException;
import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.Root;
import IceGridGUI.TreeNodeBase;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class TreeNode
extends TreeNodeBase {
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract Editor getEditor();

    TreeNode(TreeNode parent, String id) {
        super(parent, id);
    }

    Root getRoot() {
        if (!$assertionsDisabled && this._parent == null) {
            throw new AssertionError();
        }
        return ((TreeNode)this._parent).getRoot();
    }

    public boolean[] getAvailableActions() {
        return new boolean[7];
    }

    public void start() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void stop() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void enable() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void disable() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void shutdownNode() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void patchServer() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void addObject() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected void amiSuccess(final String prefix) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeNode.this.getCoordinator().getStatusBar().setText(prefix + "done.");
            }
        });
    }

    protected void amiFailure(String prefix, String title, UserException e) {
        if (e instanceof ServerNotExistException) {
            ServerNotExistException sne = (ServerNotExistException)e;
            this.amiFailure(prefix, title, "Server '" + sne.id + "' was not registered with the IceGrid Registry");
        } else if (e instanceof ServerStartException) {
            ServerStartException ste = (ServerStartException)e;
            this.amiFailure(prefix, title, "Server '" + ste.id + "' did not start: " + ste.reason);
        } else if (e instanceof ApplicationNotExistException) {
            this.amiFailure(prefix, title, "This application was not registered with the IceGrid Registry");
        } else if (e instanceof PatchException) {
            PatchException pe = (PatchException)e;
            String message = "";
            for (int i = 0; i < pe.reasons.length; ++i) {
                if (message.length() != 0) continue;
                message = message + "\n";
                message = message + pe.reasons[i];
            }
            this.amiFailure(prefix, title, message);
        } else if (e instanceof NodeNotExistException) {
            NodeNotExistException nnee = (NodeNotExistException)e;
            this.amiFailure(prefix, title, "Node '" + nnee.name + " 'was not registered with the IceGrid Registry.");
        } else if (e instanceof NodeUnreachableException) {
            NodeUnreachableException nue = (NodeUnreachableException)e;
            this.amiFailure(prefix, title, "Node '" + nue.name + "' is unreachable: " + nue.reason);
        } else if (e instanceof DeploymentException) {
            DeploymentException de = (DeploymentException)e;
            this.amiFailure(prefix, title, "Deployment exception: " + de.reason);
        } else {
            this.amiFailure(prefix, title, e.toString());
        }
    }

    protected void amiFailure(final String prefix, final String title, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeNode.this.failure(prefix, title, message);
            }
        });
    }

    protected void failure(String prefix, String title, String message) {
        this.getCoordinator().getStatusBar().setText(prefix + "failed!");
        JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), message, title, 0);
    }

    static {
        $assertionsDisabled = !TreeNode.class.desiredAssertionStatus();
    }
}

