/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EMUWRAPPER_H
#define EMUWRAPPER_H

#include <qstring.h>
#include <qthread.h>

struct emuConfig;
class SidTuneMod;

#ifdef SID_WITH_SIDPLAY2
# include <sidplay/sidplay2.h>
//#ifdef SID_HAVE_RESID_BUILDER
# include <sidplay/builders/resid.h>
//#endif
#else
# include <sidplay/player.h>
class emuEngine;
#endif  /* SID_WITH_SIDPLAY2 */
#include "TypeWrapper.h"

class EmuWrapper
{
 public:
    EmuWrapper();
    ~EmuWrapper();
    
    // thread-safe
    static const emuConfig& getConfig();
    static const emuConfig& getConfigDefault();
    static void setConfig(const emuConfig&);
    static void initSong(SidTuneMod*,int);
    static void fillBuffer(SidTuneMod*, ubyte_emuwt* pBuffer, udword_emuwt bufferSize);
    static void stop();
    static void setVoiceVolume(int, ubyte_emuwt, ubyte_emuwt, uword_emuwt);
    static void resetSecondsThisSong();
    static int getSecondsThisSong();
    static int getSecondsTotal();
    static const char* getVersionString();
#ifdef SID_WITH_SIDPLAY2
    static const char* getSpeedString();
    static const char* getSidModelString();
#endif
    
 protected:
    static QString versionString;
    
    static int engines;
    static QMutex emuMutex;
#ifdef SID_WITH_SIDPLAY2
    static sidplay2* pEmuEngine;
    static ReSIDBuilder* pEmuSid;
    static sid2_config_t sid2_cfg;
#else
    static emuEngine* pEmuEngine;
#endif
    static emuConfig myEmuConfig;
    static emuConfig myEmuConfigDefault;
    
 private:
    // prevent copying
    EmuWrapper(const EmuWrapper&);
    EmuWrapper& operator=(EmuWrapper&);  
};

#endif  /* EMUWRAPPER_H */
