/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PLAYLISTEDITDIALOG_H
#define PLAYLISTEDITDIALOG_H

class QPopupMenu;
class Playlist;

#include "PlaylistItem.h"
#include "PlaylistEditDialogData.h"

class PlaylistEditDialog : public PlaylistEditDialogData
{ 
    Q_OBJECT

public:
    PlaylistEditDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~PlaylistEditDialog();

    // Provide a pointer to a playlist.
    // This function -- and most of the other member functions that are
    // called thereafter -- may modify the playlist being pointed to.
    void takeList(Playlist*);
    
    void add(PlaylistItem*);
    
protected:
    Playlist* playlist;
    PlaylistItem curPlaylistItem;  // temp, e.g used for sending signals
        
protected slots:
    void popUpListMenu(QListBoxItem*, const QPoint&);
    void deleteEntry();
    void playEntry();
    void updateEntryFetchTime();
    void savePlaylist();
    void clearPlaylist();
    void moveUpButtonClicked();
    void moveDownButtonClicked();
    void playlistItemSelected(int);
    void playlistItemHighlighted(int);
    void subtuneValueChanged(int);
    void playtimeValueChanged(int);
    void fadeoutValueChanged(int);
    void prevButtonClicked();
    void nextButtonClicked();

 signals:
    void playlistEditPlayRequest(const PlaylistItem&);
    void playlistEditPlayRequest(uint);
    void playlistEditDelRequest(uint);
    void playlistEditClearRequest();
    void playlistEditUpdateRequest(uint);

 private:
    void clear();
    void exchangeItems(uint item1, uint item2);

    const int maxSongs;  // subtune spinbox max. value
    
    QPopupMenu* playlistMenu;
    int saveListMenuID;
};

#endif  /* PLAYLISTEDITDIALOG_H */
