// file      : xsde/cxx/serializer/elements.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef CXX_SERIALIZER_ELEMENTS_HXX
#define CXX_SERIALIZER_ELEMENTS_HXX

#include <sstream>

#include <cxx/elements.hxx>

#include <cxx/serializer/cli.hxx>

namespace CXX
{
  namespace Serializer
  {
    struct Content
    {
      enum Value
      {
        simple,
        complex,
        mixed
      };
    };

    //
    //
    class Context: public CXX::Context
    {
    public:
      Context (std::wostream&,
               SemanticGraph::Schema&,
               CLI::Options const&);

    protected:
      Context (Context& c)
          : CXX::Context (c),
            options (c.options),
            xml_serializer (c.xml_serializer),
            simple_base (c.simple_base),
            complex_base (c.complex_base),
            validation (c.validation),
            exceptions (c.exceptions),
            stl (c.stl)
      {
      }

      Context (Context& c, std::wostream& o)
          : CXX::Context (c, o),
            options (c.options),
            xml_serializer (c.xml_serializer),
            simple_base (c.simple_base),
            complex_base (c.complex_base),
            validation (c.validation),
            exceptions (c.exceptions),
            stl (c.stl)
      {
      }

    public:
      Boolean
      restriction_p (SemanticGraph::Complex& c) const
      {
        if (c.inherits_p () &&
            c.inherits ().is_a<SemanticGraph::Restricts> ())
        {
          // Restriction of anyType is a special case.
          //
          return !c.inherits ().base ().is_a<SemanticGraph::AnyType> ();
        }

        return false;
      }

    public:
      static Content::Value
      content (SemanticGraph::Complex&);

    public:
      static String const&
      ret_type (SemanticGraph::Type&);

      static String const&
      arg_type (SemanticGraph::Type&);

    public:
      // Optional.
      //
      static String const&
      epresent (SemanticGraph::Particle&);

      static String const&
      epresent (SemanticGraph::Attribute&);

      // Sequence.
      //
      static String const&
      enext (SemanticGraph::Particle&);

      static String const&
      enext (SemanticGraph::AnyAttribute&);

      // Choice.
      //
      static String const&
      etag (SemanticGraph::Particle&);

      static String const&
      earm (SemanticGraph::Choice&);

      static String const&
      earm_tag (SemanticGraph::Choice&);

    public:
      static String const&
      eserializer (SemanticGraph::Member&);

      static String const&
      emember (SemanticGraph::Member&);

      // serialize_*
      //
    public:
      static String const&
      eserialize (SemanticGraph::Any&);

      static String const&
      eserialize (SemanticGraph::AnyAttribute&);

    public:
      static String const&
      eimpl (SemanticGraph::Type&);

    public:
      CLI::Options const& options;
      String& xml_serializer;
      String& simple_base;
      String& complex_base;
      Boolean& validation;
      Boolean& exceptions;
      Boolean& stl;

    private:
      CLI::Options const options_;
      String xml_serializer_;
      String simple_base_;
      String complex_base_;
      Boolean validation_;
      Boolean exceptions_;
      Boolean stl_;
    };

    //
    //
    struct RequiredAttributeTest: Traversal::Attribute
    {
      RequiredAttributeTest (Boolean& result)
          : result_ (result)
      {
      }

      virtual Void
      traverse (Type& a)
      {
        if (!result_ && !a.optional ())
          result_ = true;
      }

    private:
      Boolean& result_;
    };


    //
    //
    struct ParticleParamDecl: Traversal::Element,
                              protected virtual Context
    {
      ParticleParamDecl (Context& c, Boolean& first, Boolean name_arg)
          : Context (c), first_ (first), name_arg_ (name_arg)
      {
      }

      virtual Void
      traverse (SemanticGraph::Element& e)
      {
        if (!first_)
          os << "," << endl;
        else
          first_ = false;

        os << fq_name (e.type ()) << "&";

        if (name_arg_)
          os << " " << ename (e);
        else
          os << " /* " << e.name () << " */";
      }

    private:
      Boolean& first_;
      Boolean name_arg_;
    };

    struct AttributeParamDecl: Traversal::Attribute,
                               protected virtual Context
    {
      AttributeParamDecl (Context& c, Boolean& first, Boolean name_arg)
          : Context (c), first_ (first), name_arg_ (name_arg)
      {
      }

      virtual Void
      traverse (Type& a)
      {
        if (!first_)
          os << "," << endl;
        else
          first_ = false;

        os << fq_name (a.type ()) << "&";

        if (name_arg_)
          os << " " << ename (a);
        else
          os << " /* " << a.name () << " */";
      }

    private:
      Boolean& first_;
      Boolean name_arg_;
    };

    struct SerializerParamDecl : Traversal::Complex,
                                 Traversal::List,
                                 protected virtual Context
    {
      SerializerParamDecl (Context& c, Boolean name_arg)
          : Context (c),
            particle_ (c, first_, name_arg),
            attribute_ (c, first_, name_arg),
            first_ (true),
            name_arg_ (name_arg)
      {
        inherits_ >> *this;

        contains_compositor_ >> compositor_ >> contains_particle_;
        contains_particle_ >> particle_;
        contains_particle_ >> compositor_;

        names_ >> attribute_;
      }

      virtual Void
      traverse (SemanticGraph::Complex& c)
      {
        inherits (c, inherits_);

        if (!restriction_p (c))
        {
          names (c, names_);
          contains_compositor (c, contains_compositor_);
        }
      }

      virtual Void
      traverse (SemanticGraph::List& l)
      {
        if (!first_)
          os << "," << endl;
        else
          first_ = false;

        os << fq_name (l.argumented ().type ()) << "&";

        if (name_arg_)
          os << " " << ename (l) << "_item";
        else
          os << " /* " << l.name () << " item */";
      }

    private:
      Traversal::Inherits inherits_;

      Traversal::Compositor compositor_;
      ParticleParamDecl particle_;
      Traversal::ContainsCompositor contains_compositor_;
      Traversal::ContainsParticle contains_particle_;

      AttributeParamDecl attribute_;
      Traversal::Names names_;

      Boolean first_;
      Boolean name_arg_;
    };
  }
}

#endif  // CXX_SERIALIZER_ELEMENTS_HXX
