// file      : xsde/cxx/serializer/element-validation-source.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <cxx/serializer/element-validation-source.hxx>

#include <xsd-frontend/semantic-graph.hxx>
#include <xsd-frontend/traversal.hxx>

namespace CXX
{
  namespace Serializer
  {
    namespace
    {
      struct AnyTest: Traversal::Any,
                      protected virtual Context
      {
        AnyTest (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (SemanticGraph::Any& a)
        {
          String const& ns (a.definition_namespace ().name ());

          for (SemanticGraph::Any::NamespaceIterator i (a.namespace_begin ()),
                 e (a.namespace_end ()); i != e;)
          {
            if (*i == L"##any")
            {
              if (stl)
                os << "!name.empty ()";
              else
                os << "(name != 0 && *name != '\\0')";
            }
            else if (*i == L"##other")
            {
              if (ns)
              {
                // Note that here I assume that ##other does not include
                // unqualified names in a schema with target namespace.
                // This is not what the spec says but that seems to be
                // the consensus.
                //
                if (stl)
                  os << "(!ns.empty () && ns != \"" << ns << "\")";
                else
                  os << "(ns != 0 && *ns != '\\0' && " <<
                    "strcmp (ns, \"" << ns << "\") != 0)";
              }
              else
              {
                if (stl)
                  os << "!ns.empty ()";
                else
                  os << "(ns != 0 && *ns != '\\0')";
              }
            }
            else if (*i == L"##local")
            {
              if (stl)
                os << "(ns.empty () && !name.empty ())";
              else
                os << "((ns == 0 || *ns == '\\0') && " <<
                  "name != 0 && *name != '\\0')";
            }
            else if (*i == L"##targetNamespace")
            {
              if (stl)
                os << "ns == \"" << ns << "\"";
              else
                os << "(ns != 0 && strcmp (ns, \"" << ns << "\") == 0)";
            }
            else
            {
              if (stl)
                os << "ns == \"" << *i << "\"";
              else
                os << "(ns != 0 && strcmp (ns, \"" << *i << "\") == 0)";
            }

            if (++i != e)
              os << " ||" << endl;
          }
        }
      };

      struct Compositor: Traversal::All,
                         Traversal::Choice,
                         Traversal::Sequence,
                         protected virtual Context
      {
        Compositor (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (SemanticGraph::All& a)
        {
          // For the all compositor, maxOccurs=1 and minOccurs={0,1}.
          //
          UnsignedLong min (a.contained_compositor ().min ());

          if (min == 0)
            os << "if (this->" << epresent (a) << " ())"
               << "{";

          Traversal::All::traverse (a);

          if (min == 0)
          {
            os << "}";

            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;
          }
        }

        virtual Void
        traverse (SemanticGraph::Choice& c)
        {
          if (c.contains_begin () != c.contains_end ())
          {
            UnsignedLong min;
            UnsignedLong max;

            if (c.contained_compositor_p ())
            {
              min = c.contained_compositor ().min ();
              max = c.contained_compositor ().max ();
            }
            else
            {
              min = c.contained_particle ().min ();
              max = c.contained_particle ().max ();
            }

            // Only sequence can have several choice compositors in a row.
            //
            Boolean need_scoping (
              c.contained_particle_p () &&
              c.contained_particle ().compositor ().
              is_a<SemanticGraph::Sequence> ());

            if (min == 0 && max == 1)
            {
              os << "if (this->" << epresent (c) << " ())"
                 << "{";
            }
            else if (max != 1)
            {
              // We only need to count if max != unbounded || min != 0.
              //
              if (max != 0 || min != 0)
              {
                if (need_scoping)
                  os << "{";

                os << "size_t i = 0;"
                   << "for (; ";

                if (max != 0)
                  os << "i < " << max << "UL && ";

                os << "this->" << enext (c) << " (); ++i)"
                   << "{";
              }
              else
                os << "while (this->" << enext (c) << " ())"
                   << "{";
            }
            else if (!exceptions && need_scoping)
            {
              // Only sequence can have several choice compositors in a row.
              //
              os << "{";
            }

            if (exceptions)
              os << "switch (this->" << earm (c) << " ())";
            else
              os << earm_tag (c) << " t = this->" << earm (c) << " ();"
                 << endl
                 << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl
                 << "switch (t)";


              os << "{";

            for (SemanticGraph::Choice::ContainsIterator
                   i (c.contains_begin ()); i != c.contains_end (); ++i)
            {
              os << "case " << etag (i->particle ()) << ":"
                 << "{";

              edge_traverser ().dispatch (*i);

              os << "break;"
                 << "}";
            }

            os << "default:"
               << "{"
               << "this->_schema_error (" <<
              "::xsde::cxx::schema_error::unexpected_element);"
               << "return;"
               << "}"
               << "}"; // switch

            if (min == 0 && max == 1)
            {
              os << "}";

              if (!exceptions)
                os << "if (ctx.error_type ())" << endl
                   << "return;"
                   << endl;
            }
            else if (max != 1)
            {
              os << "}";

              if (!exceptions)
                os << "if (ctx.error_type ())" << endl
                   << "return;"
                   << endl;

              if (max != 0 || min != 0)
              {
                if (min != 0)
                {
                  os << "if (i < " << min << "UL)"
                     << "{"
                     << "this->_schema_error (" <<
                    "::xsde::cxx::schema_error::expected_element);"
                     << "return;"
                     << "}";
                }

                if (need_scoping)
                  os << "}";
              }
            }
            else if (!exceptions && need_scoping)
            {
              os << "}";
            }
          }
        }

        virtual Void
        traverse (SemanticGraph::Sequence& s)
        {
          UnsignedLong min;
          UnsignedLong max;

          if (s.contained_compositor_p ())
          {
            min = s.contained_compositor ().min ();
            max = s.contained_compositor ().max ();
          }
          else
          {
            min = s.contained_particle ().min ();
            max = s.contained_particle ().max ();
          }

          // Only sequence can have several sequence compositors in a row.
          //
          Boolean need_scoping (
            s.contained_particle_p () &&
            s.contained_particle ().compositor ().
            is_a<SemanticGraph::Sequence> ());

          if (min == 0 && max == 1)
          {
            os << "if (this->" << epresent (s) << " ())"
               << "{";
          }
          else if (max != 1)
          {
            // We only need to count if max != unbounded || min != 0.
            //
            if (max != 0 || min != 0)
            {
              if (need_scoping)
                os << "{";

              os << "size_t i = 0;"
                 << "for (; ";

              if (max != 0)
                os << "i < " << max << "UL && ";

              os << "this->" << enext (s) << " (); ++i)"
                 << "{";
            }
            else
              os << "while (this->" << enext (s) << " ())"
                 << "{";
          }

          Traversal::Sequence::traverse (s);

          if (min == 0 && max == 1)
          {
            os << "}";

            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;
          }
          else if (max != 1)
          {
            os << "}";

            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;

            if (max != 0 || min != 0)
            {
              if (min != 0)
              {
                os << "if (i < " << min << "UL)"
                   << "{"
                   << "this->_schema_error (" <<
                  "::xsde::cxx::schema_error::expected_element);"
                   << "return;"
                   << "}";
              }

              if (need_scoping)
                os << "}";
            }
          }
        }
      };

      struct Particle: Traversal::Element,
                       Traversal::Any,
                       protected virtual Context
      {
        Particle (Context& c)
            : Context (c), any_test_ (c)
        {
        }

        virtual Void
        traverse (SemanticGraph::Element& e)
        {
          UnsignedLong min (e.contained_particle ().min ());
          UnsignedLong max (e.contained_particle ().max ());

          // Only sequence can have several particles in a row.
          //
          Boolean need_scoping (e.contained_particle ().compositor ().
                                is_a<SemanticGraph::Sequence> ());

          if (min == 0 && max == 1)
          {
            os << "if (this->" << epresent (e) << " ())"
               << "{";
          }
          else if (max != 1)
          {
            // We only need to count if max != unbounded || min != 0.
            //
            if (max != 0 || min != 0)
            {
              if (need_scoping)
                os << "{";

              os << "size_t i = 0;"
                 << "for (; ";

              if (max != 0)
                os << "i < " << max << "UL && ";

              os << "this->" << enext (e) << " (); ++i)"
                 << "{";
            }
            else
              os << "while (this->" << enext (e) << " ())"
                 << "{";
          }

          String const& name (ename (e));
          String const& inst (emember (e));
          String const& ret (ret_type (e.type ()));
          String const& arg (arg_type (e.type ()));

          os << "if (this->" << inst << ")"
             << "{";

          if (ret == L"void")
            os << "this->" << name << " ();";
          else
            os << arg << " r = this->" << name << " ();";

          if (!exceptions)
            os << endl
               << "if (ctx.error_type ())" << endl
               << "return;"
               << endl;

          if (ret == L"void")
            os << "this->" << inst << "->pre ();";
          else
            os << "this->" << inst << "->pre (r);";

          if (!exceptions)
            os << endl
               << "if (this->" << inst << "->_error_type ())" << endl
               << "this->" << inst << "->_copy_error (ctx);"
               << endl
               << "if (ctx.error_type ())" << endl
               << "return;"
               << endl;

          if (exceptions)
          {
            if (e.qualified ())
              os << "this->_start_element (\"" <<
                e.namespace_ ().name () << "\", \"" <<
                e.name () << "\");";
            else
              os << "this->_start_element (\"" << e.name () << "\");";
          }
          else
          {
            os << "if (!";

            if (e.qualified ())
              os << "this->_start_element (\"" <<
                e.namespace_ ().name () << "\", \"" <<
                e.name () << "\")";
            else
              os << "this->_start_element (\"" << e.name () << "\")";

            os << ")" << endl
               << "return;"
               << endl;
          }

          os << "this->" << inst << "->_pre_impl (ctx);";

          os << endl
             << "if (ctx.error_type ())" << endl
             << "return;"
             << endl;

          os << "this->" << inst << "->_serialize_attributes ();";

          os << endl
             << "if (ctx.error_type ())" << endl
             << "return;"
             << endl;

          os << "this->" << inst << "->_serialize_content ();";

          os << endl
             << "if (ctx.error_type ())" << endl
             << "return;"
             << endl;

          os << "this->" << inst << "->_post_impl ();";

          os << endl
             << "if (ctx.error_type ())" << endl
             << "return;"
             << endl;

          if (exceptions)
            os << "this->_end_element ();";
          else
            os << "if (!this->_end_element ())" << endl
               << "return;"
               << endl;

          os << "this->" << inst << "->post ();";

          if (!exceptions)
            os << endl
               << "if (this->" << inst << "->_error_type ())" << endl
               << "this->" << inst << "->_copy_error (ctx);"
               << endl
               << "if (ctx.error_type ())" << endl
               << "return;";

          os << "}" // if (inst)
             << "else"
             << "{"
             << "this->_schema_error (" <<
            "::xsde::cxx::schema_error::expected_element);"
             << "return;"
             << "}";

          if (min == 0 && max == 1)
          {
            os << "}";

            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;
          }
          else if (max != 1)
          {
            os << "}";

            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;

            if (max != 0 || min != 0)
            {
              if (min != 0)
              {
                os << "if (i < " << min << "UL)"
                   << "{"
                   << "this->_schema_error (" <<
                  "::xsde::cxx::schema_error::expected_element);"
                   << "return;"
                   << "}";
              }

              if (need_scoping)
                os << "}";
            }
          }
        }

        virtual Void
        traverse (SemanticGraph::Any& a)
        {
          UnsignedLong min (a.contained_particle ().min ());
          UnsignedLong max (a.contained_particle ().max ());

          // Only sequence can have several particles in a row.
          //
          Boolean need_scoping (a.contained_particle ().compositor ().
                                is_a<SemanticGraph::Sequence> ());

          if (min == 0 && max == 1)
          {
            os << "if (this->" << epresent (a) << " ())";

          }
          else if (max != 1)
          {
            // We only need to count if max != unbounded || min != 0.
            //
            if (max != 0 || min != 0)
            {
              if (need_scoping)
                os << "{";

              os << "size_t i = 0;"
                 << "for (; ";

              if (max != 0)
                os << "i < " << max << "UL && ";

              os << "this->" << enext (a) << " (); ++i)";
            }
            else
              os << "while (this->" << enext (a) << " ())";
          }

          os << "{";

          if (stl)
          {
            os << "::std::string ns, name;"
               << "this->" << ename (a) << " (ns, name);"
               << endl;

            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;

            os << "if (";

            any_test_.dispatch (a);

            os << ")"
               << "{";

            os << "if (ns.empty ())"
               << "{";

            if (exceptions)
              os << "this->_start_element (name.c_str ());";
            else
              os << "if (!this->_start_element (name.c_str ()))" << endl
                 << "return;";

            os << "}"
               << "else"
               << "{";

            if (exceptions)
              os << "this->_start_element (ns.c_str (), name.c_str ());";
            else
              os << "if (!this->_start_element (ns.c_str (), " <<
                "name.c_str ()))" << endl
                 << "return;";

            os << "}"
               << "this->" << eserialize (a) << " ();"
               << endl
               << "if (ctx.error_type ())" << endl
               << "return;"
               << endl;

            if (exceptions)
              os << "this->_end_element ();";
            else
              os << "if (!this->_end_element ())" << endl
                 << "return;";

            os << "}" // test
               << "else"
               << "{"
               << "this->_schema_error (" <<
              "::xsde::cxx::schema_error::unexpected_element);"
               << "return;"
               << "}";
          }
          else
          {
            os << "const char* ns = 0;"
               << "const char* name;"
               << "bool free;"
               << "this->" << ename (a) << " (ns, name, free);"
               << endl;

            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;
            else
              os << "::xsde::cxx::string auto_ns, auto_name;"
                 << "if (free)"
                 << "{"
                 << "auto_ns.attach (const_cast< char* > (ns));"
                 << "auto_name.attach (const_cast< char* > (name));"
                 << "}";

            os << "if (";

            any_test_.dispatch (a);

            os << ")"
               << "{";

            if (exceptions)
              os << "if (ns == 0 || *ns == '\\0')" << endl
                 << "this->_start_element (name);"
                 << "else" << endl
                 << "this->_start_element (ns, name);"
                 << endl;
            else
              os << "bool r;"
                 << "if (ns == 0 || *ns == '\\0')" << endl
                 << "r = this->_start_element (name);"
                 << "else" << endl
                 << "r = this->_start_element (ns, name);"
                 << endl
                 << "if (free)"
                 << "{"
                 << "delete[] ns;"
                 << "delete[] name;"
                 << "}"
                 << "if (!r)" << endl
                 << "return;"
                 << endl;

            os << "this->" << eserialize (a) << " ();"
               << endl
               << "if (ctx.error_type ())" << endl
               << "return;"
               << endl;

            if (exceptions)
              os << "this->_end_element ();";
            else
              os << "if (!this->_end_element ())" << endl
                 << "return;";

            os << "}" // test
               << "else"
               << "{"
               << "this->_schema_error (" <<
              "::xsde::cxx::schema_error::unexpected_element);"
               << "return;"
               << "}";
          }

          os << "}";

          if (min == 0 && max == 1)
          {
            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;
          }
          else if (max != 1)
          {
            if (!exceptions)
              os << "if (ctx.error_type ())" << endl
                 << "return;"
                 << endl;

            if (max != 0 || min != 0)
            {
              if (min != 0)
              {
                os << "if (i < " << min << "UL)"
                   << "{"
                   << "this->_schema_error (" <<
                  "::xsde::cxx::schema_error::expected_element);"
                   << "return;"
                   << "}";
              }

              if (need_scoping)
                os << "}";
            }
          }
        }

      private:
        AnyTest any_test_;
      };

      //
      //
      struct Complex : Traversal::Complex,
                       protected virtual Context
      {
        Complex (Context& c)
            : Context (c),
              compositor_ (c),
              particle_ (c)
        {
          contains_compositor_ >> compositor_;
          compositor_ >> contains_particle_;
          contains_particle_ >> compositor_;
          contains_particle_ >> particle_;
        }

        virtual Void
        traverse (Type& c)
        {
          if (!has<Traversal::Element> (c) &&
              !has_particle<Traversal::Any> (c))
            return;

          // Don't use restriction_p here since we don't want special
          // treatment of anyType.
          //
          Boolean restriction (
            c.inherits_p () &&
            c.inherits ().is_a<SemanticGraph::Restricts> ());

          String const& name (ename (c));

          os <<"// Element validation and serialization for " <<
            name << "." << endl
             <<"//" << endl;

          os << "void " << name << "::" << endl
             << "_serialize_content ()"
             << "{"
             << "::xsde::cxx::serializer::context& ctx = this->_context ();"
             << endl;

          // Use unqualified name of our base.
          //
          if (c.inherits_p () && !restriction)
          {
            os << ename (c.inherits ().base ()) <<
              "::_serialize_content ();"
               << endl
               << "if (ctx.error_type ())" << endl
               << "return;"
               << endl;
          }

          contains_compositor (c, contains_compositor_);

          os << "}";
        }

      private:
        Compositor compositor_;
        Particle particle_;
        Traversal::ContainsCompositor contains_compositor_;
        Traversal::ContainsParticle contains_particle_;
      };
    }

    Void
    generate_element_validation_source (Context& ctx)
    {
      Traversal::Schema schema;

      Traversal::Sources sources;
      Traversal::Names schema_names;

      Namespace ns (ctx);
      Traversal::Names names;

      schema >> sources >> schema;
      schema >> schema_names >> ns >> names;

      Complex complex (ctx);

      names >> complex;

      schema.dispatch (ctx.schema_root);
    }
  }
}

