.\" X-BASED MISSING LINK(tm)
.\"
.\" xmlink.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2001	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH MISSING LINK 6 "01 Sep 2001" "V5.5.4"
.SH NAME
xmlink \- Missing Link X widget
.SH SYNOPSIS
.B /usr/games/xmlink
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-tile {color}]
[-face{0|1|2|3|4|5|6|7} {color}]
[-tiles {int}] [-faces {int}] [-[no]orient] [-[no]middle]
[-base {int}] [-username {string}]
.SH DESCRIPTION
.LP
Ideal's The Missing Link, a 4x4 puzzle, riding on the wave of Rubik's
Cube craze.  There are many variations on this theme, including the "6x6"
puzzle and Babylon Tower.  What makes the Missing Link a harder puzzle to
solve is that the 2 center positions rotate together.
.SH FEATURES
Press "\fBmouse-left\fP" button to move a tiles.  Release
"\fBmouse-left\fP" button in the same row would move the tile towards the
space (unless there is no space in that row).  Release on a different row
will move the tiles up or down.
.LP
Click "\fBmouse-right\fP", or press "\fBR\fP" or "\fBr\fP" keys to randomize
(this must be done first to set a new record).  One must double click on
"\fBmouse-right\fP" if the puzzle is being worked on.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  Slightly
more challenging on (default is off).
.LP
Press "\fBM\fP" or "\fBm\fP" keys to toggle the middle mode.  All the
middle tiles rotate together.  This is considerably more challenging on
(default is on).
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (not implemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without mouse clicks.
.br
Key pad is defined for Missing Link as:
.br
  8     Up
.br
  ^
.br
4< >6   Left, Right
.br
  v
.br
  2     Down
.LP
Use the shift key and the up or down arrow keys to rotate all the tiles.
.LP
Use the control key and the keypad or arrow keys to enlarge or reduce the
complexity of the puzzle.
.LP
The title is in the following format (non-motif version):
.RS
xmlink: <row>x<column> {norm|ind<control of movement of middle tiles>} @
(<Number of moves>/{<Record number of moves>|"NEVER noaccess"|"practice"}) -
<Comment>
.RE
Movement of middle tiles are either move together or independent.
.br
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the missing link window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to  display on a color screen as if monochrome
(resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the missing link window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the missing link window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the missing link window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the tiles in the missing link window
(resource name "\fborderColor\fP").
.TP 8
.B \-tile \fIcolor\fP
This option specifies the tile color of the tiles in the missing link window
(resource name "\fItileColor\fP").
.TP 8
.B \-face{0|1|2|3|4|5|6|7} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono-mode, color is represented as the first letter
of the color name.  The 0th face is the last face face on missing link
because I wanted that one to remain white by default when there are more or
less faces.
.TP 8
.B \-tiles <\fIint\fP>
This option allows you to change the number of links in a row
(resource name "\fItiles\fP").
.TP 8
.B \-faces <\fIint\fP>
This option allows you to change the number of faces in column
(resource name "\fIfaces\fP").
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]middle
This option allows you to access the middle mode (resource name
"\fIorient\fP").
.TP 8
.B \-base \fIint\fP
This option specifies the base used (default is base 10) (resource name
"\fIbase\fP").
.TP 8
.B \-username \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
tiles: 1-8 <number of tiles in a row>
.br
faces: 1-8 <number of tiles in a column>
.br
middle: 0-1 <0 false, 1 true; if 1 then middle moves as one unit>
.br
orient: 0-1 <0 false, 1 true; if 1 then chain linked in order>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <array of tile positions where 0 is the empty space>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <direction> <tile> <shift>
.RE
Direction is represented as 0 up, 1 right, 2 down, and 3 left.
.br
Tile is the column of tile.
.br
Shift is represented as 0 or 1, 1 if the whole puzzle is moved at
once (here Tile does not matter), 0 if not.  The xmlink record keeper
does not count a control move as a move, but here we do.
.sp
Caution: the program may crash on corrupted input.
.SH REFERENCES
Sliding Piece Puzzles (Recreations in Mathematics Series) by L. E. Horden,
Oxford University Press 1986, Plate X.
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xoct(6), xmball(6),
xpanex(6), xcubes(6), xtriangles(6), xhexagons(6), abacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2001, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ftp.x.org/contrib/games\fP

