dnl -*- shell-script -*-

# Copyright 1998-1999, University of Notre Dame.
# Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
# 	 and Andrew Lumsdaine
#
# This file is part of XMPI
#
# You should have received a copy of the License Agreement for XMPI 
# along with the software; see the file LICENSE.  If not, contact 
# Office of Research, University of Notre Dame, Notre Dame, IN 46556.
# 
# Permission to modify the code and to distribute modified code is
# granted, provided the text of this NOTICE is retained, a notice that
# the code was modified is included with the above COPYRIGHT NOTICE and
# with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
# file is distributed with the modified code.
#
# LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
# By way of example, but not limitation, Licensor MAKES NO
# REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
# PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
# OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
# OR OTHER RIGHTS.
#
# Additional copyrights may follow.



AC_DEFUN(LAM_TEST_COMPILE,[
AC_MSG_CHECKING(whether default compiler flags ($CFLAGS) are valid)
AC_TRY_COMPILE([#include <stdio.h>], [printf("hello world");],
lam_test_compile_ok=yes, lam_test_compile_ok=no)
if test "$lam_test_compile_ok" = yes; then
    AC_MSG_RESULT([yes])
else
    AC_MSG_RESULT([no])
fi
])dnl

AC_MSG_ERROR(please set the C compiler flags explicitly
with the option --with-cflags), AC_MSG_RESULT(ok))])dnl

AC_DEFUN(LAM_ANSI_PROTOS,[
# Determine if compiler and options accepts ANSI prototypes.
AC_MSG_CHECKING([whether the C compiler ($CC $CFLAGS) accepts ANSI prototypes])
cat > conftest.c <<EOF
static double foo(double bar) { return(2.0*bar); }
int main(int argc, char **argv)
{ double x; x = foo(2.0); return(0); }
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_ansi_protos=yes
else
    lam_ac_ansi_protos=no
fi
AC_MSG_RESULT($lam_ac_ansi_protos)
/bin/rm -f conftest*])dnl

AC_DEFUN(LAM_CHECK_STDC,[
# Check to see if compiler sets __STDC__ to 1 or not
AC_MSG_CHECKING(for __STDC__)
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
#ifndef __STDC__
#define __STDC__ -1
#endif
int main(int argc, char* argv[])
{
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    fprintf(f, "%d\n", __STDC__);
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_stdc=`cat conftestval`
    AC_MSG_RESULT([$lam_ac_stdc])
    if test "$lam_ac_stdc" = "0"; then
	AC_MSG_WARN([*** Compiler did not set __STDC__ to 1!])
	AC_MSG_WARN([*** Be warned -- this will cause user MPI programs to])
	AC_MSG_WARN([*** not get proper prototypes of MPI functions!])
    elif test "$lam_ac_stdc" = "-1"; then
	AC_MSG_WARN([*** Compiler did not set __STDC__!])
	AC_MSG_WARN([*** Be warned -- this will cause user MPI programs to])
	AC_MSG_WARN([*** not get proper prototypes of MPI functions!])
    fi
else
    AC_MSG_WARN(error compiling/running conftest)
fi
/bin/rm -f conftest*])dnl

AC_DEFUN(LAM_GET_SIZEOF,[
# Determine datatype size. 
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(size of of $1)
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
int main(int argc, char* argv[])
{
    FILE *f=fopen("conftestval", "w");
    if (!f) return 1;
    fprintf(f, "%d\n", sizeof($1));
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_size=`cat conftestval`
else
    lam_ac_size=0
fi
AC_MSG_RESULT($lam_ac_size)
if test -n "$2"; then
    AC_DEFINE_UNQUOTED($2,$lam_ac_size)
fi
/bin/rm -f conftest*])dnl

AC_DEFUN(LAM_CHECK_TYPE,[
# Autoconfs AC_CHECK_TYPE is not sufficient
# This, too, is not foolproof, but will have to do...
AC_MSG_CHECKING(for type $1)
cat > conftest.$ac_ext <<EOF
#line 3411 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
EOF
touch conftest.out >&5 2>&5
rm -f conftest.out >&5 2>&5
eval "$ac_cpp conftest.$ac_ext" 2>&5 > conftest.out
egrep "$1[[^a-zA-Z_0-9]]" conftest.out > conftest.out2 2>&5
cat conftest.out2 >&5
out="`cat conftest.out2`"
if test "$out" != ""; then
  AC_DEFINE(HAVE_$1, 1)
  AC_MSG_RESULT([yes])
else
  AC_DEFINE(HAVE_$1, 0)
  AC_MSG_RESULT([no])
fi
rm -rf conftest*
])dnl

AC_DEFUN(LAM_GET_FORTRAN_EXT_NAME_CONVENTION,[
# Determine underscore generation for external names.
# arg is FORTRAN compiler name
AC_MSG_CHECKING($1 external naming convention)
cat > conftestf.f <<EOF
       subroutine foo_bar(a)
       integer a
       a = 1
       return
       end
EOF
$1 $FFLAGS -c conftestf.f 1>&5 2>&1
if test ! -s conftestf.o; then
    AC_MSG_WARN(unable to produce an object file testing FORTRAN compiler)
else
    nm conftestf.o | grep foo_bar__ > /dev/null 2>&1
    if test $? = "0"; then 
	AC_MSG_RESULT(FORTRANDOUBLEUNDERSCORE)
	AC_DEFINE(LAM_FORTRANDOUBLEUNDERSCORE)
	lam_ac_doubleunder=y
    else
	nm conftestf.o | grep foo_bar_ > /dev/null 2>&1
	if test $? = "0"; then 
	    AC_MSG_RESULT(FORTRANUNDERSCORE)
	    AC_DEFINE(LAM_FORTRANUNDERSCORE)
	    lam_ac_singleunder=y
	else
	    nm conftestf.o | grep foo_bar > /dev/null 2>&1
	    if test $? = "0"; then 
		AC_MSG_RESULT(FORTRANNOUNDERSCORE)
		AC_DEFINE(LAM_FORTRANNOUNDERSCORE)
		lam_ac_nounder=y
	    else
		nm conftestf.o | grep FOO_BAR > /dev/null 2>&1
		if test $? = "0"; then 
		    AC_MSG_RESULT(FORTRANCAPS)
		    AC_DEFINE(LAM_FORTRANCAPS)
		    lam_ac_caps=y
		else
		    AC_MSG_WARN(couldn't find name of subroutine foo_bar)
		fi
	    fi
	fi
    fi
fi
/bin/rm -f conftestf.f conftestf.o])dnl
dnl #$%#% emacs shell-script mode: '

AC_DEFUN(LAM_GET_SIZEOF_FORTRAN_TYPE,[
# Determine FORTRAN datatype size.
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(size of FORTRAN $1)
lam_ac_size_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_size_fn=size_
else
    if test "x$lam_ac_nounder" = xy; then
	    lam_ac_size_fn=size
    else 
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_size_fn=SIZE
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_size_fn"; then
cat > conftestf.f <<EOF
       program fsize
       external size
       $1 x(2)
       call size(x(1),x(2))
       end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_size_fn(char *a, char *b)
{
    int diff = (int) (b - a);
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    fprintf(f, "%d\n", diff);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $FCOMPILER $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	lam_ac_fortsize=`cat conftestval`
	AC_MSG_RESULT($lam_ac_fortsize)
	if test -n "$2"; then
	    AC_DEFINE_UNQUOTED($2,$lam_ac_fortsize)
	fi
    else
	AC_MSG_WARN(Error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])dnl

AC_DEFUN(LAM_GET_FORTRAN_ALIGNMENT,[
# Determine FORTRAN datatype size.
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(alignment of FORTRAN $1)
lam_ac_align_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_align_fn=align_
else
    if test "x$lam_ac_nounder" = xy; then
	lam_ac_align_fn=align
    else
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_align_fn=ALIGN
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_align_fn"; then
cat > conftestf.f <<EOF
      program falign
      external align
      $1  w,x,y,z
      CHARACTER a,b,c
      common /foo/a,w,b,x,y,c,z
      call align(w,x,y,z)
      end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_align_fn(char *w, char *x, char *y, char *z)
{   unsigned long aw, ax, ay, az;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    aw = (unsigned long) w;
    ax = (unsigned long) x;
    ay = (unsigned long) y;
    az = (unsigned long) z;
    if (! ((aw%16)||(ax%16)||(ay%16)||(az%16))) fprintf(f, "%d\n", 16);
    else if (! ((aw%12)||(ax%12)||(ay%12)||(az%12))) fprintf(f, "%d\n", 12);
    else if (! ((aw%8)||(ax%8)||(ay%8)||(az%8))) fprintf(f, "%d\n", 8);
    else if (! ((aw%4)||(ax%4)||(ay%4)||(az%4))) fprintf(f, "%d\n", 4);
    else if (! ((aw%2)||(ax%2)||(ay%2)||(az%2))) fprintf(f, "%d\n", 2);
    else fprintf(f, "%d\n", 1); 
    fclose(f);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $FCOMPILER $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	lam_ac_alignment=`cat conftestval`
	AC_MSG_RESULT $lam_ac_alignment
	if test -n "$2"; then
	    AC_DEFINE_UNQUOTED($2,$lam_ac_alignment)
	fi
    else
	AC_MSG_WARN(error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])dnl

AC_DEFUN(LAM_GET_ALIGNMENT_CACHE,[
# Determine datatype alignment. 
# First arg is type, 2nd arg is cache var, 3rd arg is config var to define.
AC_CACHE_CHECK(alignment of $1,$2,[
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
struct foo { char c; $1 x; };
int main(int argc, char* argv[])
{
    struct foo *p = (struct foo *) malloc(sizeof(struct foo));
    int diff;
    FILE *f=fopen("conftestval", "w");
    if (!f) return 1;
    diff = ((char *)&p->x) - ((char *)&p->c);
    fprintf(f, "%d\n", (diff >= 0) ? diff : -diff);
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    $2=`cat conftestval`
else
    AC_MSG_WARN(error compiling/running conftest)
fi
/bin/rm -f conftest*])
AC_DEFINE_UNQUOTED($3,[$]$2)])dnl

AC_DEFUN(LAM_GET_SIZEOF_FORTRAN_TYPE_CACHE,[
# Determine FORTRAN datatype size.
# First arg is type, 2nd arg is cache var, 3rd arg is config var to define.
AC_CACHE_CHECK(size of FORTRAN $1,$2,[
lam_ac_size_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_size_fn=size_
else
    if test "x$lam_ac_nounder" = xy; then
	lam_ac_size_fn=size
    else
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_size_fn=SIZE
	else 
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_size_fn"; then
cat > conftestf.f <<EOF
       program fsize
       external size
       $1 x(2)
       call size(x(1),x(2))
       end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
#endif
void $lam_ac_size_fn(char *a, char *b)
{
    int diff = (int) (b - a);
    FILE *f=fopen("conftestval", "w");
    if (!f) return;
    fprintf(f, "%d\n", diff);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $FCOMPILER $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	$2=`cat conftestval`
    else
	AC_MSG_WARN(Error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])
AC_DEFINE_UNQUOTED($3,[$]$2)])dnl

AC_DEFUN(LAM_GET_FORTRAN_ALIGNMENT_CACHE,[
# Determine FORTRAN datatype alignment. 
# First arg is type, 2nd arg is cache var, 3rd arg is config var to define.
AC_CACHE_CHECK(alignment of FORTRAN $1,$2,[
lam_ac_align_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_align_fn=align_
else
    if test "x$lam_ac_nounder" = xy; then
	    lam_ac_align_fn=align
    else
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_align_fn=ALIGN
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_align_fn"; then
cat > conftestf.f <<EOF
      program falign
      external align
      $1  w,x,y,z
      CHARACTER a,b,c
      common /foo/a,w,b,x,y,c,z
      call align(w,x,y,z)
      end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_align_fn(char *w, char *x, char *y, char *z)
{   unsigned long aw, ax, ay, az;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    aw = (unsigned long) w;
    ax = (unsigned long) x;
    ay = (unsigned long) y;
    az = (unsigned long) z;
    if (! ((aw%16)||(ax%16)||(ay%16)||(az%16))) fprintf(f, "%d\n", 16);
    else if (! ((aw%12)||(ax%12)||(ay%12)||(az%12))) fprintf(f, "%d\n", 12);
    else if (! ((aw%8)||(ax%8)||(ay%8)||(az%8))) fprintf(f, "%d\n", 8);
    else if (! ((aw%4)||(ax%4)||(ay%4)||(az%4))) fprintf(f, "%d\n", 4);
    else if (! ((aw%2)||(ax%2)||(ay%2)||(az%2))) fprintf(f, "%d\n", 2);
    else fprintf(f, "%d\n", 1); 
    fclose(f);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $FCOMPILER $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	$2=`cat conftestval`
    else
	AC_MSG_WARN(error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])
AC_DEFINE_UNQUOTED($3,[$]$2)])dnl

AC_DEFUN(LAM_CHECK_FUNC,[
# Determine if function taking void args is available. 
# First arg is function, 2nd arg is config var to define, 3rd arg is options
# to add to link line.
AC_MSG_CHECKING(for $1)
/bin/rm -f conftest*
cat > conftest.c <<EOF
int main(int argc, char* argv[]) { $1(); return(0); }
EOF
$CC $CFLAGS -o conftest conftest.c $3 1>&5 2>&1
if test -s conftest && ./conftest 2>/dev/null; then
    AC_DEFINE($2)
    AC_MSG_RESULT(yes)
else
    AC_MSG_RESULT(no)
fi
/bin/rm -f conftest*])dnl

AC_DEFUN(LAM_MOTIF_INCLUDES,[
AC_MSG_CHECKING(for Motif includes directory)
lam_ac_motif_includes=no
for d in $x_includes /usr/include /usr/local/include /usr/dt/include \
	/usr/local/lesstif/include; do
    if test -r $d/Xm/Form.h; then
	lam_ac_motif_includes=$d
	break
    fi
done
AC_MSG_RESULT($lam_ac_motif_includes)
])

AC_DEFUN(LAM_MOTIF_LIBRARIES,[
AC_MSG_CHECKING(for Motif libraries)
lam_ac_motif_libraries=no
for d in $x_libraries /usr/lib /usr/local/lib /usr/dt/lib \
	/usr/local/lesstif/lib; do
    for f in $d/libXm.*; do
	if test -r $f ; then
	    lam_ac_motif_libraries=$d
	    break
	fi
    done
    if test $lam_ac_motif_libraries != no; then 
	break
    fi
done
AC_MSG_RESULT($lam_ac_motif_libraries)
])

AC_DEFUN(LAM_SHARED_OBJ_FLAGS,[
AC_MSG_CHECKING([for compiler flags to generate position independent code])
AC_REQUIRE([AC_PROG_CC])
if test "$GCC" = yes; then
    SOFLAGS=-fPIC
else
    case "$host_os" in
	*solaris*) SOFLAGS=-Kpic;;
	*hpux*) SOFLAGS=+z;;
    esac
fi
AC_MSG_RESULT($SOFLAGS)
AC_SUBST(SOFLAGS)])

AC_DEFUN(LAM_SHARED_LIBS_UNSUPPORTED,[
echo
echo Building a shared libxmpi is currently unsupported on this platform.
echo If you would like to see support added please mail lam@mpi.nd.edu 
echo with details on your platform and information on how to build shared 
echo libraries on it and we will try to add it.
AC_MSG_ERROR(shared library support)
])

#
#cheks for MPI headers
#

define([LSC_CHECK_MPI_H],[
AC_MSG_CHECKING([for app_mgmt.h])
touch conftest.o
rm -f conftest.o
cat > conftest.c <<EOF
#include <app_mgmt.h>
int
main(int argc, char* argv[])
{ return 0; }
EOF
echo configure:__oline__: $CC $CFLAGS -c conftest.c >&5
$CC $CFLAGS -c conftest.c >&2 2>&5
if test -f conftest.o ; then
    HAVE_MPI_H=yes
    AC_MSG_RESULT([yes])
else
    HAVE_MPI_H=no
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest.C >&5
    AC_MSG_RESULT([no])
fi
rm -f conftest*
if test "$HAVE_MPI_H" = "no"; then
    AC_MSG_ERROR([cannot continue -- cannot find <app_mgmt.h>])
fi])dnl
