/*
 *	$COPYRIGHT$
 *
 *	$Id: xmpi_nodes.cc,v 1.4 2001/07/11 15:43:54 bbarrett Exp $
 *
 *	Function:	- node list panel in builder dialog
 *			- only understands host file syntax
 */

#include <stdlib.h>
#include <string.h>

#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/PanedW.h>
#include <Xm/TextF.h>
#include <Xm/Xm.h>

#include "xmpi_nodes.h"
#include "args.h"
#include "xmpi.h"
#include "itoa.h"
#include "xmpi_misc.h"
#include "xmpi_run.h"

// Extern variables
extern struct xmpi_node *nodes;
extern int nodes_length;

/*
 * local functions
 */
static void nodes_fill();

static void nodes_select_cb(Widget, XtPointer, 
			    XmListCallbackStruct*);

/*
 * local variables
 */
#define MAXLINE		80

static Widget list_w;

/*
 *	xmpi_nodes_build
 *
 *	Function:	- builds node panel
 *	Accepts:	- parent widget
 */
void
xmpi_nodes_build(Widget parent_w)
{
  Widget mgr_w;

  XmString xstr;

  mgr_w = XtVaCreateWidget("nodes_mgr",
			   xmPanedWindowWidgetClass, parent_w,
			   XmNsashWidth, 1,
			   XmNsashHeight, 1,
			   XmNseparatorOn, False,
			   XmNleftAttachment, XmATTACH_POSITION,
			   XmNleftPosition, 1,
			   XmNleftOffset, 5,
			   XmNrightAttachment, XmATTACH_POSITION,
			   XmNrightPosition, 2,
			   XmNtopAttachment, XmATTACH_FORM,
			   XmNbottomAttachment, XmATTACH_FORM,
			   NULL);

  xstr = XmStringCreateSimple((char*) "Select Nodes");
  XtVaCreateManagedWidget("banner",
			  xmLabelWidgetClass, mgr_w,
			  XmNlabelString, xstr,
			  NULL);
  XmStringFree(xstr);

  list_w = XmCreateScrolledList(mgr_w, (char*) "nodes_list", NULL, 0);
  XtVaSetValues(list_w,
		XmNscrollBarDisplayPolicy, XmSTATIC,
		XmNscrollHorizontal, False,
		XmNselectionPolicy, XmEXTENDED_SELECT,
		NULL);
  XtAddCallback(list_w, XmNdefaultActionCallback, 
		(XtCallbackProc) nodes_select_cb, NULL);
  XtAddCallback(list_w, XmNextendedSelectionCallback,
		(XtCallbackProc) nodes_select_cb, NULL);
  XtManageChild(list_w);
/*
 * Fill the list.
 */
  nodes_fill();

  xmpi_nosash(mgr_w);
  XtManageChild(mgr_w);
}


void
xmpi_nodes_update()
{
  XtVaSetValues(list_w,
		XmNselectionPolicy, XmMULTIPLE_SELECT,
		NULL);
  for (int i = 0 ; i < nodes_length ; ++i)
    if (nodes[i].selected != 0) {
      XmListDeselectPos(list_w, i + 1);
      XmListSelectPos(list_w, i + 1, False);
    } else 
      XmListDeselectPos(list_w, i + 1);
  
  // switch back into the EXTENDED mode
  XtVaSetValues(list_w,
		XmNselectionPolicy, XmEXTENDED_SELECT,
		NULL);
}


void
xmpi_nodes_update_default()
{
  XtVaSetValues(list_w,
		XmNselectionPolicy, XmMULTIPLE_SELECT,
		NULL);
  for (int i = 0 ; i < nodes_length ; ++i)
    if (nodes[i].default_sel != 0) {
      XmListDeselectPos(list_w, i + 1);
      XmListSelectPos(list_w, i + 1, False);
    } else 
      XmListDeselectPos(list_w, i + 1);
  
  // switch back into the EXTENDED mode
  XtVaSetValues(list_w,
		XmNselectionPolicy, XmEXTENDED_SELECT,
		NULL);
}


/*
 *	nodes_select_cb
 *
 *	Function:	- update the nodes structure with the current state.
 *                        if a exclusive is just selected, unselect everything
 *                        else.  If an exclusive is selected, and something 
 *                        else is just clicked, unselect the exlusive.
 *	Accepts:	- widget
 *			- client data
 *			- ptr callback struct
 */
static void
nodes_select_cb(Widget w, XtPointer, XmListCallbackStruct*)
{
  int pos;
  int *sel_pos;
  int num_sel_pos;

  // *&#%@*&$# Lesstif.  After a while, the callback struct seems to
  // hose itself.  Let's try this to fix.  
  // First, deal with the exclusives
  if (XmListGetSelectedPos(list_w, &sel_pos, &num_sel_pos)) {
    for (int i = 0 ; i < num_sel_pos ; ++i) {
      pos =  sel_pos[i];
      if ((nodes[pos - 1].exclusive != 0) && (nodes[pos - 1].selected == 0)) {
	// an exclusive was just selected.  Even if something else was
	// selected, we are going to take this as what the user wanted
	// to do.
	XmListDeselectAllItems(w);
	XmListSelectPos(w, pos, False);
	// we don't really want to go throught the rest of the nodes.
	break;
      } else if (nodes[pos - 1].exclusive != 0) {
	// an exclusive is selected, but was before.  Something else was
	// selected, so we should remove this exclusive.
	XmListDeselectPos(w, pos);
      }
    }
  }    

  for (int i = 0 ; i < nodes_length ; ++i)
    nodes[i].selected = 0;
  
  // we changed a boatload above.  Get the new values.
  if (XmListGetSelectedPos(list_w, &sel_pos, &num_sel_pos))
    for (int i = 0 ; i < num_sel_pos ; ++i) {
      // positions are indexed from 1.  C++ arrays from 0.  Deal.
      pos = sel_pos[i];
      nodes[pos - 1].selected = 1;
    } 

  // update the schema line
  xmpi_run_update();
}


/*
 *	nodes_fill
 *
 *	Function:	- fills list with node names and numbers
 */
static void
nodes_fill()
{
  XmString xstr;

/*
 * Delete all current list entries.
 */
  XmListDeselectAllItems(list_w);
  XmListDeleteAllItems(list_w);

  for (int i = 0; i < nodes_length ; ++i) {
    xstr = XmStringCreateSimple(nodes[i].name);
    XmListAddItem(list_w, xstr, 0);
    XmStringFree(xstr);
    // now figure out which should be selected.  We do not yet
    // care about the exclusive.  If it says default, we
    // go with it.  Set selected to match what is actually there.
    
    if (nodes[i].default_sel == 1) {
      // set the current to on...
      nodes[i].selected = 1;
      // switch into MUTLIPLE mode on the listbox
      XtVaSetValues(list_w,
		    XmNselectionPolicy, XmMULTIPLE_SELECT,
		    NULL);
      // select this item
      XmListSelectPos(list_w, i, False);
      // switch back into the EXTENDED mode
      XtVaSetValues(list_w,
		    XmNselectionPolicy, XmEXTENDED_SELECT,
		    NULL);
    } else {
      // not selected.  Set selected.
      nodes[i].selected = 0;
    }
  }
}

