# fallback menu config file for XMMS2tray
#
# a normal menu item is a dictionary. known keys:
#   title       The item's text (required!)
#  max one of:
#   check       When set to a true value, the menu item contains a check box
#   stockicon   GTK+ stock icon to use, e.g. 'media_pause'
#   iconfile    filename of an icon to use
#  max one of:
#   command     command to run when activated
#   action      one of:
#      playpause     Start or (when running) Pause playback. supports check
#      play          Start playback
#      pause         pause playback
#      stop          stop playback
#      next          jump to next track
#      prev          jump to previous track
#      kill          stop the xmms2 daemon
#      quit          quit the tray icon
#
# a seperator is one of None, "sep", "separator"

TOP = [
    { 'title': 'Play',
      'check': True, 
      'action': 'playpause' },
    { 'title': 'Stop',
      'action': 'stop',
      'stockicon': 'media_stop'},
    { 'title': 'Next',
      'action': 'next',
      'stockicon': 'media_next'},
    { 'title': 'Previous',
      'action': 'prev',
      'stockicon': 'media_previous'}
]

BOTTOM = [
    { 'title': 'Stop Daemon',
      'stockicon': 'stop',
      'action': 'kill'},
    { 'title': 'Quit', 
      'stockicon': 'quit', 
      'action': 'quit' }
]

# 'command' must be a full path; item is only shown if exists.
# use $ as first char for 'either /usr or /use/local'
CLIENTS = [
    { 'title': 'Launch Insanity',
      'iconfile': '$/share/insanity/pixmaps/blue_ghost_128.xpm',
      'command': '$/bin/insanity'},

    { 'title': 'Launch gxmms2',
      'iconfile': '$/share/gxmms2/gxmms2_mini.xpm',
      'command': '$/bin/gxmms2'},

    { 'title': 'Launch Abraca',
      'iconfile': 'data/xmms2_24.png',
      'command': '$/bin/abraca' },

    { 'title': 'Launch X4X',
      'iconfile': '$/share/pixmaps/x4x.png',
      'command': '$/bin/x4x'},

    { 'title': 'Launch Esperanza',
      'iconfile': 'data/xmms2_24.png',
      'command': '$/bin/esperanza' }
]

