/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  Wrapper for various id3lib interfaces
 *
 *  Based on id3tag.c from EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2001  Jerome Couderc <j.couderc@ifrance.com>
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "singit_id3lib_wrapper.h"

#define ID3V2_MAX_STRING_LEN 4096

/*
 *  As the ID3Tag_Link function of id3lib-3.8.0pre2 returns the ID3v1 tags
 *  when a file has both ID3v1 and ID3v2 tags, we first try to explicitely
 *  get the ID3v2 tags with ID3Tag_LinkWithFlags and, if we cannot get them,
 *  fall back to the ID3v1 tags.
 *  (Written by Holger Schemel).
 */
size_t ID3Tag_Link_WRP(ID3Tag *id3tag, const gchar *filename)
{
    size_t offset;

#   if ( (ID3LIB_MAJOR >= 3) && (ID3LIB_MINOR >= 8)  )
        offset = ID3Tag_LinkWithFlags(id3tag, filename, ID3TT_ALL);
#   else
        /* Function 'ID3Tag_LinkWithFlags' is not defined up to id3lib-.3.7.13 */
        offset = ID3Tag_Link(id3tag, filename);
#   endif
    //g_print("ID3 TAG SIZE: %d\t%s\n",offset,g_basename(filename));
    return offset;
}


/*
 *  As the ID3Field_GetASCII function differs with the version of id3lib, we must redefine it.
 */
size_t ID3Field_GetASCII_WRP(const ID3Field *field, gchar *buffer, size_t maxChars)
{

/*  Defined by id3lib:
 * 	ID3LIB_MAJOR_VERSION, ID3LIB_MINOR_VERSION, ID3LIB_PATCH_VERSION
 *  Defined by autoconf:
 *	ID3LIB_MAJOR, ID3LIB_MINOR, ID3LIB_PATCH
 *
 *  <= 3.7.12 : first item num is 1 for ID3Field_GetASCII
 *   = 3.7.13 : first item num is 0 for ID3Field_GetASCII
 *  >= 3.8.0  : doesn't need item num for ID3Field_GetASCII
 */

#    if (ID3LIB_MAJOR >= 3)
         // (>= 3.x.x)
#        if (ID3LIB_MINOR <= 7)
             // (3.0.0 to 3.7.x)
#            if (ID3LIB_PATCH >= 13)
                 // (>= 3.7.13)
                 return ID3Field_GetASCII(field, buffer, maxChars, 0);
#            else
                 return ID3Field_GetASCII(field, buffer, maxChars, 1);
#            endif
#        else
             // (>= to 3.8.0)
             return ID3Field_GetASCII(field, buffer, maxChars);
#        endif
#    else
         // Not tested (< 3.x.x)
         return ID3Field_GetASCII(field, buffer, maxChars, 1);
#    endif
}
