/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __EDITOR_SYNCED_LYRICS_H__
#define __EDITOR_SYNCED_LYRICS_H__

#include "editor_view.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_EDITOR_SYNCED_LYRICS            (editor_synced_lyrics_get_type ())
#define EDITOR_SYNCED_LYRICS(obj)            (GTK_CHECK_CAST ((obj), TYPE_EDITOR_SYNCED_LYRICS, EditorSyncedLyrics))
#define EDITOR_SYNCED_LYRICS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_EDITOR_SYNCED_LYRICS, EditorSyncedLyricsClass))
#define IS_EDITOR_SYNCED_LYRICS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_EDITOR_SYNCED_LYRICS))
#define IS_EDITOR_SYNCED_LYRICS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_EDITOR_SYNCED_LYRICS))

typedef struct _EditorSyncedLyrics       EditorSyncedLyrics;
typedef struct _EditorSyncedLyricsClass  EditorSyncedLyricsClass;

struct _EditorSyncedLyrics
{
	SingitEditorView       sev;

	GtkWidget             *before_text;
	GtkWidget             *after_text;
	GtkWidget             *percent_text_scale;
        GtkObject             *percent_text_adj;
};

struct _EditorSyncedLyricsClass
{
	SingitEditorViewClass  parent_class;
};

GtkType    editor_synced_lyrics_get_type  (void);
GtkWidget *editor_synced_lyrics_new       (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // __EDITOR_SYNCED_LYRICS_H__
