
#ifndef __FRAME_BUFFER_H__
#define __FRAME_BUFFER_H__

#include "VFrameBuffer.h"
#include "TempMem.h"


class FrameBuffer : public VFrameBuffer {

public:
	// Available Depths are 1 and any multiple of 8
	FrameBuffer( int inDepth = 8 );

	// Redim this buffer to the given size. If inDepth is <= 0, then the depth is not changed
	void				Resize( int inX, int inY, int inDepth = -1 );

	// Similar to resize but you must be a little more careful.
	void				Assign( char* inSourceBits, int inX, int inY, int inBytesPerRow, int inDepth );

	void				Assign8Bit( char* inSourceBits, int inX, int inY, int inBytesPerRow, int inDepth );
	void				Assign8Bit( const VFrameBuffer* inFrame );
	void				Assign1Bit( const VFrameBuffer* inFrame );

protected:
	TempMem				mTempMem;
};

#endif // __FRAME_BUFFER_H__
