/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <string.h>
#include <stdio.h>

#include "singit_macros.h"
#include "singit_macros_private.h"

#include "singit_tools.h"

gchar* tools_replace_string(gchar *input_string, gchar *token, gchar *replacement)
{
	gchar *new_text = NULL, *new_text_pos, *pos_begin, *pos_end;
	gint token_len, input_len, replacement_len, maxstr_len, text_len;

	if (!input_string || !token || !replacement) { return NULL; }

/*	#ifdef CODEDEBUG
	DEBUG(("singit_tools.c [tools_replace_string]\n"));
	#endif*/

	token_len = strlen(token);
	input_len = strlen(input_string);
	if (token_len > input_len) { return NULL; }

	replacement_len = strlen(replacement);
	maxstr_len = (input_len / token_len + 1) * replacement_len + input_len;
	new_text = g_new(gchar, maxstr_len);
	new_text_pos = new_text;
	pos_begin = input_string;

	while (pos_begin) {
		pos_end = strstr(pos_begin, token);
		if (!pos_end) {
			text_len = strlen(pos_begin);
			if (text_len > 0) { memcpy(new_text_pos, pos_begin, text_len); }
			new_text_pos += text_len;
			new_text_pos[0] = '\0';
			pos_begin = NULL;
		}
		else {
			text_len = pos_end - pos_begin;
			if (text_len > 0) {
				memcpy(new_text_pos, pos_begin, text_len);
				new_text_pos += text_len;
				memcpy(new_text_pos, replacement, replacement_len);
				new_text_pos += replacement_len;
			}
			pos_begin = pos_end + token_len;
		}
	}

	// Just use exact strlen mem
	new_text_pos = new_text;
	new_text = g_strdup(new_text_pos);
	g_free(new_text_pos);

	return new_text;
}

gchar* tools_insert_string(gchar *input_string, gchar *token, guint offset)
{
	gchar *new_text = NULL, *new_text_pos;
	gint token_len, input_len, testit;

	if (!input_string || !token) { return NULL; }
	input_len = strlen(input_string);
	testit = offset - 1;
	if (testit > input_len) { return NULL; }

/*	#ifdef CODEDEBUG
	DEBUG(("singit_tools.c [tools_insert_string]\n"));
	#endif*/

	if (offset == 0) { return g_strconcat(token, input_string, 0); }
	if ((offset-1) == input_len) { return g_strconcat(input_string, token, 0); }

	token_len = strlen(token);

	new_text_pos = new_text = g_new(gchar, token_len + input_len + 1);
	memcpy(new_text_pos, input_string, offset);
	new_text_pos += offset;
	memcpy(new_text_pos, token, token_len);
	new_text_pos += token_len;
	memcpy(new_text_pos, (input_string + offset), input_len - offset);
	new_text[token_len + input_len] = '\0';

	return new_text;
}

gboolean calc_line_intersection(gint a, guint la, gint b, guint lb, gint *r, guint *lr)
{
	gint ra = a + la;
	gint rb = b + lb;

	if ((ra < b) || (a > rb) || (rb < a) || (b > ra)) { return FALSE; }

	if (a > b) { *r = a; }
	else { *r = b; }

	if (ra > rb) { *lr = rb - *r; }
	else { *lr = ra - *r; }

	return TRUE;
}

gboolean calc_rect_intersection
	(gint left_s, gint top_s, guint width_s, guint height_s,
	 gint left_d, gint top_d, guint width_d, guint height_d,
	 gint *left_r, gint *top_r, guint *width_r, guint *height_r)
{
	gint right_s = left_s + width_s;
	gint right_d = left_d + width_d;
	gint bottom_s = top_s + height_s;
	gint bottom_d = top_d + height_d;
	gint right_r, bottom_r;

	if ((right_s < left_d) || (bottom_s < top_d) || (bottom_s < top_d) || (right_s < left_d))
		{ return FALSE; }

	if (left_s < left_d) { *left_r = left_d; }
	else { *left_r = left_s; }

	if (top_s < top_d) { *top_r = top_d; }
	else { *top_r = top_s; }

	if (right_s < right_d) { right_r = right_s; }
	else { right_r = right_d; }

	if (bottom_s < bottom_d) { bottom_r = bottom_s; }
	else { bottom_r = bottom_d; }

	*width_r = right_r - *left_r;
	*height_r = bottom_r - *top_r;

/*	printf("\nSource:     %i, %i, %i, %i\n", left_s, top_s, width_s, height_s);
	printf("Destinatin: %i, %i, %i, %i\n", left_d, top_d, width_d, height_d);
	printf("Result:     %i, %i, %i, %i\n\n", *left_r, *top_r, *width_r, *height_r); */

	return TRUE;
}
