/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_SONG_PRIVATE_H__
#define __SINGIT_SONG_PRIVATE_H__

#include "singit_macros.h"

gboolean l_song_set_song_filename(LSong *song, gchar *filename);

/* loads lyrics into song structure (text / id3v2xx / midi) */
gboolean l_song_load_lyrics(LSong *song, gchar *filename);

/* save lyrics into text file : filename = NULL -> use song lyric file */
gboolean l_song_save_lyrics(LSong *song, gchar *filename);

/* text handlers */

gboolean l_song_load_from_text_file(LSong *song, gchar *filename);
gboolean l_song_save_to_text_file(LSong *song, gchar *filename, gboolean extended);

gboolean l_song_read_text_stream(LSong *song, gchar *buffer);
gboolean l_song_write_text_stream(LSong *song, gchar **buffer, gboolean extended);

/* returns a string, which can be stored as an id3v2.x.x synchronized lyrics tag */
gchar* l_song_create_id3v2_stream(LSong *song);
/* save lyrics into text file : filename = NULL -> use song file */
gboolean l_song_save_id3v2_lyrics(LSong *song, gchar *filename, gboolean extended);


#ifdef HAVE_ID3
gboolean l_song_load_id3v2xx_lyrics(LSong *song, gchar *filename);
#endif

gboolean l_song_load_midi_lyrics(LSong *song, gchar *buffer);

/* compare funtion to sort the tags by time */
gint compare_token_by_time(gconstpointer a, gconstpointer b);

/*
  Get the timetag type / tag = string with maybe prepended tag
  Result :	0 = no tag
  	1 = short tag
	2 = long tag
*/
gint l_song_get_timetag_type(gchar* tag);

#endif // __SINGIT_SONG_PRIVATE_H__
