/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_MACROS_H__
#define __SINGIT_MACROS_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef ENABLE_NLS
#  include <locale.h>
#    include <libintl.h>
#    define _(String) dgettext (PACKAGE, String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop (String)
#    else
#        define N_(String) (String)
#    endif
#else
/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (String)
#    define dgettext(Domain,Message) (Message)
#    define dcgettext(Domain,Message,Type) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#ifdef __GNUC__
/* enable -Wformat with debug() */
void debug(char *format, ...) __attribute__ ((format (printf, 1, 2)));
#else
void debug(char *format, ...);
#endif

#ifdef __cplusplus
}
#endif // __cplusplus

#define SINGIT_VERSION_STRING "XMMS SingIt v" VERSION
#define SINGIT_MAX_PATH_SIZE 1024
#define JMG_EMAIL "glogow@stud.fbi.fh-darmstadt.de"

#ifdef	G_THREADS_ENABLED
#  define GDK_THREADS_TRY_ENTER() (gdk_threads_mutex && (g_mutex_trylock(gdk_threads_mutex) == TRUE))
#else	/* !G_THREADS_ENABLED */
#  define GDK_THREADS_TRY_ENTER()
#endif	/* !G_THREADS_ENABLED */

#endif  // __SINGIT_MACROS_H__
