/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __CLYRICTEXTENGINE_H__
#define __CLYRICTEXTENGINE_H__

#include <glib.h>
#include <GL/gl.h>

#include <gltt/GLTTFont.h>
#include <gltt/GLTTGlyphPolygonizer.h>
#include <gltt/GLTTGlyphTriangulator.h>

#include "singit_song.h"


class CLyricTextEngine
{
protected:
	LSong *song;
	gchar **lines;
	guint max_width, max_height;

	guint line_quantity;
	guint start_line, start_char;

	GData *glyph_data_list;

	FTFace* face;
	GLTTFont *font;
	GList *current;
	bool show_empty_lines;

	guint    pbp_start, pbp_start_last, pbp_offset, pbp_offset_last, pbp_offset_max;  // Progress Bar Positions

	guint   *word_pos;
	guint    ball_y_pos, ball_y_pos_last;
	guint    ball_start, ball_offset_max;
	guint    ball_diameter;

	void init_cylinder();
	void free_lines();
	void set_max_height_and_width();

	bool create_glyth_data(gchar character);
	void create_glyth_data(gchar **new_lines);
	void create_glyth_data(gchar *new_text);
	void set_positions(guint time);

	void drawLine(gchar *text, bool enlighten = false, gdouble border = 0.02f);

public:
	guint glyths;

	CLyricTextEngine();
	virtual ~CLyricTextEngine();

	void draw(guint time);

	void set_song(LSong *new_song);
	void set_text(gchar *new_text);

	inline bool has_lyrics() { return (song && l_song_lyrics_found(song)); }
};

#endif // __CLYRICTEXTENGINE_H__
