/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_CLIST_CONFIG_H__
#define __DISPLAYER_CLIST_CONFIG_H__

#include "singit_config_gen.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _CListConfigData {

	gboolean forceGlobals;
	gboolean hideIfNotFound;
	gboolean showJumpingBall;
	gboolean guessSyncLyrics;
	gboolean showEmpty;
	gboolean autoResize;
#	ifdef CODEDEBUG
	gboolean debugEnable;
#	endif
	gboolean showOnText;

	/* string values */
	gchar *lyricFontName;
	gchar *activeColor;
	gchar *backgroundColor;
	gchar *textColor;

	/* integer values */
	gint winPosX;
	gint winPosY;

}
CListConfigData;

SingitConfigGen *displayer_clist_config_new(void);

#define getDCC(x) ((CListConfigData *) singit_config_gen_get_data(SINGIT_CONFIG_GEN(x)))
#define DEBUG(x)  { if (displayer_clist_config && getDCC(displayer_clist_config) && getDCC(displayer_clist_config)->debugEnable) debug x; }

#ifdef __cplusplus
}
#endif // __cplusplus

#endif  // __DISPLAYER_CLIST_CONFIG_H__
