/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "singit_macros.h"
#include "singit_macros_private.h"
#include "singit_config_private.h"

#include "id3_tables.h"
#include "dlg_singit_id3.h"

static GtkWidget *singit_id3dlg_win = NULL;

static GtkWidget *id3_main_vbox, *id3_notebook,
			*id3_v1_vbox, *id3_mode_v1_label,
				*id3_mode_frame, *id3_modes_table,
					*id3_v1_select_radiobutton,
  					*id3_v2_select_radiobutton,
					*id3_mode_vseparator,
					*id3_mode_strict_radiobutton,
					*id3_mode_auto_radiobutton,
				*id3_v1_frame, *id3_v1_table,
					*id3_v1_title_label, *id3_v1_title_entry, *id3_v1_title_ind_button,
					*id3_v1_artist_label, *id3_v1_artist_entry, *id3_v1_artist_ind_button,
					*id3_v1_album_label, *id3_v1_album_entry, *id3_v1_album_ind_button,
					*id3_v1_comment_label, *id3_v1_comment_entry, *id3_v1_comment_ind_button,
					*id3_v1_year_genre_hbox,
						*id3_v1_year_label, *id3_v1_year_entry,
						*id3_v1_genre_label, *id3_v1_genre_combo, *id3_v1_genre_combo_entry,
			*id3_v2_table, *id3_v2_label,
				*id3_v2_isrc_checkbutton, *id3_v2_isrc_entry,
				*id3_v2_track_checkbutton, *id3_v2_track_spinbutton,
				*id3_v2_language_checkbutton, *id3_v2_language_combo, *id3_v2_language_combo_entry,
				*id3_v2_lyric_writers_checkbutton_vbox, *id3_v2_lyric_writers_checkbutton,
					*id3_v2_lyric_writers_scrolledwindow, *id3_v2_lyric_writers_text,
  				*id3_v2_comment_checkbutton_vbox, *id3_v2_comment_checkbutton,
					*id3_v2_comment_edit_vbox,
					*id3_v2_comment_scrolledwindow, *id3_v2_comment_text,
					*id3_v2_comment_language_combo, *id3_v2_comment_language_combo_entry,
			*id3_v2_frames_vbox, *id3_v2_frame_label,
				*id3_v2_hirarchie_frame, *id3_v2_hirarchie_scrolledwindow,
					*id3_v2_hirarchie_viewport, *id3_v2_hirarchie_tree,
				*id3_v2_tree_modificators_frame, *id3_v2_modificators_table,
					*id3_v2_frame_id_optionmenu, *id3_v2_frame_id_optionmenu_menu,
					*id3_v2_frame_encoding_label,
						*id3_v2_frame_encoding_optionmenu, *id3_v2_frame_encoding_optionmenu_menu,
					*id3_v2_frame_type_label,
						*id3_v2_frame_type_optionmenu, *id3_v2_frame_type_optionmenu_menu,
  				*id3_v2_frame_text_vbox,
					*id3_v2_frame_text_label,
						*id3_v2_frame_text_scrolledwindow, *id3_v2_frame_text_text,
					*id3_v2_frame_line_label, *id3_v2_frame_line_entry,
					*id3_v2_frame_file_selector_button,
		*id3_button_hbox,
			*id3_save_button,
			*id3_remove_button,
			*id3_from_lyrics_button,
			*id3_cancel_button;

static GtkTooltips *tooltips;
static GtkObject *id3_v2_track_spinbutton_adj;
static GSList	*id3_modes_group = NULL,
		*id3_strict_modes_group = NULL;

typedef struct {

	gboolean useId1;
	gboolean beStrict;
	guint id3v2Usage;

	ID3Tag *id3tag;

} Id3DlgStatus;

Id3DlgStatus id3dlg_status;

void singit_language_entry_event(GtkEntry *entry, gpointer user_data)
{
	gchar *text, *language;
	static gboolean is_running = FALSE;
	static gint last_length = -1;
//	GList *item = GTK_LIST(GTK_COMBO(user_data)->list)->children;
	guint i = 0, str_len;

	if (is_running) { return; }
	else { is_running = TRUE; }

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_id3dlg.c [singit_language_entry_event]\n"), 9);
#	endif

	text = gtk_entry_get_text (entry);
	str_len = strlen(text);
	if (str_len < last_length) {
		last_length = str_len;
		is_running = FALSE;
		return;
	}
	last_length = gtk_editable_get_position(GTK_EDITABLE(entry));

//	language_table[i].language_string
	while (i < language_list_count) {
		if (strlen(language_table[i].language_string) >= strlen(text)) {
			language = g_strndup(language_table[i].language_string, strlen(text));
			if (g_strcasecmp(language, text) == 0) {
				gtk_entry_set_text(GTK_ENTRY(entry), language_table[i].language_string);
				gtk_editable_set_position(GTK_EDITABLE(entry), str_len);
//				printf("language-part : %s / %i \n", language, str_len);
				gtk_editable_select_region (GTK_EDITABLE(entry),
                                               str_len, -1);
				g_free(language);
				is_running = FALSE;
				return;
			}
			g_free(language);
		}
		i++;
	}
	is_running = FALSE;
}

void id3_v1_entry_changed_event (GtkEntry *entry, gpointer user_data)
{
	gchar* text;
	text = gtk_entry_get_text (entry);
	gtk_widget_set_sensitive (GTK_WIDGET(user_data), (strlen(text) > 30));
}

void id3_v1_ind_button_clicked (GtkButton *button, gpointer user_data)
{
	gchar* text;
	text = g_strndup(gtk_entry_get_text(GTK_ENTRY(user_data)), 30);
	gtk_entry_set_text(GTK_ENTRY(user_data), text);
	gtk_widget_set_sensitive (GTK_WIDGET(button), FALSE);
	g_free(text);
}

void id3_mode_changed_button_clicked_event (GtkButton *button, gpointer user_data)
{
	switch ((int) user_data) {
	case 0:
		id3dlg_status.useId1 = TRUE;
		if (id3dlg_status.beStrict) {
			gtk_entry_set_max_length(GTK_ENTRY(id3_v1_title_entry), 30);
			gtk_entry_set_max_length(GTK_ENTRY(id3_v1_artist_entry), 30);
			gtk_entry_set_max_length(GTK_ENTRY(id3_v1_album_entry), 30);
			gtk_entry_set_max_length(GTK_ENTRY(id3_v1_comment_entry), 30);
		}
		break;
	case 1:
		id3dlg_status.useId1 = FALSE;
		gtk_entry_set_max_length(GTK_ENTRY(id3_v1_title_entry), 0);
		gtk_entry_set_max_length(GTK_ENTRY(id3_v1_artist_entry), 0);
		gtk_entry_set_max_length(GTK_ENTRY(id3_v1_album_entry), 0);
		gtk_entry_set_max_length(GTK_ENTRY(id3_v1_comment_entry), 0);
		break;
	case 2:
		id3dlg_status.beStrict = TRUE;
		if (id3dlg_status.useId1) {
			gtk_entry_set_max_length(GTK_ENTRY(id3_v1_title_entry), 30);
			gtk_entry_set_max_length(GTK_ENTRY(id3_v1_artist_entry), 30);
			gtk_entry_set_max_length(GTK_ENTRY(id3_v1_album_entry), 30);
			gtk_entry_set_max_length(GTK_ENTRY(id3_v1_comment_entry), 30);
		}
		break;
	case 3:
		id3dlg_status.beStrict = FALSE;
		gtk_entry_set_max_length(GTK_ENTRY(id3_v1_title_entry), 0);
		gtk_entry_set_max_length(GTK_ENTRY(id3_v1_artist_entry), 0);
		gtk_entry_set_max_length(GTK_ENTRY(id3_v1_album_entry), 0);
		gtk_entry_set_max_length(GTK_ENTRY(id3_v1_comment_entry), 0);
		break;
	}
}

gboolean on_id3_v1_year_entry_focus_out_event (GtkWidget *widget, GdkEventFocus *event, gpointer user_data)
{
	return TRUE;
}

static void fill_genre_combo (GtkWidget *combo)
{
	int i = 0;
	static GList *items = NULL;

	if (items == NULL) {
		while (genre_list[i] != NULL) {
			items = g_list_append (items, genre_list[i]);
			i++;
		}
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), items);
}

static void fill_language_combo (GtkWidget *combo)
{
	gint i;
	static GList *items = NULL;

	if (items == NULL) {
		for (i = 0; i < language_list_count; i++) {
			items = g_list_append (items, language_table[i].language_string);
		}
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), items);
}

static gboolean singit_id3dlg_set_entry_from_field (ID3Frame *id3_frame, GtkEntry *entry_widget)
{
	gchar *dyn_text;
	luint num_chars;
	ID3Field *id3_field;

	if ((id3_field = ID3Frame_GetField(id3_frame, ID3FN_TEXT)) != NULL) {
		num_chars = ID3Field_Size(id3_field);
		dyn_text = g_malloc(num_chars + 1);
		dyn_text[num_chars] = '\0';
		ID3Field_GetASCII(id3_field, dyn_text, num_chars, 0);
		gtk_entry_set_text(entry_widget, dyn_text);
		g_free(dyn_text);
		return TRUE;
	}
	return FALSE;
}

static gboolean singit_id3dlg_set_genre (ID3Frame *id3_frame, GtkCombo *combo_widget)
{
	gchar *dyn_text;
	luint num_chars;
	ID3Field *id3_field;
	guint genre_nbr = 0;

	if ((id3_field = ID3Frame_GetField(id3_frame, ID3FN_TEXT)) != NULL) {
		num_chars = ID3Field_Size(id3_field);
		dyn_text = g_malloc(num_chars + 1);
		ID3Field_GetASCII(id3_field, dyn_text, num_chars, 0);
		dyn_text[num_chars-1] = '\0';
		genre_nbr = atoi(dyn_text+1);
//		printf("%i : %s\n", genre_nbr, genre_list[genre_nbr]);
		gtk_list_select_item (GTK_LIST(combo_widget->list), genre_nbr+1);
		g_free(dyn_text);
		return TRUE;
	}
	return FALSE;
}

static void singit_id3dlg_fill_dialog()
{
	size_t nFrames/*, nItems, nDataSize, nSymbol, nTimestamp, len, bytesleft, bytestoparse*/;
//	char *sText, *sDesc, *sLang, *sMimeType, *sFileName, *sOwner, *format;
//	uchar* bin, p;
	ID3Frame *id3_frame;
	ID3_FrameID id3_frame_id;
	ID3Field *id3_field;
	gint parsed_num = 0;
	gchar *dyn_text, *pos;
	guint num_chars;

	if (!id3dlg_status.id3tag) { return; }

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_id3dlg.c [singit_id3dlg_fill_dialog]\n"), 9);
#	endif

	fill_genre_combo(id3_v1_genre_combo);
	fill_language_combo(id3_v2_language_combo);
	fill_language_combo(id3_v2_comment_language_combo);

	for (nFrames = 0; nFrames < ID3Tag_NumFrames(id3dlg_status.id3tag); nFrames++) {
		id3_frame = ID3Tag_GetFrameNum(id3dlg_status.id3tag, nFrames);
		if (NULL != id3_frame) {
			id3_frame_id = ID3Frame_GetID(id3_frame);
			switch (id3_frame_id) {
			case ID3FID_ALBUM: singit_id3dlg_set_entry_from_field(id3_frame, GTK_ENTRY(id3_v1_album_entry)); break;
//			case ID3FID_COMPOSER:
			case ID3FID_CONTENTTYPE: singit_id3dlg_set_genre(id3_frame, GTK_COMBO(id3_v1_genre_combo)); break;
//			case ID3FID_DATE:
//			case ID3FID_PLAYLISTDELAY:
//			case ID3FID_ENCODEDBY:
//			case ID3FID_LYRICIST:
//			case ID3FID_CONTENTGROUP:
			case ID3FID_TITLE: singit_id3dlg_set_entry_from_field(id3_frame, GTK_ENTRY(id3_v1_title_entry)); break;
//			case ID3FID_SUBTITLE:
//			case ID3FID_INITIALKEY:
			case ID3FID_LANGUAGE:
				if ((id3_field = ID3Frame_GetField(id3_frame, ID3FN_LANGUAGE)) != NULL) {
					num_chars = ID3Field_Size(id3_field);
					dyn_text = g_malloc(num_chars + 1);
					ID3Field_GetASCII(id3_field, dyn_text, num_chars, 0);
					gtk_spin_button_set_value(GTK_SPIN_BUTTON(id3_v2_track_spinbutton), parsed_num);
					g_free(dyn_text);
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(id3_v2_track_checkbutton), TRUE);
				}
				break;
			case ID3FID_LEADARTIST: singit_id3dlg_set_entry_from_field(id3_frame, GTK_ENTRY(id3_v1_artist_entry)); break;
//			case ID3FID_BAND:
//			case ID3FID_CONDUCTOR:
//			case ID3FID_PARTINSET:
//			case ID3FID_PUBLISHER:
			case ID3FID_TRACKNUM:
				if ((id3_field = ID3Frame_GetField(id3_frame, ID3FN_TEXT)) != NULL) {
					num_chars = ID3Field_Size(id3_field);
					dyn_text = g_malloc(num_chars + 1);
					ID3Field_GetASCII(id3_field, dyn_text, num_chars, 0);
					// dyn_text[num_chars-1] = '\0';
					pos = strstr(dyn_text, "/");
					if (pos == NULL) {
						parsed_num = atoi(dyn_text);
					}
					else {
						pos = '\0';
						parsed_num = atoi(dyn_text);

					}
					gtk_spin_button_set_value(GTK_SPIN_BUTTON(id3_v2_track_spinbutton), parsed_num);
					g_free(dyn_text);
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(id3_v2_track_checkbutton), TRUE);
				}
				break;
			case ID3FID_ISRC:
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(id3_v2_isrc_checkbutton),
					singit_id3dlg_set_entry_from_field(id3_frame, GTK_ENTRY(id3_v2_isrc_entry)));
				break;
			case ID3FID_YEAR: singit_id3dlg_set_entry_from_field(id3_frame, GTK_ENTRY(id3_v1_year_entry)); break;
			case ID3FID_USERTEXT:
/*				sText = ID3_GetString(myFrame, ID3FN_TEXT),
				sDesc = ID3_GetString(myFrame, ID3FN_DESCRIPTION);
				delete [] sText;
				delete [] sDesc;*/
				break;
			case ID3FID_COMMENT: singit_id3dlg_set_entry_from_field(id3_frame, GTK_ENTRY(id3_v1_comment_entry)); break;
			case ID3FID_UNSYNCEDLYRICS:
/*				sText = ID3_GetString(myFrame, ID3FN_TEXT),
				sDesc = ID3_GetString(myFrame, ID3FN_DESCRIPTION),
				sLang = ID3_GetString(myFrame, ID3FN_LANGUAGE);
				g_free(sText);
				delete [] sDesc;
				delete [] sLang;*/
				break;
			case ID3FID_INVOLVEDPEOPLE:
/*				nItems = myFrame->Field(ID3FN_TEXT).GetNumTextItems();
				for (size_t nIndex = 0; nIndex < nItems; nIndex++) {
					char *sPeople = ID3_GetString(myFrame, ID3FN_TEXT, nIndex);
					delete [] sPeople;
					if (nIndex + 1 < nItems) {
					// Fill
					}
				}*/
				break;
			case ID3FID_GENERALOBJECT:
/*				char *sMimeType = ID3_GetString(myFrame, ID3FN_TEXT),
				     *sDesc = ID3_GetString(myFrame, ID3FN_DESCRIPTION),
				     *sFileName = ID3_GetString(myFrame, ID3FN_FILENAME);
				nDataSize = ID3Field_Size(ID3Frame_GetField(myFrame, ID3FN_DATA));
				delete [] sMimeType;
				delete [] sDesc;
				delete [] sFileName;*/
				break;
			case ID3FID_UNIQUEFILEID:
/*				char *sOwner = ID3_GetString(myFrame, ID3FN_TEXT);
				nDataSize = ID3Field_Size(ID3Frame_GetField(myFrame, ID3FN_DATA));
				delete [] sOwner;*/
				break;
			case ID3FID_SYNCEDLYRICS:
/*				sDesc = ID3_GetString(myFrame, ID3FN_DESCRIPTION);
				sLang = ID3_GetString(myFrame, ID3FN_LANGUAGE);
				nTimestamp = myFrame->Field(ID3FN_TIMESTAMPFORMAT).Get();
				nRating = myFrame->Field(ID3FN_CONTENTTYPE).Get();
				format = (2 == nTimestamp) ? "ms" : "frames";
				switch (nRating) {
				case ID3CT_OTHER:    cout << "Other"; break;
				case ID3CT_LYRICS:   cout << "Lyrics"; break;
				case ID3CT_TEXTTRANSCRIPTION:     cout << "Text transcription"; break;
				case ID3CT_MOVEMENT: cout << "Movement/part name"; break;
				case ID3CT_EVENTS:   cout << "Events"; break;
				case ID3CT_CHORD:    cout << "Chord"; break;
				case ID3CT_TRIVIA:   cout << "Trivia/'pop up' information"; break;
				}
				nDataSize = ID3Field_Size(ID3Frame_GetField(myFrame, ID3FN_DATA));
				bin = myFrame->Field(ID3FN_DATA).GetBinary();
				p = bin;
				while (p < bin + nDataSize) {
					len = strlen((char *)p);
					cout << p;
					p += len + 1;
					if (p < bin + size) {
						bytesleft = bin + size - p,
						bytestoparse = MIN(sizeof(uint32), bytesleft);
						p += 4;
					}
				}
				delete [] sDesc;
				delete [] sLang;*/
				break;
			default:
			break;
			}
		}
	}
}

static void id3v2_select_button_clicked (GtkButton *button, gpointer user_data)
{
	if (GTK_IS_CHECK_BUTTON(button)) {
		if (GTK_TOGGLE_BUTTON(button)->active) { id3dlg_status.id3v2Usage++; }
		else { id3dlg_status.id3v2Usage--; }
	}
}

static void singit_id3dlg_init()
{
#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_id3dlg.c [singit_id3dlg_init]\n"), 9);
#	endif

	id3dlg_status.id3v2Usage = 0;
	id3dlg_status.id3tag = ID3Tag_New();

	if (!singit_config_attach()) {
		singit_config_new();
		singit_config_load();
	}
}

static void singit_id3dlg_cleanup()
{
#	ifdef CODEDEBUG
	DEBUG(("singit_config.c [singit_id3dlg_cleanup]\n"), 9);
#	endif

	ID3Tag_Delete(id3dlg_status.id3tag);
	id3dlg_status.id3tag = NULL;
//	singit_config_gen_save(SINGIT_CONFIG_GEN(singit_config));
	singit_config_detach();
	id3_modes_group = NULL;
	id3_strict_modes_group = NULL;
	id3dlg_status.id3v2Usage = 0;
}

void singit_id3dlg_hide(void)
{
	if (!singit_id3dlg_win) return;

#	ifdef CODEDEBUG
	DEBUG(("singit_config.c [singit_id3dlg_hide]\n"), 9);
#	endif

	singit_id3dlg_cleanup();

	gtk_widget_destroy(singit_id3dlg_win);
}

void singit_id3dlg_cancel_clicked(GtkButton *button, gpointer user_data)
{
	singit_id3dlg_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(singit_id3dlg_win);
}

gint dlg_singit_id3_delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data )
{
	singit_id3dlg_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(singit_id3dlg_win);

	return (FALSE);
}

void singit_id3dlg_show()
{
	gchar *ext;

#	ifdef CODEDEBUG
	DEBUG(("singit_config.c [singit_id3dlg_show]\n"), 9);
#	endif

	if (singit_id3dlg_win) {
		gdk_window_raise(singit_id3dlg_win->window);
		return;
	}

	singit_id3dlg_init();

	if (!(singit_config && getSCD(singit_config) && getSCD(singit_config)->song &&
		((ext = strrchr(getSCD(singit_config)->song->song_filename, '.')) != NULL) &&
		(!g_strcasecmp(ext, ".mp3")))) {
		singit_id3dlg_cleanup();
		return;
	}

	ID3Tag_Link(id3dlg_status.id3tag, getSCD(singit_config)->song->song_filename);
	tooltips = gtk_tooltips_new ();

	singit_id3dlg_win = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_widget_set_name (singit_id3dlg_win, "singit_id3dlg_win");
	gtk_object_set_data (GTK_OBJECT (singit_id3dlg_win), "singit_id3dlg_win", singit_id3dlg_win);
	gtk_window_set_title (GTK_WINDOW (singit_id3dlg_win), _("id3v1/2.x.x tag editor"));
	gtk_window_set_policy (GTK_WINDOW (singit_id3dlg_win), FALSE, FALSE, FALSE);
	gtk_signal_connect(GTK_OBJECT(singit_id3dlg_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &singit_id3dlg_win);
	gtk_signal_connect(GTK_OBJECT(singit_id3dlg_win), "delete_event", GTK_SIGNAL_FUNC(dlg_singit_id3_delete_event), NULL);
	gtk_container_border_width(GTK_CONTAINER(singit_id3dlg_win), 5);

	id3_main_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (id3_main_vbox, "id3_main_vbox");
	gtk_widget_ref (id3_main_vbox);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_main_vbox", id3_main_vbox,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_main_vbox);
	gtk_container_add (GTK_CONTAINER (singit_id3dlg_win), id3_main_vbox);

	id3_notebook = gtk_notebook_new ();
	gtk_widget_set_name (id3_notebook, "id3_notebook");
	gtk_widget_ref (id3_notebook);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_notebook", id3_notebook,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_notebook);
	gtk_box_pack_start (GTK_BOX (id3_main_vbox), id3_notebook, TRUE, TRUE, 0);

	id3_v1_vbox = gtk_vbox_new (FALSE, 1);
	gtk_widget_set_name (id3_v1_vbox, "id3_v1_vbox");
	gtk_widget_ref (id3_v1_vbox);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_vbox", id3_v1_vbox,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_vbox);
	gtk_container_add (GTK_CONTAINER (id3_notebook), id3_v1_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v1_vbox), 3);

	id3_mode_frame = gtk_frame_new (_("id3 mode"));
	gtk_widget_set_name (id3_mode_frame, "id3_mode_frame");
	gtk_widget_ref (id3_mode_frame);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_mode_frame", id3_mode_frame,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_mode_frame);
	gtk_box_pack_start (GTK_BOX (id3_v1_vbox), id3_mode_frame, FALSE, TRUE, 0);

	id3_modes_table = gtk_table_new (2, 3, FALSE);
	gtk_widget_set_name (id3_modes_table, "id3_modes_table");
	gtk_widget_ref (id3_modes_table);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_modes_table", id3_modes_table,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_modes_table);
	gtk_container_add (GTK_CONTAINER (id3_mode_frame), id3_modes_table);
	gtk_table_set_row_spacings (GTK_TABLE (id3_modes_table), 1);
	gtk_table_set_col_spacings (GTK_TABLE (id3_modes_table), 2);

	id3_v1_select_radiobutton = gtk_radio_button_new_with_label (id3_modes_group, _("Use id3 tag v1"));
	id3_modes_group = gtk_radio_button_group (GTK_RADIO_BUTTON (id3_v1_select_radiobutton));
	gtk_widget_set_name (id3_v1_select_radiobutton, "id3_v1_select_radiobutton");
	gtk_widget_ref (id3_v1_select_radiobutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_select_radiobutton",
		id3_v1_select_radiobutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_select_radiobutton);
	gtk_table_attach (GTK_TABLE (id3_modes_table), id3_v1_select_radiobutton, 0, 1, 0, 1,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (id3_v1_select_radiobutton), TRUE);
  	gtk_signal_connect (GTK_OBJECT (id3_v1_select_radiobutton), "clicked",
		GTK_SIGNAL_FUNC (id3_mode_changed_button_clicked_event), (gpointer) 0);

	id3_v2_select_radiobutton = gtk_radio_button_new_with_label (id3_modes_group, _("Use id3 tag v2.x.x"));
	id3_modes_group = gtk_radio_button_group (GTK_RADIO_BUTTON (id3_v2_select_radiobutton));
	gtk_widget_set_name (id3_v2_select_radiobutton, "id3_v2_select_radiobutton");
	gtk_widget_ref (id3_v2_select_radiobutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_select_radiobutton",
		id3_v2_select_radiobutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v2_select_radiobutton);
	gtk_table_attach (GTK_TABLE (id3_modes_table), id3_v2_select_radiobutton, 0, 1, 1, 2,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_signal_connect (GTK_OBJECT (id3_v2_select_radiobutton), "clicked",
		GTK_SIGNAL_FUNC (id3_mode_changed_button_clicked_event), (gpointer) 1);

	id3_mode_vseparator = gtk_vseparator_new ();
	gtk_widget_set_name (id3_mode_vseparator, "id3_mode_vseparator");
	gtk_widget_ref (id3_mode_vseparator);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_mode_vseparator", id3_mode_vseparator,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_mode_vseparator);
	gtk_table_attach (GTK_TABLE (id3_modes_table), id3_mode_vseparator, 1, 2, 0, 2,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);

	id3_mode_strict_radiobutton = gtk_radio_button_new_with_label (id3_strict_modes_group, _("Be strict"));
	id3_strict_modes_group = gtk_radio_button_group (GTK_RADIO_BUTTON (id3_mode_strict_radiobutton));
	gtk_widget_set_name (id3_mode_strict_radiobutton, "id3_mode_strict_radiobutton");
	gtk_widget_ref (id3_mode_strict_radiobutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_mode_strict_radiobutton",
		id3_mode_strict_radiobutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_mode_strict_radiobutton);
	gtk_table_attach (GTK_TABLE (id3_modes_table), id3_mode_strict_radiobutton, 2, 3, 0, 1,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (id3_mode_strict_radiobutton), TRUE);
	gtk_signal_connect (GTK_OBJECT (id3_mode_strict_radiobutton), "clicked",
		GTK_SIGNAL_FUNC (id3_mode_changed_button_clicked_event), (gpointer) 2);

	id3_mode_auto_radiobutton = gtk_radio_button_new_with_label (id3_strict_modes_group, _("Allow auto mode change"));
	id3_strict_modes_group = gtk_radio_button_group (GTK_RADIO_BUTTON (id3_mode_auto_radiobutton));
	gtk_widget_set_name (id3_mode_auto_radiobutton, "id3_mode_auto_radiobutton");
	gtk_widget_ref (id3_mode_auto_radiobutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_mode_auto_radiobutton",
		id3_mode_auto_radiobutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_mode_auto_radiobutton);
	gtk_table_attach (GTK_TABLE (id3_modes_table), id3_mode_auto_radiobutton, 2, 3, 1, 2,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_signal_connect (GTK_OBJECT (id3_mode_auto_radiobutton), "clicked",
		GTK_SIGNAL_FUNC (id3_mode_changed_button_clicked_event), (gpointer) 3);

	id3_v1_frame = gtk_frame_new (_("id3v1"));
	gtk_widget_set_name (id3_v1_frame, "id3_v1_frame");
	gtk_widget_ref (id3_v1_frame);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_frame", id3_v1_frame,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_frame);
	gtk_box_pack_start (GTK_BOX (id3_v1_vbox), id3_v1_frame, FALSE, TRUE, 0);

	id3_v1_table = gtk_table_new (5, 3, FALSE);
	gtk_widget_set_name (id3_v1_table, "id3_v1_table");
	gtk_widget_ref (id3_v1_table);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_table", id3_v1_table,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_table);
	gtk_container_add (GTK_CONTAINER (id3_v1_frame), id3_v1_table);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v1_table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (id3_v1_table), 2);
	gtk_table_set_col_spacings (GTK_TABLE (id3_v1_table), 2);

	id3_v1_title_label = gtk_label_new (_("Title:"));
	gtk_widget_set_name (id3_v1_title_label, "id3_v1_title_label");
	gtk_widget_ref (id3_v1_title_label);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_title_label", id3_v1_title_label,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_title_label);
	gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_title_label, 0, 1, 0, 1,
		(GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

	id3_v1_artist_label = gtk_label_new (_("Artist:"));
	gtk_widget_set_name (id3_v1_artist_label, "id3_v1_artist_label");
	gtk_widget_ref (id3_v1_artist_label);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_artist_label", id3_v1_artist_label,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_artist_label);
	gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_artist_label, 0, 1, 1, 2,
		(GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

	id3_v1_album_label = gtk_label_new (_("Album:"));
	gtk_widget_set_name (id3_v1_album_label, "id3_v1_album_label");
	gtk_widget_ref (id3_v1_album_label);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_album_label", id3_v1_album_label,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_album_label);
	gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_album_label, 0, 1, 2, 3,
		(GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

	id3_v1_comment_label = gtk_label_new (_("Comment:"));
	gtk_widget_set_name (id3_v1_comment_label, "id3_v1_comment_label");
	gtk_widget_ref (id3_v1_comment_label);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_comment_label", id3_v1_comment_label,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_comment_label);
	gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_comment_label, 0, 1, 4, 5,
		(GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

	id3_v1_title_entry = gtk_entry_new ();
	gtk_widget_set_name (id3_v1_title_entry, "id3_v1_title_entry");
	gtk_widget_ref (id3_v1_title_entry);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_title_entry", id3_v1_title_entry,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_title_entry);
	gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_title_entry, 1, 2, 0, 1,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  id3_v1_artist_entry = gtk_entry_new ();
  gtk_widget_set_name (id3_v1_artist_entry, "id3_v1_artist_entry");
  gtk_widget_ref (id3_v1_artist_entry);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_artist_entry", id3_v1_artist_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_artist_entry);
  gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_artist_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  id3_v1_album_entry = gtk_entry_new ();
  gtk_widget_set_name (id3_v1_album_entry, "id3_v1_album_entry");
  gtk_widget_ref (id3_v1_album_entry);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_album_entry", id3_v1_album_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_album_entry);
  gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_album_entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  id3_v1_comment_entry = gtk_entry_new ();
  gtk_widget_set_name (id3_v1_comment_entry, "id3_v1_comment_entry");
  gtk_widget_ref (id3_v1_comment_entry);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_comment_entry",
		id3_v1_comment_entry, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_comment_entry);
	gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_comment_entry, 1, 2, 4, 5,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_tooltips_set_tip (tooltips, id3_v1_comment_entry, _("v1: Comment / v2: comment content"), NULL);

  id3_v1_year_genre_hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (id3_v1_year_genre_hbox, "id3_v1_year_genre_hbox");
  gtk_widget_ref (id3_v1_year_genre_hbox);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_year_genre_hbox", id3_v1_year_genre_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_year_genre_hbox);
  gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_year_genre_hbox, 0, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  id3_v1_year_label = gtk_label_new (_("Year:"));
  gtk_widget_set_name (id3_v1_year_label, "id3_v1_year_label");
  gtk_widget_ref (id3_v1_year_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_year_label", id3_v1_year_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_year_label);
  gtk_box_pack_start (GTK_BOX (id3_v1_year_genre_hbox), id3_v1_year_label, TRUE, TRUE, 0);

  id3_v1_year_entry = gtk_entry_new_with_max_length (4);
  gtk_widget_set_name (id3_v1_year_entry, "id3_v1_year_entry");
  gtk_widget_ref (id3_v1_year_entry);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_year_entry", id3_v1_year_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_year_entry);
  gtk_box_pack_start (GTK_BOX (id3_v1_year_genre_hbox), id3_v1_year_entry, FALSE, FALSE, 5);
  gtk_widget_set_usize (id3_v1_year_entry, 57, -2);
//  gtk_entry_set_text (GTK_ENTRY (id3_v1_year_entry), _("2000"));

  id3_v1_genre_label = gtk_label_new (_("Genre:"));
  gtk_widget_set_name (id3_v1_genre_label, "id3_v1_genre_label");
  gtk_widget_ref (id3_v1_genre_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_genre_label", id3_v1_genre_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_genre_label);
  gtk_box_pack_start (GTK_BOX (id3_v1_year_genre_hbox), id3_v1_genre_label, TRUE, TRUE, 0);

	id3_v1_genre_combo = gtk_combo_new ();
	gtk_widget_set_name (id3_v1_genre_combo, "id3_v1_genre_combo");
	gtk_widget_ref (id3_v1_genre_combo);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_genre_combo",
		id3_v1_genre_combo, (GtkDestroyNotify) gtk_widget_unref);
	gtk_combo_set_value_in_list (GTK_COMBO(id3_v1_genre_combo), TRUE, TRUE);
	gtk_widget_show (id3_v1_genre_combo);
	gtk_box_pack_start (GTK_BOX (id3_v1_year_genre_hbox), id3_v1_genre_combo, TRUE, TRUE, 0);

	id3_v1_genre_combo_entry = GTK_COMBO (id3_v1_genre_combo)->entry;
	gtk_widget_set_name (id3_v1_genre_combo_entry, "id3_v1_genre_combo_entry");
	gtk_widget_ref (id3_v1_genre_combo_entry);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_genre_combo_entry",
		id3_v1_genre_combo_entry, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v1_genre_combo_entry);

  id3_v1_title_ind_button = gtk_button_new_with_label (_("v1"));
  gtk_widget_set_name (id3_v1_title_ind_button, "id3_v1_title_ind_button");
  gtk_widget_ref (id3_v1_title_ind_button);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_title_ind_button", id3_v1_title_ind_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_title_ind_button);
  gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_title_ind_button, 2, 3, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (id3_v1_title_ind_button, FALSE);
  gtk_tooltips_set_tip (tooltips, id3_v1_title_ind_button, _("Reduce size to id3v1 (30)"), NULL);

  id3_v1_artist_ind_button = gtk_button_new_with_label (_("v1"));
  gtk_widget_set_name (id3_v1_artist_ind_button, "id3_v1_artist_ind_button");
  gtk_widget_ref (id3_v1_artist_ind_button);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_artist_ind_button", id3_v1_artist_ind_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_artist_ind_button);
  gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_artist_ind_button, 2, 3, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (id3_v1_artist_ind_button, FALSE);
  gtk_tooltips_set_tip (tooltips, id3_v1_artist_ind_button, _("Reduce size to id3v1 (30)"), NULL);

  id3_v1_album_ind_button = gtk_button_new_with_label (_("v1"));
  gtk_widget_set_name (id3_v1_album_ind_button, "id3_v1_album_ind_button");
  gtk_widget_ref (id3_v1_album_ind_button);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_album_ind_button", id3_v1_album_ind_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_album_ind_button);
  gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_album_ind_button, 2, 3, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (id3_v1_album_ind_button, FALSE);
  gtk_tooltips_set_tip (tooltips, id3_v1_album_ind_button, _("Reduce size to id3v1 (30)"), NULL);

  id3_v1_comment_ind_button = gtk_button_new_with_label (_("v1"));
  gtk_widget_set_name (id3_v1_comment_ind_button, "id3_v1_comment_ind_button");
  gtk_widget_ref (id3_v1_comment_ind_button);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v1_comment_ind_button", id3_v1_comment_ind_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v1_comment_ind_button);
  gtk_table_attach (GTK_TABLE (id3_v1_table), id3_v1_comment_ind_button, 2, 3, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (id3_v1_comment_ind_button, FALSE);
  gtk_tooltips_set_tip (tooltips, id3_v1_comment_ind_button, _("Reduce size to id3v1 (30)"), NULL);

  id3_mode_v1_label = gtk_label_new (_("id3 mode / v1"));
  gtk_widget_set_name (id3_mode_v1_label, "id3_mode_v1_label");
  gtk_widget_ref (id3_mode_v1_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_mode_v1_label", id3_mode_v1_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_mode_v1_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (id3_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (id3_notebook), 0), id3_mode_v1_label);

  id3_v2_table = gtk_table_new (5, 2, FALSE);
  gtk_widget_set_name (id3_v2_table, "id3_v2_table");
  gtk_widget_ref (id3_v2_table);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_table", id3_v2_table,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_table);
  gtk_container_add (GTK_CONTAINER (id3_notebook), id3_v2_table);
  gtk_container_set_border_width (GTK_CONTAINER (id3_v2_table), 1);
  gtk_table_set_row_spacings (GTK_TABLE (id3_v2_table), 3);
  gtk_table_set_col_spacings (GTK_TABLE (id3_v2_table), 2);

  id3_v2_isrc_entry = gtk_entry_new_with_max_length (12);
  gtk_widget_set_name (id3_v2_isrc_entry, "id3_v2_isrc_entry");
  gtk_widget_ref (id3_v2_isrc_entry);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_isrc_entry", id3_v2_isrc_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_isrc_entry);
  gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_isrc_entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, id3_v2_isrc_entry, _("International Standard Recording Code"), NULL);

  id3_v2_track_spinbutton_adj = gtk_adjustment_new (1, 1, 99, 1, 10, 10);
  id3_v2_track_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (id3_v2_track_spinbutton_adj), 1, 0);
  gtk_widget_set_name (id3_v2_track_spinbutton, "id3_v2_track_spinbutton");
  gtk_widget_ref (id3_v2_track_spinbutton);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_track_spinbutton", id3_v2_track_spinbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_track_spinbutton);
  gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_track_spinbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

	id3_v2_language_combo = gtk_combo_new ();
	gtk_widget_set_name (id3_v2_language_combo, "id3_v2_language_combo");
	gtk_widget_ref (id3_v2_language_combo);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_language_combo",
		id3_v2_language_combo, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v2_language_combo);
	gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_language_combo, 1, 2, 0, 1,
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	id3_v2_language_combo_entry = GTK_COMBO (id3_v2_language_combo)->entry;
	gtk_widget_set_name (id3_v2_language_combo_entry, "id3_v2_language_combo_entry");
	gtk_widget_ref (id3_v2_language_combo_entry);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_language_combo_entry", id3_v2_language_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(id3_v2_language_combo_entry), "changed", GTK_SIGNAL_FUNC(singit_language_entry_event), (gpointer) id3_v2_language_combo);
	gtk_widget_show (id3_v2_language_combo_entry);

	id3_v2_track_checkbutton = gtk_check_button_new_with_label (_("Track:"));
	gtk_widget_set_name (id3_v2_track_checkbutton, "id3_v2_track_checkbutton");
	gtk_widget_ref (id3_v2_track_checkbutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_track_checkbutton",
		id3_v2_track_checkbutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v2_track_checkbutton);
	gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_track_checkbutton, 0, 1, 1, 2,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_signal_connect(GTK_OBJECT(id3_v2_track_checkbutton), "toggled", GTK_SIGNAL_FUNC(id3v2_select_button_clicked), NULL);

	id3_v2_language_checkbutton = gtk_check_button_new_with_label (_("Language:"));
	gtk_widget_set_name (id3_v2_language_checkbutton, "id3_v2_language_checkbutton");
	gtk_widget_ref (id3_v2_language_checkbutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_language_checkbutton",
		id3_v2_language_checkbutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v2_language_checkbutton);
	gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_language_checkbutton, 0, 1, 0, 1,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_signal_connect(GTK_OBJECT(id3_v2_language_checkbutton), "toggled", GTK_SIGNAL_FUNC(id3v2_select_button_clicked), NULL);

	id3_v2_isrc_checkbutton = gtk_check_button_new_with_label (_("ISRC:"));
	gtk_widget_set_name (id3_v2_isrc_checkbutton, "id3_v2_isrc_checkbutton");
	gtk_widget_ref (id3_v2_isrc_checkbutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_isrc_checkbutton",
		id3_v2_isrc_checkbutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v2_isrc_checkbutton);
	gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_isrc_checkbutton, 0, 1, 2, 3,
		(GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_signal_connect(GTK_OBJECT(id3_v2_isrc_checkbutton), "toggled", GTK_SIGNAL_FUNC(id3v2_select_button_clicked), NULL);

  id3_v2_lyric_writers_checkbutton_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (id3_v2_lyric_writers_checkbutton_vbox, "id3_v2_lyric_writers_checkbutton_vbox");
  gtk_widget_ref (id3_v2_lyric_writers_checkbutton_vbox);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_lyric_writers_checkbutton_vbox", id3_v2_lyric_writers_checkbutton_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_lyric_writers_checkbutton_vbox);
  gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_lyric_writers_checkbutton_vbox, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	id3_v2_lyric_writers_checkbutton = gtk_check_button_new_with_label (_("Lyric writers:"));
	gtk_widget_set_name (id3_v2_lyric_writers_checkbutton, "id3_v2_lyric_writers_checkbutton");
	gtk_widget_ref (id3_v2_lyric_writers_checkbutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_lyric_writers_checkbutton",
		id3_v2_lyric_writers_checkbutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v2_lyric_writers_checkbutton);
	gtk_box_pack_start (GTK_BOX (id3_v2_lyric_writers_checkbutton_vbox), id3_v2_lyric_writers_checkbutton, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(id3_v2_lyric_writers_checkbutton), "toggled", GTK_SIGNAL_FUNC(id3v2_select_button_clicked), NULL);

  id3_v2_lyric_writers_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (id3_v2_lyric_writers_scrolledwindow, "id3_v2_lyric_writers_scrolledwindow");
  gtk_widget_ref (id3_v2_lyric_writers_scrolledwindow);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_lyric_writers_scrolledwindow", id3_v2_lyric_writers_scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_lyric_writers_scrolledwindow);
  gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_lyric_writers_scrolledwindow, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (id3_v2_lyric_writers_scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  id3_v2_lyric_writers_text = gtk_text_new (NULL, NULL);
  gtk_widget_set_name (id3_v2_lyric_writers_text, "id3_v2_lyric_writers_text");
  gtk_widget_ref (id3_v2_lyric_writers_text);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_lyric_writers_text", id3_v2_lyric_writers_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_lyric_writers_text);
  gtk_container_add (GTK_CONTAINER (id3_v2_lyric_writers_scrolledwindow), id3_v2_lyric_writers_text);
  gtk_tooltips_set_tip (tooltips, id3_v2_lyric_writers_text, _("One writer per line !!!"), NULL);
  gtk_text_set_editable (GTK_TEXT (id3_v2_lyric_writers_text), TRUE);

  id3_v2_comment_checkbutton_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (id3_v2_comment_checkbutton_vbox, "id3_v2_comment_checkbutton_vbox");
  gtk_widget_ref (id3_v2_comment_checkbutton_vbox);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_comment_checkbutton_vbox", id3_v2_comment_checkbutton_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_comment_checkbutton_vbox);
  gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_comment_checkbutton_vbox, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	id3_v2_comment_checkbutton = gtk_check_button_new_with_label (_("Comment:"));
	gtk_widget_set_name (id3_v2_comment_checkbutton, "id3_v2_comment_checkbutton");
	gtk_widget_ref (id3_v2_comment_checkbutton);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_comment_checkbutton",
		id3_v2_comment_checkbutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_v2_comment_checkbutton);
	gtk_box_pack_start (GTK_BOX (id3_v2_comment_checkbutton_vbox), id3_v2_comment_checkbutton, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(id3_v2_comment_checkbutton), "toggled", GTK_SIGNAL_FUNC(id3v2_select_button_clicked), NULL);

  id3_v2_comment_edit_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (id3_v2_comment_edit_vbox, "id3_v2_comment_edit_vbox");
  gtk_widget_ref (id3_v2_comment_edit_vbox);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_comment_edit_vbox", id3_v2_comment_edit_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_comment_edit_vbox);
  gtk_table_attach (GTK_TABLE (id3_v2_table), id3_v2_comment_edit_vbox, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  id3_v2_comment_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (id3_v2_comment_scrolledwindow, "id3_v2_comment_scrolledwindow");
  gtk_widget_ref (id3_v2_comment_scrolledwindow);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_comment_scrolledwindow", id3_v2_comment_scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_comment_scrolledwindow);
  gtk_box_pack_start (GTK_BOX (id3_v2_comment_edit_vbox), id3_v2_comment_scrolledwindow, TRUE, TRUE, 0);
  gtk_widget_set_usize (id3_v2_comment_scrolledwindow, -2, 60);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (id3_v2_comment_scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  id3_v2_comment_text = gtk_text_new (NULL, NULL);
  gtk_widget_set_name (id3_v2_comment_text, "id3_v2_comment_text");
  gtk_widget_ref (id3_v2_comment_text);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_comment_text", id3_v2_comment_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_comment_text);
  gtk_container_add (GTK_CONTAINER (id3_v2_comment_scrolledwindow), id3_v2_comment_text);
  gtk_tooltips_set_tip (tooltips, id3_v2_comment_text, _("Comment long text"), NULL);
  gtk_text_set_editable (GTK_TEXT (id3_v2_comment_text), TRUE);

  id3_v2_comment_language_combo = gtk_combo_new ();
  gtk_widget_set_name (id3_v2_comment_language_combo, "id3_v2_comment_language_combo");
  gtk_widget_ref (id3_v2_comment_language_combo);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_comment_language_combo", id3_v2_comment_language_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_comment_language_combo);
  gtk_box_pack_start (GTK_BOX (id3_v2_comment_edit_vbox), id3_v2_comment_language_combo, FALSE, FALSE, 0);

  id3_v2_comment_language_combo_entry = GTK_COMBO (id3_v2_comment_language_combo)->entry;
  gtk_widget_set_name (id3_v2_comment_language_combo_entry, "id3_v2_comment_language_combo_entry");
  gtk_widget_ref (id3_v2_comment_language_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_comment_language_combo_entry", id3_v2_comment_language_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_comment_language_combo_entry);
  gtk_tooltips_set_tip (tooltips, id3_v2_comment_language_combo_entry, _("Language of the comment"), NULL);

  id3_v2_label = gtk_label_new (_("id3v2.x.x"));
  gtk_widget_set_name (id3_v2_label, "id3_v2_label");
  gtk_widget_ref (id3_v2_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_label", id3_v2_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (id3_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (id3_notebook), 1), id3_v2_label);

	id3_v2_frames_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_set_name (id3_v2_frames_vbox, "id3_v2_frames_vbox");
	gtk_widget_ref (id3_v2_frames_vbox);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frames_vbox",
		id3_v2_frames_vbox, (GtkDestroyNotify) gtk_widget_unref);
//	gtk_widget_show (id3_v2_frames_vbox);
	gtk_container_add (GTK_CONTAINER (id3_notebook), id3_v2_frames_vbox);

  id3_v2_hirarchie_frame = gtk_frame_new (_("id3v2 hirarchie tree"));
  gtk_widget_set_name (id3_v2_hirarchie_frame, "id3_v2_hirarchie_frame");
  gtk_widget_ref (id3_v2_hirarchie_frame);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_hirarchie_frame", id3_v2_hirarchie_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_hirarchie_frame);
  gtk_box_pack_start (GTK_BOX (id3_v2_frames_vbox), id3_v2_hirarchie_frame, TRUE, TRUE, 0);

  id3_v2_hirarchie_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (id3_v2_hirarchie_scrolledwindow, "id3_v2_hirarchie_scrolledwindow");
  gtk_widget_ref (id3_v2_hirarchie_scrolledwindow);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_hirarchie_scrolledwindow", id3_v2_hirarchie_scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_hirarchie_scrolledwindow);
  gtk_container_add (GTK_CONTAINER (id3_v2_hirarchie_frame), id3_v2_hirarchie_scrolledwindow);
  gtk_container_set_border_width (GTK_CONTAINER (id3_v2_hirarchie_scrolledwindow), 2);

  id3_v2_hirarchie_viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_set_name (id3_v2_hirarchie_viewport, "id3_v2_hirarchie_viewport");
  gtk_widget_ref (id3_v2_hirarchie_viewport);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_hirarchie_viewport", id3_v2_hirarchie_viewport,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_hirarchie_viewport);
  gtk_container_add (GTK_CONTAINER (id3_v2_hirarchie_scrolledwindow), id3_v2_hirarchie_viewport);

  id3_v2_hirarchie_tree = gtk_tree_new ();
  gtk_widget_set_name (id3_v2_hirarchie_tree, "id3_v2_hirarchie_tree");
  gtk_widget_ref (id3_v2_hirarchie_tree);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_hirarchie_tree", id3_v2_hirarchie_tree,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_hirarchie_tree);
  gtk_container_add (GTK_CONTAINER (id3_v2_hirarchie_viewport), id3_v2_hirarchie_tree);

  id3_v2_tree_modificators_frame = gtk_frame_new (_("id3v2 tree modificators"));
  gtk_widget_set_name (id3_v2_tree_modificators_frame, "id3_v2_tree_modificators_frame");
  gtk_widget_ref (id3_v2_tree_modificators_frame);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_tree_modificators_frame", id3_v2_tree_modificators_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_tree_modificators_frame);
  gtk_box_pack_start (GTK_BOX (id3_v2_frames_vbox), id3_v2_tree_modificators_frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (id3_v2_tree_modificators_frame), 2);

  id3_v2_modificators_table = gtk_table_new (4, 4, FALSE);
  gtk_widget_set_name (id3_v2_modificators_table, "id3_v2_modificators_table");
  gtk_widget_ref (id3_v2_modificators_table);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_modificators_table", id3_v2_modificators_table,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_modificators_table);
  gtk_container_add (GTK_CONTAINER (id3_v2_tree_modificators_frame), id3_v2_modificators_table);
  gtk_container_set_border_width (GTK_CONTAINER (id3_v2_modificators_table), 2);
  gtk_table_set_row_spacings (GTK_TABLE (id3_v2_modificators_table), 2);
  gtk_table_set_col_spacings (GTK_TABLE (id3_v2_modificators_table), 2);

  id3_v2_frame_id_optionmenu = gtk_option_menu_new ();
  gtk_widget_set_name (id3_v2_frame_id_optionmenu, "id3_v2_frame_id_optionmenu");
  gtk_widget_ref (id3_v2_frame_id_optionmenu);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_id_optionmenu", id3_v2_frame_id_optionmenu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_id_optionmenu);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_id_optionmenu, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  id3_v2_frame_id_optionmenu_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (id3_v2_frame_id_optionmenu), id3_v2_frame_id_optionmenu_menu);

  id3_v2_frame_encoding_optionmenu = gtk_option_menu_new ();
  gtk_widget_set_name (id3_v2_frame_encoding_optionmenu, "id3_v2_frame_encoding_optionmenu");
  gtk_widget_ref (id3_v2_frame_encoding_optionmenu);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_encoding_optionmenu", id3_v2_frame_encoding_optionmenu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_encoding_optionmenu);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_encoding_optionmenu, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  id3_v2_frame_encoding_optionmenu_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (id3_v2_frame_encoding_optionmenu), id3_v2_frame_encoding_optionmenu_menu);

  id3_v2_frame_encoding_label = gtk_label_new (_("Encoding:"));
  gtk_widget_set_name (id3_v2_frame_encoding_label, "id3_v2_frame_encoding_label");
  gtk_widget_ref (id3_v2_frame_encoding_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_encoding_label", id3_v2_frame_encoding_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_encoding_label);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_encoding_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  id3_v2_frame_type_label = gtk_label_new (_("Frame type:"));
  gtk_widget_set_name (id3_v2_frame_type_label, "id3_v2_frame_type_label");
  gtk_widget_ref (id3_v2_frame_type_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_type_label", id3_v2_frame_type_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_type_label);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_type_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  id3_v2_frame_line_label = gtk_label_new (_("Frame line:"));
  gtk_widget_set_name (id3_v2_frame_line_label, "id3_v2_frame_line_label");
  gtk_widget_ref (id3_v2_frame_line_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_line_label", id3_v2_frame_line_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_line_label);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_line_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  id3_v2_frame_type_optionmenu = gtk_option_menu_new ();
  gtk_widget_set_name (id3_v2_frame_type_optionmenu, "id3_v2_frame_type_optionmenu");
  gtk_widget_ref (id3_v2_frame_type_optionmenu);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_type_optionmenu", id3_v2_frame_type_optionmenu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_type_optionmenu);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_type_optionmenu, 2, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  id3_v2_frame_type_optionmenu_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (id3_v2_frame_type_optionmenu), id3_v2_frame_type_optionmenu_menu);

  id3_v2_frame_text_vbox = gtk_vbox_new (FALSE, 1);
  gtk_widget_set_name (id3_v2_frame_text_vbox, "id3_v2_frame_text_vbox");
  gtk_widget_ref (id3_v2_frame_text_vbox);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_text_vbox", id3_v2_frame_text_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_text_vbox);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_text_vbox, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (id3_v2_frame_text_vbox), 1);

  id3_v2_frame_text_label = gtk_label_new (_("Frame text:"));
  gtk_widget_set_name (id3_v2_frame_text_label, "id3_v2_frame_text_label");
  gtk_widget_ref (id3_v2_frame_text_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_text_label", id3_v2_frame_text_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_text_label);
  gtk_box_pack_start (GTK_BOX (id3_v2_frame_text_vbox), id3_v2_frame_text_label, FALSE, TRUE, 0);

  id3_v2_frame_text_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (id3_v2_frame_text_scrolledwindow, "id3_v2_frame_text_scrolledwindow");
  gtk_widget_ref (id3_v2_frame_text_scrolledwindow);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_text_scrolledwindow", id3_v2_frame_text_scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_text_scrolledwindow);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_text_scrolledwindow, 1, 4, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (id3_v2_frame_text_scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  id3_v2_frame_text_text = gtk_text_new (NULL, NULL);
  gtk_widget_set_name (id3_v2_frame_text_text, "id3_v2_frame_text_text");
  gtk_widget_ref (id3_v2_frame_text_text);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_text_text", id3_v2_frame_text_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_text_text);
  gtk_container_add (GTK_CONTAINER (id3_v2_frame_text_scrolledwindow), id3_v2_frame_text_text);

  id3_v2_frame_line_entry = gtk_entry_new ();
  gtk_widget_set_name (id3_v2_frame_line_entry, "id3_v2_frame_line_entry");
  gtk_widget_ref (id3_v2_frame_line_entry);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_line_entry", id3_v2_frame_line_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_line_entry);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_line_entry, 1, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 2);

  id3_v2_frame_file_selector_button = gtk_button_new_with_label (_("File selector..."));
  gtk_widget_set_name (id3_v2_frame_file_selector_button, "id3_v2_frame_file_selector_button");
  gtk_widget_ref (id3_v2_frame_file_selector_button);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_file_selector_button", id3_v2_frame_file_selector_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_file_selector_button);
  gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_file_selector_button, 2, 3, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_container_set_border_width (GTK_CONTAINER (id3_v2_frame_file_selector_button), 1);

  id3_v2_frame_label = gtk_label_new (_("id3v2 frames"));
  gtk_widget_set_name (id3_v2_frame_label, "id3_v2_frame_label");
  gtk_widget_ref (id3_v2_frame_label);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_v2_frame_label", id3_v2_frame_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_v2_frame_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (id3_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (id3_notebook), 2), id3_v2_frame_label);

  id3_button_hbox = gtk_hbox_new (TRUE, 3);
  gtk_widget_set_name (id3_button_hbox, "id3_button_hbox");
  gtk_widget_ref (id3_button_hbox);
  gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_button_hbox", id3_button_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (id3_button_hbox);
  gtk_box_pack_start (GTK_BOX (id3_main_vbox), id3_button_hbox, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (id3_button_hbox), 1);

	id3_save_button = gtk_button_new_with_label (_("Save"));
	gtk_widget_set_name (id3_save_button, "id3_save_button");
	gtk_widget_ref (id3_save_button);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_save_button", id3_save_button,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_save_button);
	gtk_box_pack_start (GTK_BOX (id3_button_hbox), id3_save_button, TRUE, TRUE, 1);
	gtk_container_set_border_width (GTK_CONTAINER (id3_save_button), 1);
	gtk_widget_set_sensitive (id3_save_button, FALSE);

	id3_remove_button = gtk_button_new_with_label (_("Remove"));
	gtk_widget_set_name (id3_remove_button, "id3_remove_button");
	gtk_widget_ref (id3_remove_button);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_remove_button", id3_remove_button,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_remove_button);
	gtk_box_pack_start (GTK_BOX (id3_button_hbox), id3_remove_button, TRUE, TRUE, 1);
	gtk_container_set_border_width (GTK_CONTAINER (id3_remove_button), 1);
	gtk_widget_set_sensitive (id3_remove_button, FALSE);

	id3_from_lyrics_button = gtk_button_new_with_label (_("From lyrics"));
	gtk_widget_set_name (id3_from_lyrics_button, "id3_from_lyrics_button");
	gtk_widget_ref (id3_from_lyrics_button);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_from_lyrics_button", id3_from_lyrics_button,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_from_lyrics_button);
	gtk_box_pack_start (GTK_BOX (id3_button_hbox), id3_from_lyrics_button, TRUE, TRUE, 1);
	gtk_container_set_border_width (GTK_CONTAINER (id3_from_lyrics_button), 1);
	gtk_widget_set_sensitive (id3_from_lyrics_button, FALSE);

	id3_cancel_button = gtk_button_new_with_label (_("Cancel"));
	gtk_widget_set_name (id3_cancel_button, "id3_cancel_button");
	gtk_widget_ref (id3_cancel_button);
	gtk_object_set_data_full (GTK_OBJECT (singit_id3dlg_win), "id3_cancel_button", id3_cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (id3_cancel_button);
	gtk_box_pack_start (GTK_BOX (id3_button_hbox), id3_cancel_button, FALSE, TRUE, 1);
	gtk_container_set_border_width (GTK_CONTAINER (id3_cancel_button), 1);
	GTK_WIDGET_SET_FLAGS (id3_cancel_button, GTK_CAN_DEFAULT);
  	gtk_signal_connect_object (GTK_OBJECT (id3_cancel_button), "clicked",
		GTK_SIGNAL_FUNC (singit_id3dlg_cancel_clicked), NULL);

	gtk_signal_connect (GTK_OBJECT (id3_v1_title_entry), "changed",
		GTK_SIGNAL_FUNC (id3_v1_entry_changed_event), id3_v1_title_ind_button);
	gtk_signal_connect (GTK_OBJECT (id3_v1_artist_entry), "changed",
		GTK_SIGNAL_FUNC (id3_v1_entry_changed_event), id3_v1_artist_ind_button);
	gtk_signal_connect (GTK_OBJECT (id3_v1_album_entry), "changed",
		GTK_SIGNAL_FUNC (id3_v1_entry_changed_event), id3_v1_album_ind_button);
	gtk_signal_connect (GTK_OBJECT (id3_v1_comment_entry), "changed",
		GTK_SIGNAL_FUNC (id3_v1_entry_changed_event), id3_v1_comment_ind_button);

	gtk_signal_connect (GTK_OBJECT (id3_v1_title_ind_button), "clicked",
		GTK_SIGNAL_FUNC (id3_v1_ind_button_clicked), id3_v1_title_entry);
	gtk_signal_connect (GTK_OBJECT (id3_v1_artist_ind_button), "clicked",
		GTK_SIGNAL_FUNC (id3_v1_ind_button_clicked), id3_v1_artist_entry);
	gtk_signal_connect (GTK_OBJECT (id3_v1_album_ind_button), "clicked",
		GTK_SIGNAL_FUNC (id3_v1_ind_button_clicked), id3_v1_album_entry);
	gtk_signal_connect (GTK_OBJECT (id3_v1_comment_ind_button), "clicked",
		GTK_SIGNAL_FUNC (id3_v1_ind_button_clicked), id3_v1_comment_entry);

	gtk_signal_connect (GTK_OBJECT (id3_v1_year_entry), "focus_out_event",
		GTK_SIGNAL_FUNC (on_id3_v1_year_entry_focus_out_event), NULL);

	gtk_widget_grab_default (id3_cancel_button);
	gtk_object_set_data (GTK_OBJECT (singit_id3dlg_win), "tooltips", tooltips);

	gtk_entry_set_max_length(GTK_ENTRY(id3_v1_title_entry), 30);
	gtk_entry_set_max_length(GTK_ENTRY(id3_v1_artist_entry), 30);
	gtk_entry_set_max_length(GTK_ENTRY(id3_v1_album_entry), 30);
	gtk_entry_set_max_length(GTK_ENTRY(id3_v1_comment_entry), 30);

	singit_id3dlg_fill_dialog();

	gtk_widget_set_usize(id3_v1_genre_combo, id3_v1_genre_combo->allocation.width-10, id3_v1_genre_combo->allocation.height);
	gtk_widget_show(singit_id3dlg_win);
}
