/*  
   xmms-sid - SIDPlay input plugin for X MultiMedia System (XMMS)

   Aboutbox dialog
   
   Written by Matti "ccr" Hamalainen <mhamalai@ratol.fi>
   (Created with Glade, the Gtk+ interface builder, but edited
   by hand afterwards to make it work here)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "xmms-sid.h"
#include <gtk/gtk.h>
#include "xmms-sid-logo.xpm"


static GtkWidget *xs_aboutwin = NULL;

int xs_aboutwin_ok(void)
{
 gtk_widget_destroy(xs_aboutwin);
 return 0;
}


/*
 * Execute the aboutbox
 */
void xs_aboutbox(void)
{
	GtkWidget *vbox1, *hbox1, *frame1, *pixmapwid;
	GtkWidget *label1, *hbuttonbox1, *about_ok;
	GdkPixmap *pixmap;
	GdkBitmap *pixmask;
	GtkStyle  *style;
	
	/* Check if there already is an open about window */
	if (xs_aboutwin != NULL) {
		gdk_window_raise(xs_aboutwin->window);
		return;
		}

	/* No, create one ... */	
	xs_aboutwin = gtk_dialog_new();
	gtk_object_set_data(GTK_OBJECT(xs_aboutwin), "xs_aboutwin", xs_aboutwin);
	gtk_window_set_title(GTK_WINDOW(xs_aboutwin), "About xmms-sid SIDPlay plugin");
	gtk_window_set_policy(GTK_WINDOW(xs_aboutwin), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(xs_aboutwin), GTK_WIN_POS_MOUSE);
	gtk_signal_connect(GTK_OBJECT(xs_aboutwin), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &xs_aboutwin);
	gtk_container_border_width(GTK_CONTAINER(xs_aboutwin), 10);

	vbox1 = GTK_DIALOG(xs_aboutwin)->vbox;
	gtk_object_set_data(GTK_OBJECT(xs_aboutwin), "vbox1", vbox1);
	gtk_widget_show(vbox1);
/*	gtk_container_add(GTK_CONTAINER(xs_aboutwin), vbox1);
*/
	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_object_set_data(GTK_OBJECT(xs_aboutwin), "hbox1", hbox1);
	gtk_widget_show (hbox1);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, TRUE, TRUE, 0);

	frame1 = gtk_frame_new (NULL);
	gtk_object_set_data (GTK_OBJECT (xs_aboutwin), "frame1", frame1);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (hbox1), frame1, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame1), 4);

	/* The pixmap */
	pixmap = gdk_pixmap_create_from_xpm_d(xs_aboutwin->window, &pixmask,
						&style->bg[GTK_STATE_NORMAL],
						(gchar **) xmms_sid_logo_xpm);
	
	pixmapwid = gtk_pixmap_new(pixmap, pixmask);
	gtk_widget_show (pixmapwid);
	gtk_container_add (GTK_CONTAINER (frame1), pixmapwid);
	gtk_misc_set_padding (GTK_MISC (pixmapwid), 4, 4);

	label1 = gtk_label_new (
	"XMMS-SID SIDPlay plugin v" VERSION "\n"
	"for X MultiMedia System\n"
	"by Willem Monsuwe and\n"
	"Matti \"ccr\" H\344m\344l\344inen\n\n"
	"libSIDPlay by Michael Schwendt");
	
	gtk_object_set_data (GTK_OBJECT (xs_aboutwin), "label1", label1);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (label1), 8, 0);

	hbuttonbox1 = gtk_hbutton_box_new ();
	gtk_object_set_data (GTK_OBJECT (xs_aboutwin), "hbuttonbox1", hbuttonbox1);
	gtk_widget_show (hbuttonbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, TRUE, TRUE, 0);

	/* OK-button */
	about_ok = gtk_button_new_with_label("OK");

	gtk_signal_connect (GTK_OBJECT (about_ok), "clicked",
				GTK_SIGNAL_FUNC(xs_aboutwin_ok),
				NULL);

	gtk_object_set_data (GTK_OBJECT (xs_aboutwin), "about_ok", about_ok);
	gtk_widget_show (about_ok);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), about_ok);
	GTK_WIDGET_SET_FLAGS (about_ok, GTK_CAN_DEFAULT);

	gtk_widget_show(xs_aboutwin);
}

