#include <unistd.h>
#include <fcntl.h>

#include <gtk/gtk.h>
#include <glib.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "id666.h"
#include "spc-util.h"

static GtkWidget *fileinfo_win = NULL;

static void fileinfo_destroy(GtkWidget *w, gpointer data) {
	id666_t *info = data;

	spc_clear_id666(info);
	fileinfo_win = NULL;
}

static void fileinfo_close(GtkWidget *w, gpointer data) {
	gtk_widget_destroy(fileinfo_win);
}

void spc_fileinfo(char *filename) {
	int fd;
	static id666_t info;

	GtkWidget *wbox, *frame, *vbox, *hbox, *widget;
	GList *list;

	if (fileinfo_win)
		return;

	fileinfo_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(fileinfo_win), "destroy", GTK_SIGNAL_FUNC(fileinfo_destroy), &info);
	gtk_window_set_title(GTK_WINDOW(fileinfo_win), "id666 tag editor");
	gtk_container_set_border_width(GTK_CONTAINER(fileinfo_win), 5);

	memset(&info, 0, sizeof(info));
	fd = open(filename, O_RDONLY);
	if (fd >= 0) {
		spc_read_id666(fd, &info);
		close(fd);
	}

	wbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(fileinfo_win), wbox);

	widget = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(widget), filename);
	gtk_editable_set_editable(GTK_EDITABLE(widget), FALSE);
	gtk_box_pack_start(GTK_BOX(wbox), widget, FALSE, FALSE, 10);

	/* General stuff -- game, artist, track, disc, etc */
	frame = gtk_frame_new("General");
	gtk_box_pack_start(GTK_BOX(wbox), frame, FALSE, FALSE, 0);
	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	/* game */
	widget = util_widget_label("Game title", util_widget_entry_string(&info.game_title));
	gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, 0);
	/* song */
	widget = util_widget_label("Song title", util_widget_entry_string(&info.song_title));
	gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, 0);
	/* artist */
	widget = util_widget_label("Artist", util_widget_entry_string(&info.artist));
	gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, 0);

	/* OST stuff */
	frame = gtk_frame_new("Official Sound Track");
	gtk_box_pack_start(GTK_BOX(wbox), frame, FALSE, FALSE, 0);
	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	/* publisher */
	widget = util_widget_label("Publisher", util_widget_entry_string(&info.publisher));
	gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, 0);
	/* song */
	widget = util_widget_label("Song title", util_widget_entry_string(&info.ost_title));
	gtk_box_pack_start(GTK_BOX(vbox), widget, FALSE, FALSE, 0);
	/**/
	hbox = gtk_hbox_new(FALSE, 20);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
	/* disc number */
	widget = util_widget_label("Disc #", util_widget_entry_number(&info.ost_disc, 0, 99, 40));
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	/* track number */
	widget = util_widget_label("Track #", util_widget_entry_number(&info.ost_track, 0, 99, 40));
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	/* copyright year */
	widget = util_widget_label("Copyright", util_widget_entry_number(&info.year, 0, 65535, 60));
	gtk_box_pack_end(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	/* Looping stuff */
	frame = gtk_frame_new("Looping");
	gtk_box_pack_start(GTK_BOX(wbox), frame, FALSE, FALSE, 0);
	vbox = gtk_hbox_new(FALSE, 20);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	/* intro/end */
	hbox = gtk_vbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
	widget = util_widget_label("Intro", util_widget_entry_time(&info.intro_length));
	gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	widget = util_widget_label("Fade", util_widget_entry_time(&info.fade_length));
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	/* loop/fade */
	hbox = gtk_vbox_new(FALSE, 5);
	gtk_box_pack_end(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
	widget = util_widget_label("End", util_widget_entry_time(&info.end_length));
	gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	widget = util_widget_label("Loop", util_widget_entry_time(&info.loop_length));
	gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);

	/* Dump information */
	frame = gtk_frame_new("Dump info");
	gtk_box_pack_start(GTK_BOX(wbox), frame, FALSE, FALSE, 0);
	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	/* dumper */
	widget = util_widget_label("Dumper", util_widget_entry_string(&info.dumper));
	gtk_box_pack_start(GTK_BOX(vbox), widget, TRUE, TRUE, 0);
	/**/
	hbox = gtk_hbox_new(FALSE, 20);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
	/* dump date */
	widget = util_widget_label("Date", util_widget_entry_number(&info.dumpdate, 0, INT_MAX, 80));
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	/* emulator */
	list = NULL;
	list = g_list_append(list, "unknown");
	list = g_list_append(list, "zsnes");
	list = g_list_append(list, "snes9x");
	widget = gtk_combo_new();
	gtk_combo_set_popdown_strings(GTK_COMBO(widget), list);
	gtk_combo_set_value_in_list(GTK_COMBO(widget), FALSE, FALSE);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(widget)->entry), info.emulator?info.emulator:"unknown");
	gtk_widget_set_usize(widget, 120, -1);
	widget = util_widget_label("Emulator", widget);
	gtk_box_pack_end(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	/* comments */
	widget = util_widget_label("Comment", util_widget_entry_string(&info.comments));
	gtk_box_pack_start(GTK_BOX(vbox), widget, TRUE, TRUE, 0);

	/* Buttons */
	hbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
	gtk_box_pack_end(GTK_BOX(wbox), hbox, FALSE, FALSE, 0);
	/**/
	widget = gtk_button_new_with_label("Close");
	gtk_signal_connect(GTK_OBJECT(widget), "clicked", GTK_SIGNAL_FUNC(fileinfo_close), NULL);
	GTK_WIDGET_SET_FLAGS(widget, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	/**/

	gtk_widget_show_all(fileinfo_win);
}
