/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sort.DocumentSorter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class PromotionOffer {
    public static final int FOCUS_INDEPENDENT = 10;
    public static final int RANGE_INDEPENDENT = 11;
    public static final int INLINE_VARIABLE_REFERENCES = 12;
    public static final int UNORDERED = 13;
    public static final int REPLACE_CURRENT = 14;
    public static final int EXTRACT_GLOBAL_VARIABLES = 15;
    private Optimizer optimizer;
    public ExpressionVisitor visitor;
    public int action;
    public boolean promoteDocumentDependent = false;
    public boolean promoteXSLTFunctions = true;
    public boolean mustEliminateDuplicates = true;
    public Binding[] bindingList;
    public Expression containingExpression;
    public boolean accepted = false;

    public PromotionOffer(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Expression accept(Expression child) throws XPathException {
        switch (this.action) {
            case 11: {
                int properties = child.getSpecialProperties();
                if ((properties & 0x400000) == 0 || ExpressionTool.dependsOnVariable(child, this.bindingList) || (child.getDependencies() & 0x1000200) != 0) break;
                return this.promote(child);
            }
            case 10: {
                int dependencies = child.getDependencies();
                int properties = child.getSpecialProperties();
                if (!this.promoteXSLTFunctions && (dependencies & 0x261) != 0 || ExpressionTool.dependsOnVariable(child, this.bindingList) || (dependencies & 0x1000200) != 0) break;
                if ((dependencies & 0x1E) == 0 && (properties & 0x400000) != 0) {
                    return this.promote(child);
                }
                if (!this.promoteDocumentDependent || (dependencies & 0xE) != 0 || (properties & 0x400000) == 0) break;
                return this.promote(child);
            }
            case 14: {
                if (child instanceof Current) {
                    LocalVariableReference var = new LocalVariableReference((Assignation)this.containingExpression);
                    ExpressionTool.copyLocationInfo(child, var);
                    return var;
                }
                if (ExpressionTool.callsFunction(child, Current.FN_CURRENT)) break;
                return child;
            }
            case 12: {
                if (!(child instanceof VariableReference) || ((VariableReference)child).getBinding() != this.bindingList[0]) break;
                try {
                    return this.containingExpression.copy();
                }
                catch (UnsupportedOperationException err) {
                    return this.containingExpression;
                }
            }
            case 13: {
                if (child instanceof Reverse) {
                    return ((Reverse)child).getArguments()[0];
                }
                if (!(child instanceof DocumentSorter) || this.mustEliminateDuplicates) break;
                return ((DocumentSorter)child).getBaseExpression();
            }
            case 15: {
                if (child instanceof Literal || child instanceof LocalParam || child.getDependencies() != 0 || (child.getSpecialProperties() & 0x400000) == 0) break;
                return this.optimizer.extractGlobalVariables(child, this.visitor);
            }
            default: {
                throw new UnsupportedOperationException("Unknown promotion action " + this.action);
            }
        }
        return null;
    }

    private Expression promote(Expression child) {
        TypeHierarchy th = this.optimizer.getConfiguration().getTypeHierarchy();
        boolean indexed = false;
        Expression parent = this.containingExpression.findParentOf(child);
        if (parent instanceof GeneralComparison && ((GeneralComparison)parent).getOperator() == 6) {
            indexed = true;
        }
        LetExpression let = new LetExpression();
        let.setVariableQName(new StructuredQName("zz", "http://saxon.sf.net/", "zz" + let.hashCode()));
        SequenceType type = SequenceType.makeSequenceType(child.getItemType(th), child.getCardinality());
        let.setRequiredType(type);
        ExpressionTool.copyLocationInfo(this.containingExpression, let);
        let.setSequence(LazyExpression.makeLazyExpression(child));
        let.setAction(this.containingExpression);
        let.adoptChildExpression(this.containingExpression);
        if (indexed) {
            let.setIndexedVariable();
        }
        this.containingExpression = let;
        this.accepted = true;
        LocalVariableReference var = new LocalVariableReference(let);
        var.setStaticType(type, null, 0);
        ExpressionTool.copyLocationInfo(this.containingExpression, var);
        return var;
    }
}

