package xm::pfe::tekrefs;
use strict;
use xm::o;

sub DESC
{"
  scan in comments for known symbols and mark them as URLs
  - just a specialty.
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }

sub do_cdoc
{
    my $in = shift;
    
    $in =~ s{(\bTektronix\b)} 
            {<a href=http://www.tek.com>$1</a>}g;
    $in =~ s{(\bLGPL\b)} 
            {<a href=http://www.opensource.com/licenses/lgpl-license.html>$1</a>}g;
    $in =~ s{(\bderived_by:\s*)(guidod\b)} 
            {$1<a href=mailto:guidod\@exgate.tek.com>$2</a>}g;

    return $in;
}

sub DO
{
    my $in = shift;
    
    $in =~ s{(<CDOC>)(.*(?!</CDOC>).)(</CDOC>)} { $1.do_cdoc($2).$3 }gsex;
    
    return $in;
} 

1;

