package xm::pfe::fcodesortnspill;
use strict;
use xm::o;

sub DESC
{"
  look only for ITEMFCODEs in a text, an see if there is 
  a XDEF in a FORTHHEADER. This one is sorted into a list,
  everything else is spilled. Spit out the sorted and cleaned
  ITEMFCODE list. (see xm::pfe::cutfcodedocs )
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }


sub getxdef 
{
    my $in = shift;
    if ($in =~ m{ <FORTHHEADER>
		      ((?:.(?!</?FORTHHEADER\b))*.) 
			  <XDEF>
			      ((?:.(?!</?XDEF\b))*.) 
				  </XDEF> 
				  }sx) 
    { return $2; }
    return "";
}	


sub DO
{
    my $in = shift;
    my $out = "";
    my $xdef;
    my $item; # hashref;

    $in =~ s{ (<ITEMFCODE\b[^<>]*>) 
		  ((?:.(?!</?ITEMFCODE\b))*.) (</ITEMFCODE\b[^<>]*>)
		  }
    { 
	$out = $1.$2.$3;
	$xdef = getxdef ($2);
	if (length $xdef)
	{
	    $$item{$xdef} = $out;
	}
    }gsex;
    
    for $xdef (sort keys %{$item})
    {
	$out .= $$item{$xdef}."\n";
    }

    return $out;
}

1;

