package xm::grabitemincl;
use strict;
use xm::o;

sub DESC
{"
  will look for all texts that follow a (global) ITEM[A-Z]* section
  which has an include-line and then mark these text areas as ITEMINCL.
"}

sub ARGS { return xm::o::args_stdin(@_, DESC); }

sub DO
{
    my $in = shift;

    my $x = sub { 
	my ($a,$b) = @_;
	if ($b !~ m/<CPRE>\s*\#\s*include\b/s)  
	{  
	    return $a.$b;
	}else{  
	    return $a."<ITEMINCL>".$b."</ITEMINCL>";
	}
    };

    # use-CDEFS style    
    $in =~ s{(</ITEM[A-Z]*\b[^<>]*>(?!</?ITEM))
		 ( (?:.(?!</?ITEM))*.? )(?=<ITEM|$)
		     } 
         { 
	     &$x($1,$2)
	 }gsex;
    $in =~ s{(^(?!</?ITEM))
		 ( (?:.(?!</?ITEM))*.? )
		     } 
         { 
	     &$x($1,$2)
	 }gsex;
	
    return $in;
} 

1;



