/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_toolbar.c - clickable toolbar
 */

#include <gtk/gtk.h>

#include "callbacks_toolbar.h"
#include "interface.h"
#include "support.h"
#include "preferences.h"
#include "types.h"
#include "log.h"
#include "utils.h"
#include "hamlib-utils.h"

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern statetype state;
extern gchar **bandsplit;
extern gchar **modesplit;
extern gchar **qso;
extern GList *logwindowlist;

/* add a new qso to the log */
void on_abutton_clicked (GtkButton *button, gpointer user_data) {
	GtkWidget *dateentry, *gmtentry, *callentry, *rstentry, *myrstentry,
		*remarksentry, *bandentry, *modeentry, *bandoptionmenu, 
		*modeoptionmenu, *incheckbutton, *outcheckbutton, *gmtbutton;
	GtkWidget *qsoframe;
	GtkWidget *menu, *active_item;
	gchar *frametext, *temp;
	gint newrow, bandindex, modeindex;
	logtype *logwindow = NULL;

	logwindow =  g_list_nth_data(logwindowlist, 
		gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));

	dateentry = lookup_widget(mainwindow, "dateentry");
	gmtentry = lookup_widget(mainwindow, "gmtentry");
	callentry = lookup_widget(mainwindow, "callentry");
	bandentry = lookup_widget(mainwindow, "bandentry");
	bandoptionmenu = lookup_widget(mainwindow, "bandoptionmenu");
	modeentry = lookup_widget(mainwindow, "modeentry");
	modeoptionmenu = lookup_widget(mainwindow, "modeoptionmenu");
	rstentry = lookup_widget(mainwindow, "rstentry");
	myrstentry = lookup_widget(mainwindow, "myrstentry");
	remarksentry = lookup_widget(mainwindow, "remarksentry");
	incheckbutton = lookup_widget(mainwindow, "incheckbutton");
	outcheckbutton = lookup_widget(mainwindow, "outcheckbutton");
	qso[NR] = g_strdup_printf("%d", ++logwindow->qsos);
	qso[DATE] = gtk_editable_get_chars(GTK_EDITABLE(dateentry), 0, -1);
	qso[GMT] = gtk_editable_get_chars(GTK_EDITABLE(gmtentry), 0, -1);
	qso[CALL] = gtk_editable_get_chars(GTK_EDITABLE(callentry), 0, -1);

	if (preferences.bandseditbox == 0) {
		menu = GTK_OPTION_MENU(bandoptionmenu)->menu;
		active_item = gtk_menu_get_active(GTK_MENU(menu));
		bandindex = g_list_index(GTK_MENU_SHELL(menu)->children, active_item);
		qso[BAND] = lookup_band(bandsplit[bandindex]);
	}
	else qso[BAND] = gtk_editable_get_chars(GTK_EDITABLE(bandentry), 0, -1);
	if (preferences.modeseditbox == 0) {
			menu = GTK_OPTION_MENU(modeoptionmenu)->menu;
			active_item = gtk_menu_get_active(GTK_MENU(menu));
			modeindex = g_list_index(GTK_MENU_SHELL(menu)->children, active_item);
			qso[MODE] = lookup_mode(modesplit[modeindex]);
	}
	else qso[MODE] = gtk_editable_get_chars(GTK_EDITABLE(modeentry), 0, -1);

	qso[RST] = gtk_editable_get_chars(GTK_EDITABLE(rstentry), 0, -1);
	qso[MYRST] = gtk_editable_get_chars(GTK_EDITABLE(myrstentry), 0, -1);
	qso[REMARKS] = gtk_editable_get_chars(GTK_EDITABLE(remarksentry), 0, -1);
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(outcheckbutton)))
		qso[QSLOUT] = g_strdup("X");
	else
		qso[QSLOUT] = g_strdup("");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(incheckbutton)))
		qso[QSLIN] = g_strdup("X");
	else
		qso[QSLIN] = g_strdup("");


	newrow = gtk_clist_prepend(GTK_CLIST(logwindow->clist), qso);
	gtk_editable_delete_text(GTK_EDITABLE(gmtentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(callentry), 0, -1);
	if (preferences.modeseditbox == 1)
		gtk_editable_delete_text(GTK_EDITABLE(modeentry), 0, -1);
	if (preferences.bandseditbox == 1)
		gtk_editable_delete_text(GTK_EDITABLE(bandentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(rstentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(myrstentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(remarksentry), 0, -1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outcheckbutton), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(incheckbutton), FALSE);

	if (preferences.logcolor == 1) setcallstyle(logwindow->clist, newrow, preferences.themecolor);

	/* update status bar */
	temp = g_strdup_printf(_("QSO %s added to %s log"), qso[NR], logwindow->logname);
	update_statusbar(temp);
	g_free(temp);

	logwindow->logchanged = TRUE;
	gtk_label_set_text(GTK_LABEL(logwindow->label),
		g_strconcat(logwindow->logname, " *", NULL));

	qsoframe = lookup_widget(mainwindow, "qsoframe");
	frametext = g_strdup_printf(_("New QSO"));
	gtk_frame_set_label(GTK_FRAME(qsoframe), frametext);
	g_free(frametext);

	/* set focus to the GMT button */
	gmtbutton = lookup_widget(mainwindow, "gmtbutton");
	gtk_widget_grab_focus(gmtbutton);
}

/* delete a qso from the log */
void on_dbutton_clicked (GtkButton *button, gpointer user_data) {
	GtkWidget *dateentry, *gmtentry, *callentry, *rstentry, *myrstentry,
		*remarksentry, *bandentry, *modeentry, *incheckbutton,
		*outcheckbutton, *qsoframe;
	gchar *frametext, *statustext, *qsonumber;
	gint i, selectedrow;
	logtype *logwindow;

	dateentry = lookup_widget(mainwindow, "dateentry");
	gmtentry = lookup_widget(mainwindow, "gmtentry");
	callentry = lookup_widget(mainwindow, "callentry");
	bandentry = lookup_widget(mainwindow, "bandentry");
	modeentry = lookup_widget(mainwindow, "modeentry");
	rstentry = lookup_widget(mainwindow, "rstentry");
	myrstentry = lookup_widget(mainwindow, "myrstentry");
	remarksentry = lookup_widget(mainwindow, "remarksentry");
	incheckbutton = lookup_widget(mainwindow, "incheckbutton");
	outcheckbutton = lookup_widget(mainwindow, "outcheckbutton");
	logwindow =  g_list_nth_data(logwindowlist, 
		gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));

	while(GTK_CLIST(logwindow->clist)->selection) {
		gtk_clist_freeze(GTK_CLIST(logwindow->clist));

		/* get qso number from the first column */
		selectedrow = (gint)GTK_CLIST(logwindow->clist)->selection->data;
		gtk_clist_get_text(GTK_CLIST(logwindow->clist), selectedrow, NR,  &qsonumber);
		/* update statusbar */
		statustext = g_strdup_printf(_("QSO %s deleted, %s log renumbered"), qsonumber, logwindow->logname);
		update_statusbar(statustext);
		g_free(statustext);

		/* clear QSO frame */
		gtk_editable_delete_text(GTK_EDITABLE(gmtentry), 0, -1);
		gtk_editable_delete_text(GTK_EDITABLE(callentry), 0, -1);
		if (preferences.modeseditbox == 1)
			gtk_editable_delete_text(GTK_EDITABLE(modeentry), 0, -1);
		if (preferences.bandseditbox == 1)
		gtk_editable_delete_text(GTK_EDITABLE(bandentry), 0, -1);
		gtk_editable_delete_text(GTK_EDITABLE(rstentry), 0, -1);
		gtk_editable_delete_text(GTK_EDITABLE(myrstentry), 0, -1);
		gtk_editable_delete_text(GTK_EDITABLE(remarksentry), 0, -1);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outcheckbutton), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(incheckbutton), FALSE);

		/* now remove the QSO from the log */
		gtk_clist_remove(GTK_CLIST(logwindow->clist), selectedrow);
		logwindow->qsos--;

		/* update the first column with the number of qso's */
		for (i = 0; i < logwindow->qsos; i++) {
			qsonumber = g_strdup_printf("%d", logwindow->qsos - i);
			gtk_clist_set_text(GTK_CLIST(logwindow->clist), i, 0, qsonumber);
			g_free(qsonumber);
		}

		gtk_clist_thaw(GTK_CLIST(logwindow->clist));
		qsoframe = lookup_widget(mainwindow, "qsoframe");
		frametext = g_strdup_printf(_("New QSO"));
		gtk_frame_set_label(GTK_FRAME(qsoframe), frametext);
		g_free(frametext);
		logwindow->logchanged = TRUE;
		gtk_label_set_text(GTK_LABEL(logwindow->label),
			g_strconcat(logwindow->logname, " *", NULL));
	}
}

/* update/modify a log entry */
void on_ubutton_clicked(GtkButton *button, gpointer user_data) {
	GtkWidget *dateentry, *gmtentry, *callentry, *rstentry, *myrstentry,
		*remarksentry, *bandentry, *modeentry, *incheckbutton,
		*outcheckbutton, *modeoptionmenu, *bandoptionmenu,
		*menu, *active_item, *qsoframe;
	gint bandindex, modeindex, updatedrow;
	gchar *frametext, *nr, *statustext;
	logtype *logwindow;

	dateentry = lookup_widget(mainwindow, "dateentry");
	gmtentry = lookup_widget(mainwindow, "gmtentry");
	callentry = lookup_widget(mainwindow, "callentry");
	bandentry = lookup_widget(mainwindow, "bandentry");
	modeentry = lookup_widget(mainwindow, "modeentry");
	rstentry = lookup_widget(mainwindow, "rstentry");
	myrstentry = lookup_widget(mainwindow, "myrstentry");
	remarksentry = lookup_widget(mainwindow, "remarksentry");
	modeoptionmenu = lookup_widget(mainwindow, "modeoptionmenu");
	bandoptionmenu = lookup_widget(mainwindow, "bandoptionmenu");
	incheckbutton = lookup_widget(mainwindow, "incheckbutton");
	outcheckbutton = lookup_widget(mainwindow, "outcheckbutton");
	logwindow =  g_list_nth_data(logwindowlist, 
		gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));

	while(GTK_CLIST(logwindow->clist)->selection) {
		gtk_clist_freeze(GTK_CLIST(logwindow->clist));
		updatedrow = (gint)GTK_CLIST(logwindow->clist)->selection->data;

		/* save the qso number */
		gtk_clist_get_text(GTK_CLIST(logwindow->clist), updatedrow, 0, &nr);
		qso[NR] = g_strdup(nr);

		/* get all the other fields from the QSO frame */
		qso[DATE] = gtk_editable_get_chars(GTK_EDITABLE(dateentry), 0, -1);
		qso[GMT] = gtk_editable_get_chars(GTK_EDITABLE(gmtentry), 0, -1);
		qso[CALL] = gtk_editable_get_chars(GTK_EDITABLE(callentry), 0, -1);

		if (preferences.bandseditbox == 1) {
			qso[BAND] = gtk_editable_get_chars(GTK_EDITABLE(bandentry), 0, -1);
		}
		else {
			menu = GTK_OPTION_MENU(bandoptionmenu)->menu;
			active_item = gtk_menu_get_active(GTK_MENU(menu));
			bandindex = g_list_index(GTK_MENU_SHELL(menu)->children, active_item);
			qso[BAND] = lookup_band(bandsplit[bandindex]);
		}

		if (preferences.modeseditbox == 1) {
			qso[MODE] = gtk_editable_get_chars(GTK_EDITABLE(modeentry), 0, -1);
		}
		else {
			menu = GTK_OPTION_MENU(modeoptionmenu)->menu;
			active_item = gtk_menu_get_active(GTK_MENU(menu));
			modeindex = g_list_index(GTK_MENU_SHELL(menu)->children, active_item);
			qso[MODE] = lookup_mode(modesplit[modeindex]);
		}

		qso[RST] = gtk_editable_get_chars(GTK_EDITABLE(rstentry), 0, -1);
		qso[MYRST] = gtk_editable_get_chars(GTK_EDITABLE(myrstentry), 0, -1);
		qso[REMARKS] = gtk_editable_get_chars(GTK_EDITABLE(remarksentry), 0, -1);

		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(outcheckbutton)))
			qso[QSLOUT] = g_strdup("X");
		else
			qso[QSLOUT] = g_strdup("");
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(incheckbutton)))
			qso[QSLIN] = g_strdup("X");
		else
			qso[QSLIN] = g_strdup("");

		/* remove logentry and enter a new one */
		gtk_clist_remove(GTK_CLIST(logwindow->clist), updatedrow);
		gtk_clist_insert(GTK_CLIST(logwindow->clist), updatedrow, qso);

		/* update status bar */
		statustext = g_strdup_printf(_("QSO %s updated in %s log"), qso[NR], logwindow->logname);
		update_statusbar(statustext);
		g_free(statustext);

		gtk_editable_delete_text(GTK_EDITABLE(gmtentry), 0, -1);
		gtk_editable_delete_text(GTK_EDITABLE(callentry), 0, -1);
		if (preferences.modeseditbox == 1)
			gtk_editable_delete_text(GTK_EDITABLE(modeentry), 0, -1);
		if (preferences.bandseditbox == 1)
			gtk_editable_delete_text(GTK_EDITABLE(bandentry), 0, -1);
		gtk_editable_delete_text(GTK_EDITABLE(rstentry), 0, -1);
		gtk_editable_delete_text(GTK_EDITABLE(myrstentry), 0, -1);
		gtk_editable_delete_text(GTK_EDITABLE(remarksentry), 0, -1);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outcheckbutton), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(incheckbutton), FALSE);

		/* set style of the updated row */
		if (preferences.logcolor == 1)
			setcallstyle(logwindow->clist, updatedrow, preferences.themecolor);
		gtk_clist_thaw(GTK_CLIST(logwindow->clist));

		qsoframe = lookup_widget(mainwindow, "qsoframe");
		frametext = g_strdup_printf(_("New QSO"));
		gtk_frame_set_label(GTK_FRAME(qsoframe), frametext);
		g_free(frametext);

		gtk_label_set_text(GTK_LABEL(logwindow->label),
			g_strconcat(logwindow->logname, " *", NULL));
		logwindow->logchanged = TRUE;
	}
}
