#ifndef MESSAGEBOX_H
#define MESSAGEBOX_H


// Message box
class FXAPI MessageBox : public FXDialogBox
{
    FXDECLARE(MessageBox)
protected:
    MessageBox()
    {}
private:
    MessageBox(const MessageBox&);
    MessageBox &operator=(const MessageBox&);
    void initialize(const FXString& text,FXIcon* ic,FXuint whichbuttons);
public:
    long onCmdClicked(FXObject*,FXSelector,void*);
    long onCmdCancel(FXObject*,FXSelector,void*);
public:
    enum{
        ID_CLICKED_YES=FXDialogBox::ID_LAST,
        ID_CLICKED_NO,
        ID_CLICKED_OK,
        ID_CLICKED_CANCEL,
        ID_CLICKED_QUIT,
        ID_CLICKED_SAVE,
        ID_LAST
    };
public:

    // Construct message box with given caption, icon, and message text
    MessageBox(FXWindow* owner,const FXString& caption,const FXString& text,FXIcon* ic=NULL,FXuint opts=0,FXint x=0,FXint y=0);

    // Construct free floating message box with given caption, icon, and message text
    MessageBox(FXApp* a,const FXString& caption,const FXString& text,FXIcon* ic=NULL,FXuint opts=0,FXint x=0,FXint y=0);

    /**
    * Show a modal error message.
    * The text message may contain printf-tyle formatting commands.
    */
    static FXuint error(FXWindow* owner,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;

    /**
    * Show a modal warning message
    * The text message may contain printf-tyle formatting commands.
    */
    static FXuint warning(FXWindow* owner,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;

    /**
    * Show a modal question dialog
    * The text message may contain printf-tyle formatting commands.
    */
    static FXuint question(FXWindow* owner,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;

    /**
    * Show a modal information dialog
    * The text message may contain printf-tyle formatting commands.
    */
    static FXuint information(FXWindow* owner,FXuint opts,const char* caption,const char* message,...) FX_PRINTF(4,5) ;

};

#endif
