/*  $Id$
 *
 *  Copyright (c) 2006 Mike Massonnet <mmassonnet@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef NOTES_H
#define NOTES_H

#include <gdk/gdkkeysyms.h>

#include "notes-window.h"

typedef struct
{
    gboolean show;
    gboolean task_switcher;
    gboolean always_on_top;
    gboolean stick;
}
NotesOptions;

typedef struct
{
    XfcePanelPlugin *plugin;

    GtkWidget *button;
    GtkWidget *icon;
    GtkTooltips *tooltips;

    Note *note;
    NotesOptions options;

    guint timeout_id;
}
NotesPlugin;

NotesPlugin *   notes_new (XfcePanelPlugin *);
Note *          note_new (NotesPlugin *);
void            note_page_new (XfcePanelPlugin *, NotesPlugin *);
void            save_on_timeout (NotesPlugin *);

#endif
