/* $Id: fm_plugin.c 21631 2006-05-11 21:24:25Z benny $ */
/*-
 * Copyright (c) 2006 Benedikt Meurer <benny@xfce.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; You may only use version 2 of the License,
 * you have no option to use any other version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <libxfce4mcs/mcs-manager.h>
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <xfce-mcs-manager/manager-plugin.h>



static void
run_dialog (McsPlugin *plugin)
{
  GtkWidget *message;
  gchar    **argv;
  gchar     *display_name;
  gint       status;

  /* determine the display name for the default screen */
  display_name = gdk_screen_make_display_name (gdk_screen_get_default ());

  /* generate the command */
  argv = g_new (gchar *, 8);
  argv[0] = g_strdup ("dbus-send");
  argv[1] = g_strdup ("--print-reply"); /* required for dbus-send to fail properly */
  argv[2] = g_strdup ("--session");
  argv[3] = g_strdup ("--dest=org.xfce.FileManager");
  argv[4] = g_strdup ("/org/xfce/FileManager");
  argv[5] = g_strdup ("org.xfce.FileManager.DisplayPreferencesDialog");
  argv[6] = g_strdup_printf ("string:%s", display_name);
  argv[7] = NULL;

  /* try to send the command to the file manager */
  if (!g_spawn_sync (NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, &status, NULL) || status != 0)
    {
      /* tell the user that we failed */
      message = gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
                                        _("Failed to open the File Manager Preferences."));
      gtk_message_dialog_format_secondary_text (GTK_MESSAGE_DIALOG (message),
                                                _("Either the Xfce File Manager was not build with support for "
                                                  "D-BUS, or the D-BUS service was not installed properly."));
      gtk_dialog_run (GTK_DIALOG (message));
      gtk_widget_destroy (message);
    }

  /* cleanup */
  g_free (display_name);
  g_strfreev (argv);
}



McsPluginInitResult
mcs_plugin_init (McsPlugin *plugin)
{
  gchar *path;

  xfce_textdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");

  /* the button label in the xfce-mcs-manager dialog */
  plugin->caption = g_strdup (Q_ ("Button Label|File Manager"));
  plugin->run_dialog = run_dialog;
  plugin->plugin_name = g_strdup ("file-manager");
  plugin->icon = xfce_themed_icon_load ("xfce-filemanager", 48);
  if (G_LIKELY (plugin->icon != NULL))
    g_object_set_data_full (G_OBJECT (plugin->icon), "mcs-plugin-icon-name", g_strdup ("xfce-filemanager"), g_free);

  /* check if dbus-send is available */
  path = g_find_program_in_path ("dbus-send");
  if (G_LIKELY (path != NULL))
    {
      /* yep, available */
      g_free (path);
      return MCS_PLUGIN_INIT_OK;
    }
  else
    {
      /* not available, no need to display the button */
      return MCS_PLUGIN_INIT_ERROR;
    }
}



MCS_PLUGIN_CHECK_INIT
