/*	File macurses.h:
 *		Special definitions/extensions for macintosh implementation of curses.
 *		Of particular interest: If the macro MACCUR_REPLACE_STDIO is defined b4
 *		this file is included, the standard IO calls printf, puts, putchar,
 *		scanf, gets, and getchar are replaced by "maccur" versions that
 *		read/write from the curses display.
 *
 * 	Copyright (c) 1994
 *	by Robert Zimmerman
 *
 *  This code may be included in any work, public or private, with the
 *  exception of creating a commercial curses-compatible subroutine
 *  library.  (In other words, use the code all you want, but please don't
 *  rip off the author by reselling this code as your own).
 *
 */

#ifndef _MACURSES_H_LOADED

#define _MACURSES_H_LOADED

enum {										/* Possible actions on command-. */
	MACCUR_EXIT_ON_BREAK,					/* Exit immediately. */
	MACCUR_SIGNAL_BREAK,					/* Raise the SIGINT signal. */
	MACCUR_IGNORE_BREAK						/* Ignore it. */
};

extern int _maccur_cols;					/* Window will be initialized to this size. */
extern int _maccur_lines;
extern char *_maccur_font_name;				/* Font to use (C string). */
extern int _maccur_font_size;				/* Size of font. */
extern int _maccur_handle_break_option;		/* This determines what happens on CMD-. (see above). */
extern int _maccur_about_res_id;			/* Resource id alert to display if About... is chosen from apple menu. */
extern char *_maccur_pgm_name;				/* Program name for about and window title. */
extern int _maccur_fg_sleep_ticks;			/* How much can WaitNextEvent sleep in foreground. */
extern int _maccur_bg_sleep_ticks;			/* How much can WaitNextEvent sleep in background. */
extern int _maccur_io_sleep_dvsr;			/* How many of the output calls (maccur_printf, etc) call maccur_cpu_share. */

#ifdef MACCUR_REPLACE_STDIO

#	define printf maccur_printf
#	define puts maccur_puts
#	undef putchar
#	define putchar maccur_putchar
#	define scanf maccur_scanf
#	define gets maccur_gets
#	undef getchar
#	define getchar maccur_getchar

#endif /* MACCUR_REPLACE_STDIO */

void maccur_alert_msg(
char *fmt,
...
);

void maccur_cpu_share(void);

int maccur_printf(
char *fmt,
...
);

int maccur_puts(
char *str
);

int maccur_putchar(
char c
);

int maccur_scanf(
char *fmt,
...
);

char *maccur_gets(
char *str
);

int maccur_getchar(void);

#endif /* _MACURSES_H_LOADED */
