#ifndef _BUDDIES_H_
#define _BUDDIES_H_

#include "includes.h"
#include "common.h"
#include "hashtable.h"
#include "write.h"
#include "event.h"

// the number of buckets in the buddy hashtable
#define BUDDY_HT_SIZE 47

// these are for the 'verified' fields of bud_utrec_t's
typedef enum { B_LOGGED_OUT, B_LOGGED_IN, B_UNCHANGED } bud_status_e; 

typedef struct buddy {
	char *name;
	htable_t *logins;
	const wuzzah_config_t *conf;
} buddy_t;

typedef struct bud_utrec {
	STRUCT_UTMPX *u;
	bud_status_e verified;
} bud_utrec_t;

htable_t *bud_init_budtable(void);
int bud_load(const char *fn, htable_t *ht);
void bud_load_every_user(htable_t *ht);
buddy_t* bud_create_buddy(const char *line);
void bud_chk_utmpx(htable_t *buddies, short write_users);
void bud_status_report(bud_utrec_t *rec, short write_user);
char* bud_expand_fmt(const bud_utrec_t *rec, const char *fmt_string);
char* bud_expand_write(const bud_utrec_t *rec, const char *fmt_string);
int argvify(int *argc, char **argv[], const char *cmdline);

#endif
