/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "LevelGraph.h"

BEGIN_EVENT_TABLE(CLevelGraph, wxWindow)
	EVT_PAINT(CLevelGraph::onPaint)
END_EVENT_TABLE()

const int BAR_COUNT = 25;
const int RED_COUNT = 20;

CLevelGraph::CLevelGraph(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style, const wxString& name) :
wxWindow(parent, id, pos, size, style, name),
m_bitmap(NULL),
m_height(0),
m_width(0)
{
	m_height = size.GetHeight();
	m_width  = size.GetWidth();

	if (m_height == -1)
		m_height = 125;
	
	if (m_width == -1)
		m_width = 25;

	m_bitmap = new wxBitmap(m_width, m_height);

	clearGraph();
}

CLevelGraph::~CLevelGraph()
{
	delete m_bitmap;
}

void CLevelGraph::addData(double level)
{
	clearGraph();

	wxMemoryDC memoryDC;
	memoryDC.SelectObject(*m_bitmap);
	memoryDC.BeginDrawing();

	if (level < 0.0) level = -level;

	int n = int(level * double(BAR_COUNT) + 0.5);

	if (n > BAR_COUNT) n = BAR_COUNT;

	for (int j = 0; j < n; j++) {
		int y = m_height - j * (m_height / BAR_COUNT) - 7;

		if (j >= RED_COUNT) {
			memoryDC.SetPen(*wxRED_PEN);
			memoryDC.SetBrush(*wxRED_BRUSH);
		} else {
			memoryDC.SetPen(*wxGREEN_PEN);
			memoryDC.SetBrush(*wxGREEN_BRUSH);
		}

		memoryDC.DrawRectangle(2, y, m_width - 4, m_height / BAR_COUNT - 1);
	}

	memoryDC.EndDrawing();
	memoryDC.SelectObject(wxNullBitmap);

	wxClientDC clientDC(this);
	show(clientDC);
}

void CLevelGraph::onPaint(wxPaintEvent& event)
{
	wxPaintDC dc(this);

	show(dc);
}

void CLevelGraph::show(wxDC& dc)
{
	dc.BeginDrawing();
	dc.DrawBitmap(*m_bitmap, 0, 0, false);
	dc.EndDrawing();
}

void CLevelGraph::clearGraph()
{
	// Flood the graph area with black to start with
	wxMemoryDC dc;
	dc.SelectObject(*m_bitmap);
	dc.BeginDrawing();

	dc.SetBackground(*wxBLACK_BRUSH);
	dc.Clear();

	for (int j = 0; j < BAR_COUNT; j++) {
		int y = m_height - j * (m_height / BAR_COUNT) - 7;

		dc.SetPen(*wxGREY_PEN);
		dc.SetBrush(*wxGREY_BRUSH);

		dc.DrawRectangle(2, y, m_width - 4, m_height / BAR_COUNT - 1);
	}

	dc.EndDrawing();
}
