/* libwpg
 * Copyright (C) 2006 Ariya Hidayat (ariya@kde.org)
 * Copyright (C) 2006 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02111-1301 USA
 *
 * For further information visit http://libwpg.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#include <iostream>
#include <sstream>
#include <string>

#include <libwpg/libwpg.h>
#include <libwpg/WPGStreamImplementation.h>
#include "OdgExporter.hxx"

#include "femtozip.hxx"
#include "FileOutputHandler.hxx"
#include "StdOutputHandler.hxx"

int main(int argc, char *argv[])
{
	if (argc < 2)
	{
		std::cout << "usage: wpg2odg <WordPerfect Graphics> <OpenDocument output>\n";
		std::cout << "       or\n";
		std::cout << "       wpg2odg <WordPerfect Graphics> (to output to standard output)\n";
		return -1;
	}

	const char* wpgfile = argv[1];

	::WPXInputStream* input = new libwpg::WPGFileStream(wpgfile);
	if (input->isOLEStream())
	{
		::WPXInputStream* olestream = input->getDocumentOLEStream();
		if (olestream)
		{
			delete input;
			input = olestream;
		}
	}

	if (!libwpg::WPGraphics::isSupported(input))
	{
		std::cerr << "ERROR: Unsupported file format !\n";
		return 1;
	}
	
	if (argc <= 2)
	{
		StdOutputHandler tmpHandler;
		OdgExporter exporter(&tmpHandler, true);
		libwpg::WPGraphics::parse(input, &exporter);
		return 0;
	}

	const char* odgfile = argv[2];
	const char* mimetype = "application/vnd.oasis.opendocument.graphics";
	const char* manifest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
		"<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\">"
		" <manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument.graphics\" manifest:full-path=\"/\"/>"
		" <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"content.xml\"/>"
		" <manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"styles.xml\"/>"
		"</manifest:manifest>";
	
	FemtoZip zip(odgfile);
	zip.createEntry("mimetype", 0);
	zip.writeString(mimetype);
	zip.closeEntry();

	zip.createEntry("META-INF/manifest.xml", 0);
	zip.writeString(manifest);
	zip.closeEntry();
	
	zip.createEntry("content.xml", 0);
	std::ostringstream tmpStringStream;
	FileOutputHandler tmpHandler(tmpStringStream);
	OdgExporter exporter(&tmpHandler);
	libwpg::WPGraphics::parse(input, &exporter);
	zip.writeString(tmpStringStream.str().c_str());
	zip.closeEntry();

	zip.createEntry("styles.xml", 0);
	zip.writeString(tmpStringStream.str().c_str());
	zip.closeEntry();
	
	// std::cout << exporter.contentXML;

	return 0;
}
