/* togglelistermodeop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: togglelistermodeop.cc,v 1.7 2001/11/03 17:10:49 ralf Exp $ */

#include "togglelistermodeop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *ToggleListermodeOp::name="ToggleListermodeOp";

ToggleListermodeOp::ToggleListermodeOp(Worker *tworker):FunctionProto(tworker)
{
  mode=0;
  lastmode=-1;
}

ToggleListermodeOp::~ToggleListermodeOp()
{
}

ToggleListermodeOp*
ToggleListermodeOp::duplicate()
{
  ToggleListermodeOp *ta=new ToggleListermodeOp(worker);
  ta->mode=mode;

  return ta;
}

bool
ToggleListermodeOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
ToggleListermodeOp::getName()
{
  return name;
}

int
ToggleListermodeOp::run(ActionMessage *msg)
{
  int actmode;
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister=worker->getOtherLister(startlister);
      lm1=endlister->getActiveMode();
      if(lm1==NULL) actmode=-1;
      else actmode=worker->getID4Mode(lm1);
      if(actmode<0) {
        endlister->switch2Mode(mode);
      } else {
        if(actmode!=mode) endlister->switch2Mode(mode);
        else if((lastmode>=0)&&(lastmode!=mode)) endlister->switch2Mode(lastmode);
        else endlister->switch2Mode(0);
      }
      lastmode=actmode;
    }
  }
  return 0;
}

bool
ToggleListermodeOp::save(Datei *fh)
{
  int size=Datei::getIntSize();
  fh->putInt(size);

  fh->putInt(mode);
  return true;
}

int
ToggleListermodeOp::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int is=Datei::getIntSize();
  if(chunksize>=is) {
    mode=fh->getInt();
    chunksize-=is;
    if((mode<0)||(mode>=(worker->getMaxModeNr()))) mode=0;
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return true;
}

const char *
ToggleListermodeOp::getDescription()
{
  return catalog.getLocaleCom(39);
}

int
ToggleListermodeOp::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *cyb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  int i;
  char *tstr;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(39))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(39));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(112),1));
  y+=ttext->getHeight()+5;
  tw=x+ttext->getWidth()+5;
  if(tw>w) w=tw;

  cyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  Lister *l1=worker->getLister(0);
  if(l1!=NULL) {
    for(i=0;i<worker->getMaxModeNr();i++) {
      cyb->addOption(l1->getNameOfMode(i));
    }
  }
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  cyb->setOption(mode);
  
  y+=cyb->getHeight()+5;
  tw=x+cyb->getWidth()+5;
  if(tw>w) w=tw;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    mode=cyb->getSelectedOption();
  }
  
  win->close();
  delete win;

  return endmode;
}

void ToggleListermodeOp::setMode(int nm)
{
  if((nm>=0)&&(nm<worker->getMaxModeNr())) {
    mode=nm;
  }
}

