/* textview.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: textview.h,v 1.5 2005/10/16 20:13:04 ralf Exp $ */

#ifndef TEXTVIEW_H
#define TEXTVIEW_H

#include "awindow.h"
#include "guielement.h"
#include "callback.h"
#include "slider.h"
#include "textstorage.h"

class TVCallBack : public CallBack
{
public:
  TVCallBack( class TextView *_tv );
  ~TVCallBack();
  TVCallBack( const TVCallBack &other );
  TVCallBack &operator=( const TVCallBack &other );
  
  void run( GUIElement *, int value = 0 );
  void run( GUIElement *, void *p );
private:
  class TextView *tv;
};

class TextView : public AWindow {
public:
  TextView( AGUIX *parent,
	    int x,
	    int y,
	    int width,
	    int height,
	    int bg,
	    std::string title,
	    TextStorage &_ts );
  ~TextView();
  TextView( const TextView &other );
  TextView &operator=( const TextView &other );
  bool handleMessage(XEvent *,Message *msg);
  void gui_callback( GUIElement *, int value );
  void redraw();
  int setFont( char *fontname );
  void setLineWrap( bool nv );
  bool getLineWrap() const;
  void setDisplayFocus( bool nv );
  bool getDisplayFocus() const;
  void maximizeX();
  void maximizeYLines( int max_lines );
protected:
  class AContainer *cont;
  Slider *hbar, *vbar;
  TextStorage &ts;
  class AGUIXFont *font;
  TVCallBack tvcb;

  int last_w, last_h, last_cont_width;
  bool line_wrap;
  bool _display_focus;
  struct timeval _lastwheel;

  void boxRedraw();
  void createContainer();
  void updateBars();
  void getLinesWidth( int &lines, int &width ) const;
  void doCreateStuff();
  void doDestroyStuff();

  void prepareBG( bool force = false );
  int getHScrollStep() const;
};

#endif
